/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.xa;

import com.atomikos.datasource.xa.XID;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.ParticipantLogEntry;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.recovery.xa.XaRecoveryLog;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DefaultXaRecoveryLog
implements XaRecoveryLog {
    private RecoveryLog log;

    public DefaultXaRecoveryLog(RecoveryLog log) {
        this.log = log;
    }

    @Override
    public void presumedAborting(XID xid) throws IllegalStateException, LogException {
        ParticipantLogEntry entry = this.convertXidToParticipantLogEntry(xid, TxState.IN_DOUBT);
        this.log.presumedAborting(entry);
    }

    @Override
    public void terminated(XID xid) {
        ParticipantLogEntry entry = this.convertXidToParticipantLogEntry(xid, TxState.TERMINATED);
        this.log.terminated(entry);
    }

    private ParticipantLogEntry convertXidToParticipantLogEntry(XID xid, TxState state) {
        ParticipantLogEntry entry = new ParticipantLogEntry(xid.getGlobalTransactionIdAsString(), xid.getBranchQualifierAsString(), 0L, xid.toString(), state);
        return entry;
    }

    @Override
    public Set<XID> getExpiredCommittingXids() throws LogReadException {
        HashSet<XID> ret = new HashSet<XID>();
        Collection<ParticipantLogEntry> entries = this.log.getCommittingParticipants();
        for (ParticipantLogEntry entry : entries) {
            if (!this.expired(entry) || this.http(entry)) continue;
            XID xid = new XID(entry.coordinatorId, entry.uri);
            ret.add(xid);
        }
        return ret;
    }

    private boolean http(ParticipantLogEntry entry) {
        return entry.uri.startsWith("http");
    }

    private boolean expired(ParticipantLogEntry entry) {
        long now = System.currentTimeMillis();
        return now > entry.expires;
    }

    @Override
    public void terminatedWithHeuristicHazardByResource(XID xid) throws LogException {
        ParticipantLogEntry entry = this.convertXidToParticipantLogEntry(xid, TxState.HEUR_HAZARD);
        this.log.terminatedWithHeuristicHazard(entry);
    }

    @Override
    public void terminatedWithHeuristicCommitByResource(XID xid) throws LogException {
        ParticipantLogEntry entry = this.convertXidToParticipantLogEntry(xid, TxState.HEUR_COMMITTED);
        this.log.terminatedWithHeuristicCommit(entry);
    }

    @Override
    public void terminatedWithHeuristicMixedByResource(XID xid) throws LogException {
        ParticipantLogEntry entry = this.convertXidToParticipantLogEntry(xid, TxState.HEUR_MIXED);
        this.log.terminatedWithHeuristicMixed(entry);
    }

    @Override
    public void terminatedWithHeuristicRollbackByResource(XID xid) throws LogException {
        ParticipantLogEntry entry = this.convertXidToParticipantLogEntry(xid, TxState.HEUR_ABORTED);
        this.log.terminatedWithHeuristicRollback(entry);
    }
}

