/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.clustering.it.provider.impl.FinalizableScheduledExecutorService;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.TransactionsParams;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTransactionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransactionHandler.class);
    static final int SECOND_AS_NANO = 1000000000;
    static final int MAX_ITEM = 0x100000;
    static final QName ID_INTS = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"id-ints").intern();
    static final QName ID = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"id").intern();
    static final QName ITEM = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"item").intern();
    static final QName NUMBER = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"number").intern();
    public static final QName ID_INT = QName.create((String)"tag:opendaylight.org,2017:controller:yang:lowlevel:target", (String)"2017-02-15", (String)"id-int").intern();
    public static final YangInstanceIdentifier ID_INTS_YID = YangInstanceIdentifier.of((QName)ID_INTS);
    public static final YangInstanceIdentifier ID_INT_YID = ID_INTS_YID.node(ID_INT).toOptimized();
    static final long INIT_TX_TIMEOUT_SECONDS = 125L;
    private static final long DEAD_TIMEOUT_SECONDS = TimeUnit.MINUTES.toSeconds(15L);
    private final ScheduledExecutorService writingExecutor = FinalizableScheduledExecutorService.newSingleThread();
    private final ScheduledExecutorService completingExecutor = FinalizableScheduledExecutorService.newSingleThread();
    private final Collection<ListenableFuture<?>> futures = Collections.synchronizedSet(new HashSet());
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final long runtimeNanos;
    private final long delayNanos;
    private ScheduledFuture<?> writingFuture;
    private ScheduledFuture<?> completingFuture;
    private final AtomicLong txCounter = new AtomicLong();
    private volatile State state;

    AbstractTransactionHandler(TransactionsParams params) {
        this.runtimeNanos = TimeUnit.SECONDS.toNanos(params.getSeconds());
        this.delayNanos = 1000000000L / params.getTransactionsPerSecond();
    }

    final synchronized void doStart() {
        this.stopwatch.start();
        this.state = State.RUNNING;
        this.writingFuture = this.writingExecutor.scheduleAtFixedRate(this::execute, 0L, this.delayNanos, TimeUnit.NANOSECONDS);
    }

    private void execute() {
        State local = this.state;
        switch (local) {
            case FAILED: {
                break;
            }
            case RUNNING: {
                this.runningExecute();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled state " + (Object)((Object)local));
            }
        }
    }

    private void runningExecute() {
        long elapsed = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        if (elapsed >= this.runtimeNanos) {
            LOG.debug("Reached maximum run time with {} outstanding futures", (Object)this.futures.size());
            this.completingExecutor.schedule(this::runtimeUp, 0L, TimeUnit.SECONDS);
            return;
        }
        final long txId = this.txCounter.incrementAndGet();
        final ListenableFuture<?> execFuture = this.execWrite(txId);
        LOG.debug("New future #{} allocated", (Object)txId);
        this.futures.add(execFuture);
        Futures.addCallback(execFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                AbstractTransactionHandler.this.txSuccess(execFuture, txId);
            }

            public void onFailure(Throwable cause) {
                AbstractTransactionHandler.this.txFailure(execFuture, txId, cause);
            }
        }, (Executor)this.completingExecutor);
    }

    private void runtimeUp() {
        this.completingFuture = this.completingExecutor.schedule(this::checkComplete, DEAD_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        if (!this.checkSuccessful()) {
            this.state = State.WAITING;
            this.writingFuture.cancel(false);
        }
    }

    private boolean checkSuccessful() {
        if (this.futures.isEmpty()) {
            LOG.debug("Completed waiting for all futures");
            this.state = State.SUCCESSFUL;
            this.completingFuture.cancel(false);
            this.runSuccessful(this.txCounter.get());
            return true;
        }
        return false;
    }

    final void txSuccess(ListenableFuture<?> execFuture, long txId) {
        LOG.debug("Future #{} completed successfully", (Object)txId);
        this.futures.remove(execFuture);
        State local = this.state;
        switch (local) {
            case FAILED: 
            case RUNNING: {
                break;
            }
            case WAITING: {
                this.checkSuccessful();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled state " + (Object)((Object)local));
            }
        }
    }

    final void txFailure(ListenableFuture<?> execFuture, long txId, Throwable cause) {
        LOG.error("Commit future failed for tx # {}", (Object)txId, (Object)cause);
        this.futures.remove(execFuture);
        State local = this.state;
        switch (local) {
            case FAILED: {
                break;
            }
            case RUNNING: 
            case WAITING: {
                this.state = State.FAILED;
                this.writingFuture.cancel(false);
                this.runFailed(cause, txId);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled state " + (Object)((Object)local));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkComplete() {
        int size = this.futures.size();
        if (size == 0) {
            return;
        }
        Collection<ListenableFuture<?>> collection = this.futures;
        synchronized (collection) {
            int offset = 0;
            for (ListenableFuture<?> future : this.futures) {
                try {
                    future.get(0L, TimeUnit.NANOSECONDS);
                }
                catch (TimeoutException e) {
                    LOG.warn("Future #{}/{} not completed yet", (Object)offset, (Object)size);
                }
                catch (ExecutionException e) {
                    LOG.warn("Future #{}/{} failed", new Object[]{offset, size, e.getCause()});
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while examining future #{}/{}", new Object[]{offset, size, e});
                }
                ++offset;
            }
        }
        this.state = State.FAILED;
        this.runTimedOut("Transactions did not finish in " + DEAD_TIMEOUT_SECONDS + " seconds");
    }

    abstract ListenableFuture<?> execWrite(long var1);

    abstract void runFailed(Throwable var1, long var2);

    abstract void runSuccessful(long var1);

    abstract void runTimedOut(String var1);

    private static enum State {
        RUNNING,
        WAITING,
        SUCCESSFUL,
        FAILED;

    }
}

