/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.BuyCarInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.BuyCarOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.BuyCarOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarBoughtBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarPurchaseService;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseCarProvider
implements CarPurchaseService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PurchaseCarProvider.class);
    private NotificationProviderService notificationProvider;

    public void setNotificationProvider(NotificationProviderService salService) {
        this.notificationProvider = salService;
    }

    public ListenableFuture<RpcResult<BuyCarOutput>> buyCar(BuyCarInput input) {
        LOG.info("Routed RPC buyCar : generating notification for buying car [{}]", (Object)input);
        SettableFuture futureResult = SettableFuture.create();
        CarBoughtBuilder carBoughtBuilder = new CarBoughtBuilder();
        carBoughtBuilder.setCarId(input.getCarId());
        carBoughtBuilder.setPersonId(input.getPersonId());
        this.notificationProvider.publish((Notification)carBoughtBuilder.build());
        futureResult.set((Object)RpcResultBuilder.success((Object)new BuyCarOutputBuilder().build()).build());
        return futureResult;
    }

    @Override
    public void close() {
    }
}

