/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.util.messages.SendErrorExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeserializerExceptionHandler
implements ChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeserializerExceptionHandler.class);

    public void handlerAdded(ChannelHandlerContext ctx) {
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.warn("An exception occurred during message handling", cause);
        DeserializerExceptionHandler.handleDeserializerException(ctx, cause);
    }

    private static void handleDeserializerException(ChannelHandlerContext ctx, Throwable cause) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("cause", cause.getMessage());
        DocumentedException ex = new DocumentedException(cause.getMessage(), DocumentedException.ErrorType.RPC, DocumentedException.ErrorTag.MALFORMED_MESSAGE, DocumentedException.ErrorSeverity.ERROR, info);
        SendErrorExceptionUtil.sendErrorMessage((Channel)ctx.channel(), (DocumentedException)ex);
    }
}

