/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.osgi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opendaylight.controller.config.threadpool.ScheduledThreadPool;
import org.opendaylight.netconf.api.monitoring.NetconfManagementSession;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.api.monitoring.SessionEvent;
import org.opendaylight.netconf.api.monitoring.SessionListener;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.SessionsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetconfSessionMonitoringService
implements SessionListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfSessionMonitoringService.class);
    private final Set<NetconfManagementSession> sessions = new HashSet<NetconfManagementSession>();
    private final Set<NetconfManagementSession> changedSessions = new HashSet<NetconfManagementSession>();
    private final Set<NetconfMonitoringService.SessionsListener> listeners = new HashSet<NetconfMonitoringService.SessionsListener>();
    private final ScheduledExecutorService executor;
    private final long updateInterval;
    private boolean running;

    NetconfSessionMonitoringService(Optional<ScheduledThreadPool> schedulingThreadPool, long updateInterval) {
        this.updateInterval = updateInterval;
        if (schedulingThreadPool.isPresent() && updateInterval > 0L) {
            this.executor = schedulingThreadPool.get().getExecutor();
            LOG.info("/netconf-state/sessions will be updated every {} seconds.", (Object)updateInterval);
        } else {
            LOG.info("Scheduling thread pool is present = {}, update interval {}: /netconf-state/sessions won't be updated.", (Object)schedulingThreadPool.isPresent(), (Object)updateInterval);
            this.executor = null;
        }
    }

    synchronized Sessions getSessions() {
        Collection managementSessions = Collections2.transform(this.sessions, NetconfManagementSession::toManagementSession);
        return new SessionsBuilder().setSession((List)ImmutableList.copyOf((Collection)managementSessions)).build();
    }

    public synchronized void onSessionUp(NetconfManagementSession session) {
        LOG.debug("Session {} up", (Object)session);
        Preconditions.checkState((!this.sessions.contains(session) ? 1 : 0) != 0, (String)"Session %s was already added", (Object)session);
        this.sessions.add(session);
        this.notifySessionUp(session);
    }

    public synchronized void onSessionDown(NetconfManagementSession session) {
        LOG.debug("Session {} down", (Object)session);
        Preconditions.checkState((boolean)this.sessions.contains(session), (String)"Session %s not present", (Object)session);
        this.sessions.remove(session);
        this.changedSessions.remove(session);
        this.notifySessionDown(session);
    }

    public synchronized void onSessionEvent(SessionEvent event) {
        this.changedSessions.add(event.getSession());
    }

    synchronized AutoCloseable registerListener(NetconfMonitoringService.SessionsListener listener) {
        this.listeners.add(listener);
        if (!this.running) {
            this.startUpdateSessionStats();
        }
        return () -> this.listeners.remove(listener);
    }

    @Override
    public synchronized void close() {
        this.stopUpdateSessionStats();
        this.listeners.clear();
        this.sessions.clear();
    }

    private synchronized void updateSessionStats() {
        if (this.changedSessions.isEmpty()) {
            return;
        }
        List changed = this.changedSessions.stream().map(NetconfManagementSession::toManagementSession).collect(Collectors.toList());
        ImmutableList sessionImmutableList = ImmutableList.copyOf(changed);
        for (NetconfMonitoringService.SessionsListener listener : this.listeners) {
            listener.onSessionsUpdated((Collection)sessionImmutableList);
        }
        this.changedSessions.clear();
    }

    private void notifySessionUp(NetconfManagementSession managementSession) {
        Session session = managementSession.toManagementSession();
        for (NetconfMonitoringService.SessionsListener listener : this.listeners) {
            listener.onSessionStarted(session);
        }
    }

    private void notifySessionDown(NetconfManagementSession managementSession) {
        Session session = managementSession.toManagementSession();
        for (NetconfMonitoringService.SessionsListener listener : this.listeners) {
            listener.onSessionEnded(session);
        }
    }

    private void startUpdateSessionStats() {
        if (this.executor != null) {
            this.executor.scheduleAtFixedRate(this::updateSessionStats, 1L, this.updateInterval, TimeUnit.SECONDS);
            this.running = true;
        }
    }

    private void stopUpdateSessionStats() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.running = false;
        }
    }
}

