/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.osgi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.impl.NetconfServerSession;
import org.opendaylight.netconf.impl.mapping.operations.DefaultCloseSession;
import org.opendaylight.netconf.impl.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.netconf.impl.mapping.operations.DefaultStartExi;
import org.opendaylight.netconf.impl.mapping.operations.DefaultStopExi;
import org.opendaylight.netconf.impl.osgi.NetconfOperationRouter;
import org.opendaylight.netconf.mapping.api.HandlingPriority;
import org.opendaylight.netconf.mapping.api.NetconfOperation;
import org.opendaylight.netconf.mapping.api.NetconfOperationChainedExecution;
import org.opendaylight.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.netconf.mapping.api.SessionAwareNetconfOperation;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NetconfOperationRouterImpl
implements NetconfOperationRouter {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfOperationRouterImpl.class);
    private final NetconfOperationService netconfOperationServiceSnapshot;
    private final Collection<NetconfOperation> allNetconfOperations;

    public NetconfOperationRouterImpl(NetconfOperationService netconfOperationServiceSnapshot, NetconfMonitoringService netconfMonitoringService, String sessionId) {
        this.netconfOperationServiceSnapshot = (NetconfOperationService)Preconditions.checkNotNull((Object)netconfOperationServiceSnapshot);
        HashSet<AbstractSingletonNetconfOperation> ops = new HashSet<AbstractSingletonNetconfOperation>();
        ops.add(new DefaultCloseSession(sessionId, this));
        ops.add(new DefaultStartExi(sessionId));
        ops.add(new DefaultStopExi(sessionId));
        ops.addAll(netconfOperationServiceSnapshot.getNetconfOperations());
        this.allNetconfOperations = ImmutableSet.copyOf(ops);
    }

    @Override
    public Document onNetconfMessage(Document message, NetconfServerSession session) throws DocumentedException {
        NetconfOperationExecution netconfOperationExecution;
        Preconditions.checkNotNull(this.allNetconfOperations, (Object)"Operation router was not initialized properly");
        try {
            netconfOperationExecution = this.getNetconfOperationWithHighestPriority(message, session);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            String messageAsString = XmlUtil.toString((Document)message);
            LOG.warn("Unable to handle rpc {} on session {}", new Object[]{messageAsString, session, e});
            DocumentedException.ErrorTag tag = e instanceof IllegalArgumentException ? DocumentedException.ErrorTag.OPERATION_NOT_SUPPORTED : DocumentedException.ErrorTag.OPERATION_FAILED;
            throw new DocumentedException(String.format("Unable to handle rpc %s on session %s", new Object[]{messageAsString, session}), (Exception)e, DocumentedException.ErrorType.APPLICATION, tag, DocumentedException.ErrorSeverity.ERROR, Collections.singletonMap(tag.toString(), e.getMessage()));
        }
        catch (RuntimeException e) {
            throw NetconfOperationRouterImpl.handleUnexpectedEx("sort", e);
        }
        try {
            return NetconfOperationRouterImpl.executeOperationWithHighestPriority(message, netconfOperationExecution);
        }
        catch (RuntimeException e) {
            throw NetconfOperationRouterImpl.handleUnexpectedEx("execution", e);
        }
    }

    @Override
    public void close() {
        this.netconfOperationServiceSnapshot.close();
    }

    private static DocumentedException handleUnexpectedEx(String op, Exception exception) {
        LOG.error("Unexpected exception during netconf operation {}", (Object)op, (Object)exception);
        return new DocumentedException("Unexpected error", DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.ERROR, Collections.singletonMap(DocumentedException.ErrorSeverity.ERROR.toString(), exception.toString()));
    }

    private static Document executeOperationWithHighestPriority(Document message, NetconfOperationExecution netconfOperationExecution) throws DocumentedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding netconf message {} to {}", (Object)XmlUtil.toString((Document)message), (Object)netconfOperationExecution.netconfOperation);
        }
        return netconfOperationExecution.execute(message);
    }

    private NetconfOperationExecution getNetconfOperationWithHighestPriority(Document message, NetconfServerSession session) throws DocumentedException {
        TreeMap<HandlingPriority, NetconfOperation> sortedByPriority = this.getSortedNetconfOperationsWithCanHandle(message, session);
        if (sortedByPriority.isEmpty()) {
            throw new IllegalArgumentException(String.format("No %s available to handle message %s", NetconfOperation.class.getName(), XmlUtil.toString((Document)message)));
        }
        return NetconfOperationExecution.createExecutionChain(sortedByPriority, (HandlingPriority)sortedByPriority.lastKey());
    }

    private TreeMap<HandlingPriority, NetconfOperation> getSortedNetconfOperationsWithCanHandle(Document message, NetconfServerSession session) throws DocumentedException {
        TreeMap<HandlingPriority, NetconfOperation> sortedPriority = new TreeMap<HandlingPriority, NetconfOperation>();
        for (NetconfOperation netconfOperation : this.allNetconfOperations) {
            HandlingPriority handlingPriority = netconfOperation.canHandle(message);
            if (netconfOperation instanceof DefaultNetconfOperation) {
                ((DefaultNetconfOperation)netconfOperation).setNetconfSession(session);
            }
            if (netconfOperation instanceof SessionAwareNetconfOperation) {
                ((SessionAwareNetconfOperation)netconfOperation).setSession((NetconfSession)session);
            }
            if (handlingPriority.equals((Object)HandlingPriority.CANNOT_HANDLE)) continue;
            Preconditions.checkState((!sortedPriority.containsKey(handlingPriority) ? 1 : 0) != 0, (String)"Multiple %s available to handle message %s with priority %s, %s and %s", (Object[])new Object[]{NetconfOperation.class.getName(), message, handlingPriority, netconfOperation, sortedPriority.get(handlingPriority)});
            sortedPriority.put(handlingPriority, netconfOperation);
        }
        return sortedPriority;
    }

    public String toString() {
        return "NetconfOperationRouterImpl{netconfOperationServiceSnapshot=" + this.netconfOperationServiceSnapshot + '}';
    }

    private static final class NetconfOperationExecution
    implements NetconfOperationChainedExecution {
        private final NetconfOperation netconfOperation;
        private final NetconfOperationChainedExecution subsequentExecution;

        private NetconfOperationExecution(NetconfOperation netconfOperation, NetconfOperationChainedExecution subsequentExecution) {
            this.netconfOperation = netconfOperation;
            this.subsequentExecution = subsequentExecution;
        }

        public boolean isExecutionTermination() {
            return false;
        }

        public Document execute(Document message) throws DocumentedException {
            return this.netconfOperation.handle(message, this.subsequentExecution);
        }

        public static NetconfOperationExecution createExecutionChain(NavigableMap<HandlingPriority, NetconfOperation> sortedByPriority, HandlingPriority handlingPriority) {
            NetconfOperation netconfOperation = (NetconfOperation)sortedByPriority.get(handlingPriority);
            HandlingPriority subsequentHandlingPriority = sortedByPriority.lowerKey(handlingPriority);
            NetconfOperationChainedExecution subsequentExecution = null;
            subsequentExecution = subsequentHandlingPriority != null ? NetconfOperationExecution.createExecutionChain(sortedByPriority, subsequentHandlingPriority) : EXECUTION_TERMINATION_POINT;
            return new NetconfOperationExecution(netconfOperation, subsequentExecution);
        }
    }
}

