/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.osgi;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.netconf.api.capability.BasicCapability;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.netconf.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.CapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.SchemasBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChangeBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedByBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.ServerOrUser;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.server.or.user.ServerBuilder;

class NetconfCapabilityMonitoringService
implements CapabilityListener,
AutoCloseable {
    private static final Schema.Location NETCONF_LOCATION = new Schema.Location(Schema.Location.Enumeration.NETCONF);
    private static final List<Schema.Location> NETCONF_LOCATIONS = ImmutableList.of((Object)NETCONF_LOCATION);
    private static final BasicCapability CANDIDATE_CAPABILITY = new BasicCapability("urn:ietf:params:netconf:capability:candidate:1.0");
    private static final BasicCapability URL_CAPABILITY = new BasicCapability("urn:ietf:params:netconf:capability:url:1.0?scheme=file");
    private static final Function<Capability, Uri> CAPABILITY_TO_URI = input -> new Uri(input.getCapabilityUri());
    private final NetconfOperationServiceFactory netconfOperationProvider;
    private final Map<Uri, Capability> capabilities = new HashMap<Uri, Capability>();
    private final Map<String, Map<String, String>> mappedModulesToRevisionToSchema = new HashMap<String, Map<String, String>>();
    private final Set<NetconfMonitoringService.CapabilitiesListener> listeners = new HashSet<NetconfMonitoringService.CapabilitiesListener>();
    private volatile BaseNotificationPublisherRegistration notificationPublisher;

    NetconfCapabilityMonitoringService(NetconfOperationServiceFactory netconfOperationProvider) {
        this.netconfOperationProvider = netconfOperationProvider;
        netconfOperationProvider.registerCapabilityListener((CapabilityListener)this);
    }

    synchronized Schemas getSchemas() {
        try {
            return NetconfCapabilityMonitoringService.transformSchemas(this.netconfOperationProvider.getCapabilities());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while closing", e);
        }
    }

    synchronized String getSchemaForModuleRevision(String moduleName, Optional<String> revision) {
        Map<String, String> revisionMapRequest = this.mappedModulesToRevisionToSchema.get(moduleName);
        Preconditions.checkState((revisionMapRequest != null ? 1 : 0) != 0, (String)"Capability for module %s not present, available modules : %s", (Object)moduleName, (Object)Collections2.transform(this.capabilities.values(), CAPABILITY_TO_URI));
        if (revision.isPresent()) {
            String schema = revisionMapRequest.get(revision.get());
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Capability for module %s:%s not present, available revisions for module: %s", (Object)moduleName, (Object)revision.get(), revisionMapRequest.keySet());
            return schema;
        }
        Preconditions.checkState((revisionMapRequest.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 capability for module %s, available revisions : %s", (Object)moduleName, revisionMapRequest.keySet());
        return revisionMapRequest.values().iterator().next();
    }

    private void updateCapabilityToSchemaMap(Set<Capability> added, Set<Capability> removed) {
        for (Capability cap : added) {
            if (!NetconfCapabilityMonitoringService.isValidModuleCapability(cap)) continue;
            String currentModuleName = (String)cap.getModuleName().get();
            Map revisionMap = this.mappedModulesToRevisionToSchema.computeIfAbsent(currentModuleName, k -> new HashMap());
            String currentRevision = (String)cap.getRevision().get();
            revisionMap.put(currentRevision, cap.getCapabilitySchema().get());
        }
        for (Capability cap : removed) {
            Map<String, String> revisionMap;
            if (!NetconfCapabilityMonitoringService.isValidModuleCapability(cap) || (revisionMap = this.mappedModulesToRevisionToSchema.get(cap.getModuleName().get())) == null) continue;
            revisionMap.remove(cap.getRevision().get());
            if (!revisionMap.isEmpty()) continue;
            this.mappedModulesToRevisionToSchema.remove(cap.getModuleName().get());
        }
    }

    private static boolean isValidModuleCapability(Capability cap) {
        return cap.getModuleName().isPresent() && cap.getRevision().isPresent() && cap.getCapabilitySchema().isPresent();
    }

    synchronized Capabilities getCapabilities() {
        return new CapabilitiesBuilder().setCapability((List)Lists.newArrayList(this.capabilities.keySet())).build();
    }

    synchronized AutoCloseable registerListener(NetconfMonitoringService.CapabilitiesListener listener) {
        this.listeners.add(listener);
        listener.onCapabilitiesChanged(this.getCapabilities());
        listener.onSchemasChanged(this.getSchemas());
        return () -> {
            NetconfCapabilityMonitoringService netconfCapabilityMonitoringService = this;
            synchronized (netconfCapabilityMonitoringService) {
                this.listeners.remove(listener);
            }
        };
    }

    private static Schemas transformSchemas(Set<Capability> caps) {
        ArrayList<Schema> schemas = new ArrayList<Schema>(caps.size());
        for (Capability cap : caps) {
            if (!cap.getCapabilitySchema().isPresent()) continue;
            SchemaBuilder builder = new SchemaBuilder();
            Preconditions.checkState((boolean)NetconfCapabilityMonitoringService.isValidModuleCapability(cap));
            builder.setNamespace(new Uri((String)cap.getModuleNamespace().get()));
            String version = (String)cap.getRevision().get();
            builder.setVersion(version);
            String identifier = (String)cap.getModuleName().get();
            builder.setIdentifier(identifier);
            builder.setFormat(Yang.class);
            builder.setLocation(NetconfCapabilityMonitoringService.transformLocations(cap.getLocation()));
            builder.withKey(new SchemaKey(Yang.class, identifier, version));
            schemas.add(builder.build());
        }
        return new SchemasBuilder().setSchema(schemas).build();
    }

    private static List<Schema.Location> transformLocations(Collection<String> locations) {
        if (locations.isEmpty()) {
            return NETCONF_LOCATIONS;
        }
        ImmutableList.Builder b = ImmutableList.builder();
        b.add((Object)NETCONF_LOCATION);
        for (String location : locations) {
            b.add((Object)new Schema.Location(new Uri(location)));
        }
        return b.build();
    }

    private static Set<Capability> setupCapabilities(Set<Capability> caps) {
        HashSet<Capability> capabilities = new HashSet<Capability>(caps);
        capabilities.add((Capability)CANDIDATE_CAPABILITY);
        capabilities.add((Capability)URL_CAPABILITY);
        return capabilities;
    }

    @Override
    public synchronized void close() {
        this.listeners.clear();
        this.capabilities.clear();
    }

    public synchronized void onCapabilitiesChanged(Set<Capability> added, Set<Capability> removed) {
        this.onCapabilitiesAdded(added);
        this.onCapabilitiesRemoved(removed);
        this.updateCapabilityToSchemaMap(added, removed);
        this.notifyCapabilityChanged(this.getCapabilities());
        if (this.notificationPublisher != null) {
            this.notificationPublisher.onCapabilityChanged(NetconfCapabilityMonitoringService.computeDiff(added, removed));
        }
    }

    private void notifyCapabilityChanged(Capabilities newCapabilities) {
        for (NetconfMonitoringService.CapabilitiesListener listener : this.listeners) {
            listener.onCapabilitiesChanged(newCapabilities);
            listener.onSchemasChanged(this.getSchemas());
        }
    }

    private static NetconfCapabilityChange computeDiff(Set<Capability> added, Set<Capability> removed) {
        NetconfCapabilityChangeBuilder netconfCapabilityChangeBuilder = new NetconfCapabilityChangeBuilder();
        netconfCapabilityChangeBuilder.setChangedBy(new ChangedByBuilder().setServerOrUser((ServerOrUser)new ServerBuilder().setServer(Boolean.TRUE).build()).build());
        netconfCapabilityChangeBuilder.setDeletedCapability((List)Lists.newArrayList((Iterable)Collections2.transform(removed, CAPABILITY_TO_URI)));
        netconfCapabilityChangeBuilder.setAddedCapability((List)Lists.newArrayList((Iterable)Collections2.transform(added, CAPABILITY_TO_URI)));
        netconfCapabilityChangeBuilder.setModifiedCapability(Collections.emptyList());
        return netconfCapabilityChangeBuilder.build();
    }

    private void onCapabilitiesAdded(Set<Capability> addedCaps) {
        this.capabilities.putAll((Map<Uri, Capability>)Maps.uniqueIndex(NetconfCapabilityMonitoringService.setupCapabilities(addedCaps), CAPABILITY_TO_URI));
    }

    private void onCapabilitiesRemoved(Set<Capability> removedCaps) {
        for (Capability addedCap : removedCaps) {
            this.capabilities.remove(new Uri(addedCap.getCapabilityUri()));
        }
    }

    void setNotificationPublisher(BaseNotificationPublisherRegistration notificationPublisher) {
        this.notificationPublisher = notificationPublisher;
    }
}

