/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl.mapping.operations;

import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.impl.NetconfServerSession;
import org.opendaylight.netconf.impl.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultStopExi
extends AbstractSingletonNetconfOperation
implements DefaultNetconfOperation {
    public static final String STOP_EXI = "stop-exi";
    private NetconfServerSession netconfSession;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStopExi.class);

    public DefaultStopExi(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) {
        LOG.debug("Received stop-exi message {} ", (Object)XmlUtil.toString((XmlElement)operationElement));
        this.netconfSession.stopExiCommunication();
        Element getSchemaResult = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "ok");
        LOG.trace("{} operation successful", (Object)STOP_EXI);
        return getSchemaResult;
    }

    protected String getOperationName() {
        return STOP_EXI;
    }

    protected String getOperationNamespace() {
        return "urn:ietf:params:xml:ns:netconf:exi:1.0";
    }

    @Override
    public void setNetconfSession(NetconfServerSession netconfServerSession) {
        this.netconfSession = netconfServerSession;
    }
}

