/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.Promise;
import org.opendaylight.netconf.api.NetconfSessionListenerFactory;
import org.opendaylight.netconf.impl.NetconfServerSession;
import org.opendaylight.netconf.impl.NetconfServerSessionListener;
import org.opendaylight.netconf.impl.NetconfServerSessionNegotiatorFactory;
import org.opendaylight.netconf.impl.util.DeserializerExceptionHandler;
import org.opendaylight.netconf.nettyutil.AbstractChannelInitializer;

public class ServerChannelInitializer
extends AbstractChannelInitializer<NetconfServerSession> {
    public static final String DESERIALIZER_EX_HANDLER_KEY = "deserializerExHandler";
    private final NetconfServerSessionNegotiatorFactory negotiatorFactory;

    public ServerChannelInitializer(NetconfServerSessionNegotiatorFactory negotiatorFactory) {
        this.negotiatorFactory = negotiatorFactory;
    }

    protected void initializeMessageDecoder(Channel ch) {
        super.initializeMessageDecoder(ch);
        ch.pipeline().addLast(DESERIALIZER_EX_HANDLER_KEY, (ChannelHandler)new DeserializerExceptionHandler());
    }

    protected void initializeSessionNegotiator(Channel ch, Promise<NetconfServerSession> promise) {
        ch.pipeline().addAfter(DESERIALIZER_EX_HANDLER_KEY, "negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator((NetconfSessionListenerFactory<NetconfServerSessionListener>)null, ch, promise));
    }
}

