/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl;

import com.google.common.base.Preconditions;
import io.netty.util.Timer;
import java.util.Set;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.impl.NetconfServerSessionNegotiatorFactory;
import org.opendaylight.netconf.impl.SessionIdProvider;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;

public class NetconfServerSessionNegotiatorFactoryBuilder {
    private Timer timer;
    private SessionIdProvider idProvider;
    private NetconfOperationServiceFactory aggregatedOpService;
    private long connectionTimeoutMillis;
    private NetconfMonitoringService monitoringService;
    private Set<String> baseCapabilities;

    public NetconfServerSessionNegotiatorFactoryBuilder setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public NetconfServerSessionNegotiatorFactoryBuilder setIdProvider(SessionIdProvider idProvider) {
        this.idProvider = idProvider;
        return this;
    }

    public NetconfServerSessionNegotiatorFactoryBuilder setAggregatedOpService(NetconfOperationServiceFactory aggregatedOpService) {
        this.aggregatedOpService = aggregatedOpService;
        return this;
    }

    public NetconfServerSessionNegotiatorFactoryBuilder setConnectionTimeoutMillis(long connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        return this;
    }

    public NetconfServerSessionNegotiatorFactoryBuilder setMonitoringService(NetconfMonitoringService monitoringService) {
        this.monitoringService = monitoringService;
        return this;
    }

    public NetconfServerSessionNegotiatorFactoryBuilder setBaseCapabilities(Set<String> baseCapabilities) {
        this.baseCapabilities = baseCapabilities;
        return this;
    }

    public NetconfServerSessionNegotiatorFactory build() {
        this.validate();
        return new NetconfServerSessionNegotiatorFactory(this.timer, this.aggregatedOpService, this.idProvider, this.connectionTimeoutMillis, this.monitoringService, this.baseCapabilities);
    }

    private void validate() {
        Preconditions.checkNotNull((Object)this.timer, (Object)"timer not initialized");
        Preconditions.checkNotNull((Object)this.aggregatedOpService, (Object)"NetconfOperationServiceFactory not initialized");
        Preconditions.checkNotNull((Object)this.idProvider, (Object)"SessionIdProvider not initialized");
        Preconditions.checkArgument((this.connectionTimeoutMillis > 0L ? 1 : 0) != 0, (Object)"connection time out <=0");
        Preconditions.checkNotNull((Object)this.monitoringService, (Object)"NetconfMonitoringService not initialized");
        this.baseCapabilities = this.baseCapabilities == null ? NetconfServerSessionNegotiatorFactory.DEFAULT_BASE_CAPABILITIES : this.baseCapabilities;
    }
}

