/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.monitoring.NetconfManagementSession;
import org.opendaylight.netconf.impl.NetconfServerSessionListener;
import org.opendaylight.netconf.nettyutil.AbstractNetconfSession;
import org.opendaylight.netconf.nettyutil.handler.NetconfMessageToXMLEncoder;
import org.opendaylight.netconf.nettyutil.handler.NetconfXMLToMessageDecoder;
import org.opendaylight.netconf.notifications.NetconfNotification;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.NetconfTcp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.Session1;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.Session1Builder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfSsh;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Transport;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.SessionBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.SessionKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ZeroBasedCounter32;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfServerSession
extends AbstractNetconfSession<NetconfServerSession, NetconfServerSessionListener>
implements NetconfManagementSession {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfServerSession.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final String DATE_TIME_PATTERN_STRING = (String)DateAndTime.PATTERN_CONSTANTS.get(0);
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile(DATE_TIME_PATTERN_STRING);
    private final NetconfHelloMessageAdditionalHeader header;
    private final NetconfServerSessionListener sessionListener;
    private ZonedDateTime loginTime;
    private long inRpcSuccess;
    private long inRpcFail;
    private long outRpcError;
    private long outNotification;
    private volatile boolean delayedClose;

    public NetconfServerSession(NetconfServerSessionListener sessionListener, Channel channel, long sessionId, NetconfHelloMessageAdditionalHeader header) {
        super((NetconfSessionListener)sessionListener, channel, sessionId);
        this.header = header;
        this.sessionListener = sessionListener;
        LOG.debug("Session {} created", (Object)this.toString());
    }

    protected void sessionUp() {
        Preconditions.checkState((this.loginTime == null ? 1 : 0) != 0, (Object)"Session is already up");
        this.loginTime = Instant.now().atZone(ZoneId.systemDefault());
        super.sessionUp();
    }

    public void delayedClose() {
        this.delayedClose = true;
    }

    public ChannelFuture sendMessage(NetconfMessage netconfMessage) {
        ChannelFuture channelFuture = super.sendMessage(netconfMessage);
        if (netconfMessage instanceof NetconfNotification) {
            ++this.outNotification;
            this.sessionListener.onNotification(this, (NetconfNotification)netconfMessage);
        }
        if (this.delayedClose) {
            channelFuture.addListener(future -> this.close());
        }
        return channelFuture;
    }

    public void onIncommingRpcSuccess() {
        ++this.inRpcSuccess;
    }

    public void onIncommingRpcFail() {
        ++this.inRpcFail;
    }

    public void onOutgoingRpcError() {
        ++this.outRpcError;
    }

    public Session toManagementSession() {
        SessionBuilder builder = new SessionBuilder();
        builder.setSessionId(Long.valueOf(this.getSessionId()));
        InetAddress address1 = InetAddresses.forString((String)this.header.getAddress());
        IpAddress address = address1 instanceof Inet4Address ? new IpAddress(new Ipv4Address(this.header.getAddress())) : new IpAddress(new Ipv6Address(this.header.getAddress()));
        builder.setSourceHost(new Host(address));
        Preconditions.checkState((DateAndTime.PATTERN_CONSTANTS.size() == 1 ? 1 : 0) != 0);
        String formattedDateTime = DATE_FORMATTER.format(this.loginTime);
        Matcher matcher = DATE_TIME_PATTERN.matcher(formattedDateTime);
        Preconditions.checkState((boolean)matcher.matches(), (String)"Formatted datetime %s does not match pattern %s", (Object)formattedDateTime, (Object)DATE_TIME_PATTERN);
        builder.setLoginTime(new DateAndTime(formattedDateTime));
        builder.setInBadRpcs(new ZeroBasedCounter32(Long.valueOf(this.inRpcFail)));
        builder.setInRpcs(new ZeroBasedCounter32(Long.valueOf(this.inRpcSuccess)));
        builder.setOutRpcErrors(new ZeroBasedCounter32(Long.valueOf(this.outRpcError)));
        builder.setUsername(this.header.getUserName());
        builder.setTransport(NetconfServerSession.getTransportForString(this.header.getTransport()));
        builder.setOutNotifications(new ZeroBasedCounter32(Long.valueOf(this.outNotification)));
        builder.withKey(new SessionKey(Long.valueOf(this.getSessionId())));
        Session1Builder builder1 = new Session1Builder();
        builder1.setSessionIdentifier(this.header.getSessionIdentifier());
        builder.addAugmentation(Session1.class, (Augmentation)builder1.build());
        return builder.build();
    }

    private static Class<? extends Transport> getTransportForString(String transport) {
        switch (transport) {
            case "ssh": {
                return NetconfSsh.class;
            }
            case "tcp": {
                return NetconfTcp.class;
            }
        }
        throw new IllegalArgumentException("Unknown transport type " + transport);
    }

    protected NetconfServerSession thisInstance() {
        return this;
    }

    protected void addExiHandlers(ByteToMessageDecoder decoder, MessageToByteEncoder<NetconfMessage> encoder) {
        this.replaceMessageDecoder((ChannelHandler)decoder);
        this.replaceMessageEncoderAfterNextMessage((ChannelHandler)encoder);
    }

    public void stopExiCommunication() {
        this.replaceMessageDecoder((ChannelHandler)new NetconfXMLToMessageDecoder());
        this.replaceMessageEncoderAfterNextMessage((ChannelHandler)new NetconfMessageToXMLEncoder());
    }
}

