/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.karaf.maven.command.MavenConfigurationSupport;
import org.apache.karaf.maven.command.RepositoryEditCommandSupport;
import org.apache.karaf.maven.core.MavenRepositoryURL;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.osgi.service.cm.Configuration;

@Command(scope="maven", name="repository-change", description="Changes configuration of Maven repository")
@Service
public class RepositoryChangeCommand
extends RepositoryEditCommandSupport {
    @Option(name="-s", aliases={"--snapshots"}, description="Enable SNAPSHOT handling in the repository", required=false, multiValued=false)
    boolean snapshots = false;
    @Option(name="-nr", aliases={"--no-releases"}, description="Disable release handling in this repository", required=false, multiValued=false)
    boolean noReleases = false;
    @Option(name="-up", aliases={"--update-policy"}, description="Update policy for repository (never, daily (default), interval:N, always)", required=false, multiValued=false)
    String updatePolicy;
    @Option(name="-cp", aliases={"--checksum-policy"}, description="Checksum policy for repository (ignore, warn (default), fail)", required=false, multiValued=false)
    String checksumPolicy;
    @Option(name="-u", aliases={"--username"}, description="Username for remote repository", required=false, multiValued=false)
    String username;
    @Option(name="-p", aliases={"--password"}, description="Password for remote repository (may be encrypted, see \"maven:password -ep\")", required=false, multiValued=false)
    String password;
    @Argument(description="Repository URI. It may be file:// based, http(s):// based, may use other known protocol or even property placeholders (like ${karaf.base})", required=false)
    String uri;

    @Override
    protected void edit(String prefix, Dictionary<String, Object> config, MavenRepositoryURL[] allRepos, MavenRepositoryURL[] pidRepos, MavenRepositoryURL[] settingsRepos) throws Exception {
        boolean hasCredentials;
        Optional<MavenRepositoryURL> first = Arrays.stream(allRepos).filter(repo -> this.id.equals(repo.getId())).findFirst();
        if (!first.isPresent()) {
            System.err.printf("Can't find %s repository with ID \"%s\"\n", this.defaultRepository ? "default" : "remote", this.id);
            return;
        }
        MavenRepositoryURL changedRepository = first.get();
        changedRepository.setSnapshotsEnabled(this.snapshots);
        changedRepository.setReleasesEnabled(!this.noReleases);
        if (this.updatePolicy != null) {
            MavenConfigurationSupport.SourceAnd<String> up = this.updatePolicy(this.updatePolicy);
            if (!up.valid) {
                System.err.println("Unknown value of update policy: \"" + this.updatePolicy + "\"");
                return;
            }
            changedRepository.setReleasesUpdatePolicy(up.val());
            changedRepository.setSnapshotsUpdatePolicy(up.val());
        }
        if (this.checksumPolicy != null) {
            MavenConfigurationSupport.SourceAnd<String> cp = this.checksumPolicy(this.checksumPolicy);
            if (!cp.valid) {
                System.err.println("Unknown value of checksum policy: \"" + this.checksumPolicy + "\"");
                return;
            }
            changedRepository.setReleasesChecksumPolicy(cp.val());
            changedRepository.setSnapshotsChecksumPolicy(cp.val());
        }
        if (this.uri != null) {
            MavenConfigurationSupport.SourceAnd<String> urlResolved = this.validateRepositoryURL(this.uri, this.defaultRepository);
            if (!urlResolved.valid) {
                return;
            }
            changedRepository.setURL(new URL(urlResolved.val()));
        }
        boolean hasUsername = this.username != null && !"".equals(this.username.trim());
        boolean hasPassword = this.password != null && !"".equals(this.password.trim());
        boolean bl = hasCredentials = hasUsername && hasPassword;
        if (hasUsername && !hasPassword || !hasUsername && hasPassword) {
            System.err.println("Please specify both username and password");
            return;
        }
        if (this.defaultRepository && hasCredentials) {
            System.out.println("User credentials won't be used for default repository");
        }
        boolean credentialsUpdated = false;
        if (!this.defaultRepository && hasCredentials) {
            if (!this.updateCredentials(this.force, this.id, this.username, this.password, prefix, config)) {
                return;
            }
            credentialsUpdated = true;
        }
        if (!this.defaultRepository && changedRepository.getFrom() == MavenRepositoryURL.FROM.SETTINGS) {
            for (Profile profile : this.mavenSettings.getProfiles()) {
                RepositoryPolicy rp;
                Optional<Repository> repository = profile.getRepositories().stream().filter(r -> this.id.equals(r.getId())).findFirst();
                if (!repository.isPresent()) continue;
                Repository r2 = repository.get();
                r2.setUrl(changedRepository.getURL().toString());
                if (!changedRepository.isSnapshotsEnabled()) {
                    r2.setSnapshots(new RepositoryPolicy());
                    r2.getSnapshots().setEnabled(false);
                } else {
                    rp = r2.getSnapshots() == null ? new RepositoryPolicy() : r2.getSnapshots();
                    rp.setEnabled(true);
                    if (this.checksumPolicy != null) {
                        rp.setChecksumPolicy(changedRepository.getSnapshotsChecksumPolicy());
                    } else if (rp.getChecksumPolicy() == null) {
                        rp.setChecksumPolicy("warn");
                    }
                    if (this.updatePolicy != null) {
                        rp.setUpdatePolicy(changedRepository.getSnapshotsUpdatePolicy());
                    } else if (rp.getUpdatePolicy() == null) {
                        rp.setUpdatePolicy("daily");
                    }
                    r2.setSnapshots(rp);
                }
                if (!changedRepository.isReleasesEnabled()) {
                    r2.setReleases(new RepositoryPolicy());
                    r2.getReleases().setEnabled(false);
                } else {
                    rp = r2.getReleases() == null ? new RepositoryPolicy() : r2.getReleases();
                    rp.setEnabled(true);
                    if (this.checksumPolicy != null) {
                        rp.setChecksumPolicy(changedRepository.getReleasesChecksumPolicy());
                    } else if (rp.getChecksumPolicy() == null) {
                        rp.setChecksumPolicy("warn");
                    }
                    if (this.updatePolicy != null) {
                        rp.setUpdatePolicy(changedRepository.getReleasesUpdatePolicy());
                    } else if (rp.getUpdatePolicy() == null) {
                        rp.setUpdatePolicy("daily");
                    }
                    r2.setReleases(rp);
                }
                this.updateSettings(prefix, config);
                break;
            }
        } else if (changedRepository.getFrom() == MavenRepositoryURL.FROM.PID) {
            LinkedList<MavenRepositoryURL> newRepos = new LinkedList<MavenRepositoryURL>();
            MavenRepositoryURL[] mavenRepositoryURLArray = pidRepos;
            int n = mavenRepositoryURLArray.length;
            for (int i = 0; i < n; ++i) {
                MavenRepositoryURL repo2;
                MavenRepositoryURL _r = repo2 = mavenRepositoryURLArray[i];
                if (this.id.equals(repo2.getId())) {
                    _r = changedRepository;
                }
                newRepos.add(_r);
            }
            this.updatePidRepositories(prefix, config, this.defaultRepository, newRepos, settingsRepos.length > 0);
            if (credentialsUpdated) {
                this.updateSettings(prefix, config);
            }
        }
        Configuration cmConfig = this.cm.getConfiguration("org.ops4j.pax.url.mvn");
        cmConfig.update(config);
        this.success = true;
    }
}

