/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.io.File;
import java.io.FileWriter;
import java.util.Dictionary;
import org.apache.karaf.maven.command.MavenConfigurationSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.service.cm.Configuration;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;
import org.sonatype.plexus.components.sec.dispatcher.model.io.xpp3.SecurityConfigurationXpp3Writer;

@Command(scope="maven", name="password", description="Manage passwords for remote repositories and proxies")
@Service
public class PasswordCommand
extends MavenConfigurationSupport {
    @Option(name="-ep", aliases={"--encrypt-password"}, description="Encrypts passwords to use for remote repositories and proxies, see \"mvn -ep\"", required=false, multiValued=false)
    boolean ep;
    @Option(name="-emp", aliases={"--encrypt-master-password"}, description="Encrypts master password used to encrypt/decrypt other passwords, see \"mvn -emp\"", required=false, multiValued=false)
    boolean emp;
    @Option(name="-p", aliases={"--persist"}, description="", required=false, multiValued=false)
    boolean persist;

    @Override
    public void doAction(String prefix, Dictionary<String, Object> config) throws Exception {
        if (this.ep && this.emp) {
            System.err.println("Please specify only one of --encrypt-password and --encrypt-master-password");
            return;
        }
        if (this.ep && this.persist) {
            System.err.println("Ordinary passwords are not persisted - use the encrypted password in either <proxy> or <server>");
            return;
        }
        if (this.ep) {
            if (this.masterPassword == null) {
                System.err.println("Master password is not available");
                return;
            }
            String password = this.session.readLine("Password to encrypt: ", Character.valueOf('*'));
            System.out.println("Encrypted password: " + this.cipher.encryptAndDecorate(password, this.masterPassword));
            System.out.println("You can use this encrypted password when defining repositories and proxies");
            return;
        }
        if (this.emp) {
            if (this.persist && !this.confirm("Maven security settings will be stored in new file. This file will be used in org.ops4j.pax.url.mvn.security property. Continue? (y/N) ")) {
                return;
            }
            String password = this.session.readLine("Master password to encrypt: ", Character.valueOf('*'));
            String encryptedPassword = this.cipher.encryptAndDecorate(password, "settings.security");
            System.out.println("Encrypted master password: " + encryptedPassword);
            if (this.persist) {
                SettingsSecurity settingsSecurity = new SettingsSecurity();
                settingsSecurity.setMaster(encryptedPassword);
                File dataDir = this.context.getDataFile(".");
                if (!dataDir.isDirectory()) {
                    System.err.println("Can't access data directory for " + this.context.getBundle().getSymbolicName() + " bundle");
                    return;
                }
                File newSecuritySettingsFile = this.nextSequenceFile(dataDir, RE_SECURITY_SETTINGS, "maven-security-settings-%d.xml");
                try (FileWriter fw = new FileWriter(newSecuritySettingsFile);){
                    new SecurityConfigurationXpp3Writer().write(fw, settingsSecurity);
                }
                System.out.println("New security settings stored in \"" + newSecuritySettingsFile.getCanonicalPath() + "\"");
                Configuration cmConfig = this.cm.getConfiguration("org.ops4j.pax.url.mvn");
                config.put(prefix + "security", newSecuritySettingsFile.getCanonicalPath());
                cmConfig.update(config);
            }
        }
    }

    @Override
    protected boolean showPasswords() {
        return true;
    }
}

