/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.spec.reflect.StringValueObjectFactory;

@Beta
public abstract class AbstractIetfYangUtil<M, P> {
    private static final int MAC_BYTE_LENGTH = 6;
    private static final char[] HEX_CHARS;
    private static final byte[] HEX_VALUES;
    private final StringValueObjectFactory<M> macFactory;
    private final StringValueObjectFactory<P> physFactory;

    protected AbstractIetfYangUtil(Class<M> macClass, Class<P> physClass) {
        this.macFactory = StringValueObjectFactory.create(macClass, (String)"00:00:00:00:00:00");
        this.physFactory = StringValueObjectFactory.create(physClass, (String)"00:00");
    }

    public final @NonNull M canonizeMacAddress(@NonNull M macAddress) {
        char[] input = this.getValue(macAddress).toCharArray();
        return (M)(AbstractIetfYangUtil.ensureLowerCase(input) ? this.macFactory.newInstance(String.valueOf(input)) : macAddress);
    }

    public final @NonNull M macAddressFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length == 6 ? 1 : 0) != 0, (String)"MAC address should have 6 bytes, not %s", (int)bytes.length);
        return (M)this.macFactory.newInstance(AbstractIetfYangUtil.bytesToString(bytes, 17));
    }

    public final @NonNull P canonizePhysAddress(@NonNull P physAddress) {
        char[] input = this.getPhysValue(physAddress).toCharArray();
        return (P)(AbstractIetfYangUtil.ensureLowerCase(input) ? this.physFactory.newInstance(String.valueOf(input)) : physAddress);
    }

    public final @NonNull P physAddressFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0, (Object)"Physical address should have at least one byte");
        return (P)this.physFactory.newInstance(AbstractIetfYangUtil.bytesToString(bytes, (bytes.length + 1) / 3));
    }

    public final byte @NonNull [] bytesFor(@NonNull M macAddress) {
        String mac = this.getValue(macAddress);
        byte[] ret = new byte[6];
        int i = 0;
        int base = 0;
        while (i < 6) {
            ret[i] = (byte)(AbstractIetfYangUtil.hexValue(mac.charAt(base)) << 4 | AbstractIetfYangUtil.hexValue(mac.charAt(base + 1)));
            ++i;
            base += 3;
        }
        return ret;
    }

    protected abstract String getValue(M var1);

    protected abstract String getPhysValue(P var1);

    static byte hexValue(char ch) {
        byte value;
        try {
            value = HEX_VALUES[ch];
        }
        catch (IndexOutOfBoundsException e) {
            value = -1;
        }
        if (value < 0) {
            throw new IllegalArgumentException("Invalid character '" + ch + "' encountered");
        }
        return value;
    }

    private static boolean ensureLowerCase(char @NonNull [] chars) {
        boolean ret = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < 'A' || c > 'F') continue;
            chars[i] = Character.toLowerCase(c);
            ret = true;
        }
        return ret;
    }

    private static @NonNull String bytesToString(byte @NonNull [] bytes, int charHint) {
        StringBuilder sb = new StringBuilder(charHint);
        AbstractIetfYangUtil.appendHexByte(sb, bytes[0]);
        for (int i = 1; i < bytes.length; ++i) {
            AbstractIetfYangUtil.appendHexByte(sb.append(':'), bytes[i]);
        }
        return sb.toString();
    }

    private static void appendHexByte(StringBuilder sb, byte byteVal) {
        int intVal = Byte.toUnsignedInt(byteVal);
        sb.append(HEX_CHARS[intVal >>> 4]).append(HEX_CHARS[intVal & 0xF]);
    }

    static {
        int c;
        HEX_CHARS = "0123456789abcdef".toCharArray();
        byte[] b = new byte[103];
        Arrays.fill(b, (byte)-1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 48);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 65 + 10);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 97 + 10);
        }
        HEX_VALUES = b;
    }
}

