/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.topology.singleton.config.rev170419.Config;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder
implements Builder<Config> {
    private Integer _writeTransactionIdleTimeout;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();

    public ConfigBuilder() {
    }

    public ConfigBuilder(Config base) {
        Map aug;
        this._writeTransactionIdleTimeout = base.getWriteTransactionIdleTimeout();
        if (base instanceof ConfigImpl) {
            ConfigImpl impl = (ConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
    }

    public Integer getWriteTransactionIdleTimeout() {
        return this._writeTransactionIdleTimeout;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkWriteTransactionIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public ConfigBuilder setWriteTransactionIdleTimeout(Integer value) {
        if (value != null) {
            ConfigBuilder.checkWriteTransactionIdleTimeoutRange(value);
        }
        this._writeTransactionIdleTimeout = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Class<? extends Augmentation<Config>> augmentationType, Augmentation<Config> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    implements Config {
        private final Integer _writeTransactionIdleTimeout;
        private Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            this._writeTransactionIdleTimeout = base.getWriteTransactionIdleTimeout();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Config> getImplementedInterface() {
            return Config.class;
        }

        @Override
        public Integer getWriteTransactionIdleTimeout() {
            return this._writeTransactionIdleTimeout;
        }

        public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._writeTransactionIdleTimeout);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Config.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Config other = (Config)obj;
            if (!Objects.equals(this._writeTransactionIdleTimeout, other.getWriteTransactionIdleTimeout())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ConfigImpl otherImpl = (ConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Config>>, Augmentation<Config>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Config");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_writeTransactionIdleTimeout", (Object)this._writeTransactionIdleTimeout);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

