/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.utils;

import akka.actor.ActorSystem;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.ScheduledExecutorService;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.netconf.client.NetconfClientDispatcher;
import org.opendaylight.netconf.sal.connect.netconf.NetconfDevice;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import scala.concurrent.duration.Duration;

public class NetconfTopologySetup {
    private final ClusterSingletonServiceProvider clusterSingletonServiceProvider;
    private final DOMRpcProviderService rpcProviderRegistry;
    private final DataBroker dataBroker;
    private final InstanceIdentifier<Node> instanceIdentifier;
    private final Node node;
    private final ScheduledExecutorService keepaliveExecutor;
    private final ListeningExecutorService processingExecutor;
    private final ActorSystem actorSystem;
    private final EventExecutor eventExecutor;
    private final NetconfClientDispatcher netconfClientDispatcher;
    private final String topologyId;
    private final NetconfDevice.SchemaResourcesDTO schemaResourceDTO;
    private final Duration idleTimeout;
    private final String privateKeyPath;
    private final String privateKeyPassphrase;
    private final AAAEncryptionService encryptionService;

    NetconfTopologySetup(NetconfTopologySetupBuilder builder) {
        this.clusterSingletonServiceProvider = builder.getClusterSingletonServiceProvider();
        this.rpcProviderRegistry = builder.getRpcProviderRegistry();
        this.dataBroker = builder.getDataBroker();
        this.instanceIdentifier = builder.getInstanceIdentifier();
        this.node = builder.getNode();
        this.keepaliveExecutor = builder.getKeepaliveExecutor();
        this.processingExecutor = builder.getProcessingExecutor();
        this.actorSystem = builder.getActorSystem();
        this.eventExecutor = builder.getEventExecutor();
        this.netconfClientDispatcher = builder.getNetconfClientDispatcher();
        this.topologyId = builder.getTopologyId();
        this.schemaResourceDTO = builder.getSchemaResourceDTO();
        this.idleTimeout = builder.getIdleTimeout();
        this.privateKeyPath = builder.getPrivateKeyPath();
        this.privateKeyPassphrase = builder.getPrivateKeyPassphrase();
        this.encryptionService = builder.getEncryptionService();
    }

    public ClusterSingletonServiceProvider getClusterSingletonServiceProvider() {
        return this.clusterSingletonServiceProvider;
    }

    public DOMRpcProviderService getRpcProviderRegistry() {
        return this.rpcProviderRegistry;
    }

    public DataBroker getDataBroker() {
        return this.dataBroker;
    }

    public InstanceIdentifier<Node> getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public Node getNode() {
        return this.node;
    }

    public ListeningExecutorService getProcessingExecutor() {
        return this.processingExecutor;
    }

    public ScheduledExecutorService getKeepaliveExecutor() {
        return this.keepaliveExecutor;
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public EventExecutor getEventExecutor() {
        return this.eventExecutor;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public NetconfClientDispatcher getNetconfClientDispatcher() {
        return this.netconfClientDispatcher;
    }

    public NetconfDevice.SchemaResourcesDTO getSchemaResourcesDTO() {
        return this.schemaResourceDTO;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public AAAEncryptionService getEncryptionService() {
        return this.encryptionService;
    }

    public static class NetconfTopologySetupBuilder {
        private ClusterSingletonServiceProvider clusterSingletonServiceProvider;
        private DOMRpcProviderService rpcProviderRegistry;
        private DataBroker dataBroker;
        private InstanceIdentifier<Node> instanceIdentifier;
        private Node node;
        private ScheduledExecutorService keepaliveExecutor;
        private ListeningExecutorService processingExecutor;
        private ActorSystem actorSystem;
        private EventExecutor eventExecutor;
        private String topologyId;
        private NetconfClientDispatcher netconfClientDispatcher;
        private NetconfDevice.SchemaResourcesDTO schemaResourceDTO;
        private Duration idleTimeout;
        private String privateKeyPath;
        private String privateKeyPassphrase;
        private AAAEncryptionService encryptionService;

        private ClusterSingletonServiceProvider getClusterSingletonServiceProvider() {
            return this.clusterSingletonServiceProvider;
        }

        public NetconfTopologySetupBuilder setClusterSingletonServiceProvider(ClusterSingletonServiceProvider clusterSingletonServiceProvider) {
            this.clusterSingletonServiceProvider = clusterSingletonServiceProvider;
            return this;
        }

        private DOMRpcProviderService getRpcProviderRegistry() {
            return this.rpcProviderRegistry;
        }

        public NetconfTopologySetupBuilder setRpcProviderRegistry(DOMRpcProviderService rpcProviderRegistry) {
            this.rpcProviderRegistry = rpcProviderRegistry;
            return this;
        }

        private DataBroker getDataBroker() {
            return this.dataBroker;
        }

        public NetconfTopologySetupBuilder setDataBroker(DataBroker dataBroker) {
            this.dataBroker = dataBroker;
            return this;
        }

        private InstanceIdentifier<Node> getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        public NetconfTopologySetupBuilder setInstanceIdentifier(InstanceIdentifier<Node> instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        public Node getNode() {
            return this.node;
        }

        public NetconfTopologySetupBuilder setNode(Node node) {
            this.node = node;
            return this;
        }

        public NetconfTopologySetup build() {
            return new NetconfTopologySetup(this);
        }

        private ScheduledExecutorService getKeepaliveExecutor() {
            return this.keepaliveExecutor;
        }

        public NetconfTopologySetupBuilder setKeepaliveExecutor(ScheduledExecutorService keepaliveExecutor) {
            this.keepaliveExecutor = keepaliveExecutor;
            return this;
        }

        private ListeningExecutorService getProcessingExecutor() {
            return this.processingExecutor;
        }

        public NetconfTopologySetupBuilder setProcessingExecutor(ListeningExecutorService processingExecutor) {
            this.processingExecutor = processingExecutor;
            return this;
        }

        private ActorSystem getActorSystem() {
            return this.actorSystem;
        }

        public NetconfTopologySetupBuilder setActorSystem(ActorSystem actorSystem) {
            this.actorSystem = actorSystem;
            return this;
        }

        private EventExecutor getEventExecutor() {
            return this.eventExecutor;
        }

        public NetconfTopologySetupBuilder setEventExecutor(EventExecutor eventExecutor) {
            this.eventExecutor = eventExecutor;
            return this;
        }

        private String getTopologyId() {
            return this.topologyId;
        }

        public NetconfTopologySetupBuilder setTopologyId(String topologyId) {
            this.topologyId = topologyId;
            return this;
        }

        private NetconfClientDispatcher getNetconfClientDispatcher() {
            return this.netconfClientDispatcher;
        }

        public NetconfTopologySetupBuilder setNetconfClientDispatcher(NetconfClientDispatcher clientDispatcher) {
            this.netconfClientDispatcher = clientDispatcher;
            return this;
        }

        public NetconfTopologySetupBuilder setSchemaResourceDTO(NetconfDevice.SchemaResourcesDTO schemaResourceDTO) {
            this.schemaResourceDTO = schemaResourceDTO;
            return this;
        }

        private NetconfDevice.SchemaResourcesDTO getSchemaResourceDTO() {
            return this.schemaResourceDTO;
        }

        public NetconfTopologySetupBuilder setIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        private Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        public NetconfTopologySetupBuilder setPrivateKeyPath(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
            return this;
        }

        public String getPrivateKeyPath() {
            return this.privateKeyPath;
        }

        public NetconfTopologySetupBuilder setPrivateKeyPassphrase(String privateKeyPassphrase) {
            this.privateKeyPassphrase = privateKeyPassphrase;
            return this;
        }

        public String getPrivateKeyPassphrase() {
            return this.privateKeyPassphrase;
        }

        private AAAEncryptionService getEncryptionService() {
            return this.encryptionService;
        }

        public NetconfTopologySetupBuilder setEncryptionService(AAAEncryptionService encryptionService) {
            this.encryptionService = encryptionService;
            return this;
        }

        public static NetconfTopologySetupBuilder create() {
            return new NetconfTopologySetupBuilder();
        }
    }
}

