/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.tx;

import akka.actor.ActorRef;
import akka.dispatch.OnComplete;
import akka.pattern.AskTimeoutException;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.impl.tx.ProxyTransactionFacade;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologyUtils;
import org.opendaylight.netconf.topology.singleton.messages.NormalizedNodeMessage;
import org.opendaylight.netconf.topology.singleton.messages.transactions.CancelRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.DeleteRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.EmptyReadResponse;
import org.opendaylight.netconf.topology.singleton.messages.transactions.ExistsRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.MergeRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.PutRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.ReadRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.SubmitRequest;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

class ActorProxyTransactionFacade
implements ProxyTransactionFacade {
    private static final Logger LOG = LoggerFactory.getLogger(ActorProxyTransactionFacade.class);
    private final ActorRef masterTxActor;
    private final RemoteDeviceId id;
    private final ExecutionContext executionContext;
    private final Timeout askTimeout;

    ActorProxyTransactionFacade(ActorRef masterTxActor, RemoteDeviceId id, ExecutionContext executionContext, Timeout askTimeout) {
        this.masterTxActor = Objects.requireNonNull(masterTxActor);
        this.id = Objects.requireNonNull(id);
        this.executionContext = Objects.requireNonNull(executionContext);
        this.askTimeout = Objects.requireNonNull(askTimeout);
    }

    public Object getIdentifier() {
        return this.id;
    }

    public boolean cancel() {
        LOG.debug("{}: Cancel via actor {}", (Object)this.id, (Object)this.masterTxActor);
        Future future = Patterns.ask((ActorRef)this.masterTxActor, (Object)new CancelRequest(), (Timeout)this.askTimeout);
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.warn("{}: Cancel failed", (Object)ActorProxyTransactionFacade.this.id, (Object)failure);
                    return;
                }
                LOG.debug("{}: Cancel succeeded", (Object)ActorProxyTransactionFacade.this.id);
            }
        }, this.executionContext);
        return true;
    }

    public void close() {
        this.cancel();
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(final LogicalDatastoreType store, final YangInstanceIdentifier path) {
        LOG.debug("{}: Read {} {} via actor {}", new Object[]{this.id, store, path, this.masterTxActor});
        Future future = Patterns.ask((ActorRef)this.masterTxActor, (Object)new ReadRequest(store, path), (Timeout)this.askTimeout);
        final SettableFuture settableFuture = SettableFuture.create();
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.debug("{}: Read {} {} failed", new Object[]{ActorProxyTransactionFacade.this.id, store, path, failure});
                    Throwable processedFailure = ActorProxyTransactionFacade.this.processFailure(failure);
                    if (processedFailure instanceof ReadFailedException) {
                        settableFuture.setException(processedFailure);
                    } else {
                        settableFuture.setException((Throwable)new ReadFailedException("Read of store " + store + " path " + path + " failed", processedFailure, new RpcError[0]));
                    }
                    return;
                }
                LOG.debug("{}: Read {} {} succeeded: {}", new Object[]{ActorProxyTransactionFacade.this.id, store, path, response});
                if (response instanceof EmptyReadResponse) {
                    settableFuture.set(Optional.empty());
                    return;
                }
                if (response instanceof NormalizedNodeMessage) {
                    NormalizedNodeMessage data = (NormalizedNodeMessage)response;
                    settableFuture.set(Optional.of(data.getNode()));
                }
            }
        }, this.executionContext);
        return settableFuture;
    }

    public FluentFuture<Boolean> exists(final LogicalDatastoreType store, final YangInstanceIdentifier path) {
        LOG.debug("{}: Exists {} {} via actor {}", new Object[]{this.id, store, path, this.masterTxActor});
        Future future = Patterns.ask((ActorRef)this.masterTxActor, (Object)new ExistsRequest(store, path), (Timeout)this.askTimeout);
        final SettableFuture settableFuture = SettableFuture.create();
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.debug("{}: Exists {} {} failed", new Object[]{ActorProxyTransactionFacade.this.id, store, path, failure});
                    Throwable processedFailure = ActorProxyTransactionFacade.this.processFailure(failure);
                    if (processedFailure instanceof ReadFailedException) {
                        settableFuture.setException(processedFailure);
                    } else {
                        settableFuture.setException((Throwable)new ReadFailedException("Exists of store " + store + " path " + path + " failed", processedFailure, new RpcError[0]));
                    }
                    return;
                }
                LOG.debug("{}: Exists {} {} succeeded: {}", new Object[]{ActorProxyTransactionFacade.this.id, store, path, response});
                settableFuture.set((Object)((Boolean)response));
            }
        }, this.executionContext);
        return settableFuture;
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        LOG.debug("{}: Delete {} {} via actor {}", new Object[]{this.id, store, path, this.masterTxActor});
        this.masterTxActor.tell((Object)new DeleteRequest(store, path), ActorRef.noSender());
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        LOG.debug("{}: Put {} {} via actor {}", new Object[]{this.id, store, path, this.masterTxActor});
        this.masterTxActor.tell((Object)new PutRequest(store, new NormalizedNodeMessage(path, data)), ActorRef.noSender());
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        LOG.debug("{}: Merge {} {} via actor {}", new Object[]{this.id, store, path, this.masterTxActor});
        this.masterTxActor.tell((Object)new MergeRequest(store, new NormalizedNodeMessage(path, data)), ActorRef.noSender());
    }

    public FluentFuture<? extends CommitInfo> commit() {
        LOG.debug("{}: Commit via actor {}", (Object)this.id, (Object)this.masterTxActor);
        Future future = Patterns.ask((ActorRef)this.masterTxActor, (Object)new SubmitRequest(), (Timeout)this.askTimeout);
        final SettableFuture settableFuture = SettableFuture.create();
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.debug("{}: Commit failed", (Object)ActorProxyTransactionFacade.this.id, (Object)failure);
                    settableFuture.setException((Throwable)ActorProxyTransactionFacade.this.newTransactionCommitFailedException(ActorProxyTransactionFacade.this.processFailure(failure)));
                    return;
                }
                LOG.debug("{}: Commit succeeded", (Object)ActorProxyTransactionFacade.this.id);
                settableFuture.set((Object)CommitInfo.empty());
            }
        }, this.executionContext);
        return settableFuture;
    }

    private TransactionCommitFailedException newTransactionCommitFailedException(Throwable failure) {
        return new TransactionCommitFailedException(String.format("%s: Commit of transaction failed", this.getIdentifier()), failure, new RpcError[0]);
    }

    private Throwable processFailure(Throwable failure) {
        if (failure instanceof AskTimeoutException) {
            return NetconfTopologyUtils.createMasterIsDownException(this.id, (Exception)failure);
        }
        return failure;
    }
}

