/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.actors;

import akka.actor.ActorRef;
import akka.actor.Status;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.netconf.topology.singleton.messages.NormalizedNodeMessage;
import org.opendaylight.netconf.topology.singleton.messages.transactions.EmptyReadResponse;
import org.opendaylight.netconf.topology.singleton.messages.transactions.ExistsRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.ReadRequest;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

class ReadAdapter {
    private final DOMDataTreeReadTransaction tx;

    ReadAdapter(DOMDataTreeReadTransaction tx) {
        this.tx = tx;
    }

    public void handle(Object message, ActorRef sender, ActorRef self) {
        if (message instanceof ReadRequest) {
            ReadRequest readRequest = (ReadRequest)message;
            YangInstanceIdentifier path = readRequest.getPath();
            LogicalDatastoreType store = readRequest.getStore();
            this.read(path, store, sender, self);
        } else if (message instanceof ExistsRequest) {
            ExistsRequest readRequest = (ExistsRequest)message;
            YangInstanceIdentifier path = readRequest.getPath();
            LogicalDatastoreType store = readRequest.getStore();
            this.exists(path, store, sender, self);
        }
    }

    private void read(final YangInstanceIdentifier path, LogicalDatastoreType store, final ActorRef sender, final ActorRef self) {
        this.tx.read(store, path).addCallback(new FutureCallback<Optional<NormalizedNode<?, ?>>>(){

            public void onSuccess(Optional<NormalizedNode<?, ?>> result) {
                if (!result.isPresent()) {
                    sender.tell((Object)new EmptyReadResponse(), self);
                    return;
                }
                sender.tell((Object)new NormalizedNodeMessage(path, result.get()), self);
            }

            public void onFailure(@Nonnull Throwable throwable) {
                sender.tell((Object)new Status.Failure(throwable), self);
            }
        }, MoreExecutors.directExecutor());
    }

    private void exists(YangInstanceIdentifier path, LogicalDatastoreType store, final ActorRef sender, final ActorRef self) {
        this.tx.exists(store, path).addCallback((FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                if (result == null) {
                    sender.tell((Object)Boolean.FALSE, self);
                } else {
                    sender.tell((Object)result, self);
                }
            }

            public void onFailure(@Nonnull Throwable throwable) {
                sender.tell((Object)new Status.Failure(throwable), self);
            }
        }, MoreExecutors.directExecutor());
    }
}

