/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl.actors;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import akka.japi.Creator;
import akka.pattern.AskTimeoutException;
import akka.util.Timeout;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.cluster.schema.provider.RemoteYangTextSourceProvider;
import org.opendaylight.controller.cluster.schema.provider.impl.RemoteSchemaProvider;
import org.opendaylight.controller.cluster.schema.provider.impl.YangTextSchemaSourceSerializationProxy;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.impl.ProxyDOMRpcService;
import org.opendaylight.netconf.topology.singleton.impl.ProxyYangTextSourceProvider;
import org.opendaylight.netconf.topology.singleton.impl.SlaveSalFacade;
import org.opendaylight.netconf.topology.singleton.impl.actors.ReadTransactionActor;
import org.opendaylight.netconf.topology.singleton.impl.actors.ReadWriteTransactionActor;
import org.opendaylight.netconf.topology.singleton.impl.actors.WriteTransactionActor;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologySetup;
import org.opendaylight.netconf.topology.singleton.messages.AskForMasterMountPoint;
import org.opendaylight.netconf.topology.singleton.messages.CreateInitialMasterActorData;
import org.opendaylight.netconf.topology.singleton.messages.MasterActorDataInitialized;
import org.opendaylight.netconf.topology.singleton.messages.NormalizedNodeMessage;
import org.opendaylight.netconf.topology.singleton.messages.NotMasterException;
import org.opendaylight.netconf.topology.singleton.messages.RefreshSetupMasterActorData;
import org.opendaylight.netconf.topology.singleton.messages.RefreshSlaveActor;
import org.opendaylight.netconf.topology.singleton.messages.RegisterMountPoint;
import org.opendaylight.netconf.topology.singleton.messages.UnregisterSlaveMountPoint;
import org.opendaylight.netconf.topology.singleton.messages.YangTextSchemaSourceRequest;
import org.opendaylight.netconf.topology.singleton.messages.rpc.InvokeRpcMessage;
import org.opendaylight.netconf.topology.singleton.messages.rpc.InvokeRpcMessageReply;
import org.opendaylight.netconf.topology.singleton.messages.transactions.EmptyResultResponse;
import org.opendaylight.netconf.topology.singleton.messages.transactions.NewReadTransactionRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.NewReadWriteTransactionRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.NewWriteTransactionRequest;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public class NetconfNodeActor
extends AbstractUntypedActor {
    private final Duration writeTxIdleTimeout;
    private final DOMMountPointService mountPointService;
    private SchemaSourceRegistry schemaRegistry;
    private SchemaRepository schemaRepository;
    private Timeout actorResponseWaitTime;
    private RemoteDeviceId id;
    private NetconfTopologySetup setup;
    private List<SourceIdentifier> sourceIdentifiers;
    private DOMRpcService deviceRpc;
    private SlaveSalFacade slaveSalManager;
    private DOMDataBroker deviceDataBroker;
    private ActorRef readTxActor;
    private List<SchemaSourceRegistration<YangTextSchemaSource>> registeredSchemas;

    public static Props props(NetconfTopologySetup setup, RemoteDeviceId id, SchemaSourceRegistry schemaRegistry, SchemaRepository schemaRepository, Timeout actorResponseWaitTime, DOMMountPointService mountPointService) {
        return Props.create(NetconfNodeActor.class, (Creator & Serializable)() -> new NetconfNodeActor(setup, id, schemaRegistry, schemaRepository, actorResponseWaitTime, mountPointService));
    }

    protected NetconfNodeActor(NetconfTopologySetup setup, RemoteDeviceId id, SchemaSourceRegistry schemaRegistry, SchemaRepository schemaRepository, Timeout actorResponseWaitTime, DOMMountPointService mountPointService) {
        this.setup = setup;
        this.id = id;
        this.schemaRegistry = schemaRegistry;
        this.schemaRepository = schemaRepository;
        this.actorResponseWaitTime = actorResponseWaitTime;
        this.writeTxIdleTimeout = setup.getIdleTimeout();
        this.mountPointService = mountPointService;
    }

    public void handleReceive(Object message) {
        this.LOG.debug("{}:  received message {}", (Object)this.id, message);
        if (message instanceof CreateInitialMasterActorData) {
            CreateInitialMasterActorData masterActorData = (CreateInitialMasterActorData)message;
            this.sourceIdentifiers = masterActorData.getSourceIndentifiers();
            this.deviceDataBroker = masterActorData.getDeviceDataBroker();
            DOMDataTreeReadTransaction tx = this.deviceDataBroker.newReadOnlyTransaction();
            this.readTxActor = this.context().actorOf(ReadTransactionActor.props(tx));
            this.deviceRpc = masterActorData.getDeviceRpc();
            this.sender().tell((Object)new MasterActorDataInitialized(), this.self());
            this.LOG.debug("{}: Master is ready.", (Object)this.id);
        } else if (message instanceof RefreshSetupMasterActorData) {
            this.setup = ((RefreshSetupMasterActorData)message).getNetconfTopologyDeviceSetup();
            this.id = ((RefreshSetupMasterActorData)message).getRemoteDeviceId();
            this.sender().tell((Object)new MasterActorDataInitialized(), this.self());
        } else if (message instanceof AskForMasterMountPoint) {
            AskForMasterMountPoint askForMasterMountPoint = (AskForMasterMountPoint)message;
            if (this.deviceDataBroker != null) {
                this.LOG.debug("{}: Sending RegisterMountPoint reply to {}", (Object)this.id, (Object)askForMasterMountPoint.getSlaveActorRef());
                askForMasterMountPoint.getSlaveActorRef().tell((Object)new RegisterMountPoint(this.sourceIdentifiers, this.self()), this.sender());
            } else {
                this.LOG.warn("{}: Received {} but we don't appear to be the master", (Object)this.id, (Object)askForMasterMountPoint);
                this.sender().tell((Object)new Status.Failure((Throwable)new NotMasterException(this.self())), this.self());
            }
        } else if (message instanceof YangTextSchemaSourceRequest) {
            YangTextSchemaSourceRequest yangTextSchemaSourceRequest = (YangTextSchemaSourceRequest)message;
            this.sendYangTextSchemaSourceProxy(yangTextSchemaSourceRequest.getSourceIdentifier(), this.sender());
        } else if (message instanceof NewReadTransactionRequest) {
            this.sender().tell((Object)new Status.Success((Object)this.readTxActor), this.self());
        } else if (message instanceof NewWriteTransactionRequest) {
            try {
                DOMDataTreeWriteTransaction tx = this.deviceDataBroker.newWriteOnlyTransaction();
                ActorRef txActor = this.context().actorOf(WriteTransactionActor.props(tx, this.writeTxIdleTimeout));
                this.sender().tell((Object)new Status.Success((Object)txActor), this.self());
            }
            catch (Exception t) {
                this.sender().tell((Object)new Status.Failure((Throwable)t), this.self());
            }
        } else if (message instanceof NewReadWriteTransactionRequest) {
            try {
                DOMDataTreeReadWriteTransaction tx = this.deviceDataBroker.newReadWriteTransaction();
                ActorRef txActor = this.context().actorOf(ReadWriteTransactionActor.props(tx, this.writeTxIdleTimeout));
                this.sender().tell((Object)new Status.Success((Object)txActor), this.self());
            }
            catch (Exception t) {
                this.sender().tell((Object)new Status.Failure((Throwable)t), this.self());
            }
        } else if (message instanceof InvokeRpcMessage) {
            InvokeRpcMessage invokeRpcMessage = (InvokeRpcMessage)message;
            this.invokeSlaveRpc(invokeRpcMessage.getSchemaPath(), invokeRpcMessage.getNormalizedNodeMessage(), this.sender());
        } else if (message instanceof RegisterMountPoint) {
            RegisterMountPoint registerMountPoint = (RegisterMountPoint)message;
            this.sourceIdentifiers = registerMountPoint.getSourceIndentifiers();
            this.registerSlaveMountPoint(registerMountPoint.getMasterActorRef());
            this.sender().tell((Object)new Status.Success(null), this.self());
        } else if (message instanceof UnregisterSlaveMountPoint) {
            this.unregisterSlaveMountPoint();
        } else if (message instanceof RefreshSlaveActor) {
            this.actorResponseWaitTime = ((RefreshSlaveActor)message).getActorResponseWaitTime();
            this.id = ((RefreshSlaveActor)message).getId();
            this.schemaRegistry = ((RefreshSlaveActor)message).getSchemaRegistry();
            this.setup = ((RefreshSlaveActor)message).getSetup();
            this.schemaRepository = ((RefreshSlaveActor)message).getSchemaRepository();
        }
    }

    public void postStop() throws Exception {
        try {
            super.postStop();
        }
        finally {
            this.unregisterSlaveMountPoint();
        }
    }

    private void unregisterSlaveMountPoint() {
        if (this.slaveSalManager != null) {
            this.slaveSalManager.close();
            this.slaveSalManager = null;
        }
        this.closeSchemaSourceRegistrations();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void sendYangTextSchemaSourceProxy(final SourceIdentifier sourceIdentifier, final ActorRef sender) {
        @NonNull ListenableFuture schemaSourceFuture = this.schemaRepository.getSchemaSource(sourceIdentifier, YangTextSchemaSource.class);
        Futures.addCallback((ListenableFuture)schemaSourceFuture, (FutureCallback)new FutureCallback<YangTextSchemaSource>(){

            public void onSuccess(YangTextSchemaSource yangTextSchemaSource) {
                try {
                    NetconfNodeActor.this.LOG.debug("{}: getSchemaSource for {} succeeded", (Object)NetconfNodeActor.this.id, (Object)sourceIdentifier);
                    sender.tell((Object)new YangTextSchemaSourceSerializationProxy(yangTextSchemaSource), NetconfNodeActor.this.getSelf());
                }
                catch (IOException e) {
                    sender.tell((Object)new Status.Failure((Throwable)e), NetconfNodeActor.this.getSelf());
                }
            }

            public void onFailure(@Nonnull Throwable throwable) {
                NetconfNodeActor.this.LOG.debug("{}: getSchemaSource for {} failed", new Object[]{NetconfNodeActor.this.id, sourceIdentifier, throwable});
                sender.tell((Object)new Status.Failure(throwable), NetconfNodeActor.this.getSelf());
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void invokeSlaveRpc(final SchemaPath schemaPath, NormalizedNodeMessage normalizedNodeMessage, final ActorRef recipient) {
        this.LOG.debug("{}: invokeSlaveRpc for {}, input: {} on rpc service {}", new Object[]{this.id, schemaPath, normalizedNodeMessage, this.deviceRpc});
        FluentFuture rpcResult = this.deviceRpc.invokeRpc(schemaPath, normalizedNodeMessage != null ? normalizedNodeMessage.getNode() : null);
        Futures.addCallback((ListenableFuture)rpcResult, (FutureCallback)new FutureCallback<DOMRpcResult>(){

            public void onSuccess(@Nullable DOMRpcResult domRpcResult) {
                NetconfNodeActor.this.LOG.debug("{}: invokeSlaveRpc for {}, domRpcResult: {}", new Object[]{NetconfNodeActor.this.id, schemaPath, domRpcResult});
                if (domRpcResult == null) {
                    recipient.tell((Object)new EmptyResultResponse(), NetconfNodeActor.this.getSender());
                    return;
                }
                NormalizedNodeMessage nodeMessageReply = null;
                if (domRpcResult.getResult() != null) {
                    nodeMessageReply = new NormalizedNodeMessage(YangInstanceIdentifier.EMPTY, domRpcResult.getResult());
                }
                recipient.tell((Object)new InvokeRpcMessageReply(nodeMessageReply, domRpcResult.getErrors()), NetconfNodeActor.this.getSelf());
            }

            public void onFailure(@Nonnull Throwable throwable) {
                recipient.tell((Object)new Status.Failure(throwable), NetconfNodeActor.this.getSelf());
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void registerSlaveMountPoint(ActorRef masterReference) {
        this.unregisterSlaveMountPoint();
        this.slaveSalManager = new SlaveSalFacade(this.id, this.setup.getActorSystem(), this.actorResponseWaitTime, this.mountPointService);
        this.resolveSchemaContext(this.createSchemaContextFactory(masterReference), this.slaveSalManager, masterReference, 1);
    }

    private DOMRpcService getDOMRpcService(ActorRef masterReference) {
        return new ProxyDOMRpcService(this.setup.getActorSystem(), masterReference, this.id, this.actorResponseWaitTime);
    }

    private SchemaContextFactory createSchemaContextFactory(ActorRef masterReference) {
        ProxyYangTextSourceProvider remoteYangTextSourceProvider = new ProxyYangTextSourceProvider(masterReference, (ExecutionContext)this.getContext().dispatcher(), this.actorResponseWaitTime);
        RemoteSchemaProvider remoteProvider = new RemoteSchemaProvider((RemoteYangTextSourceProvider)remoteYangTextSourceProvider, (ExecutionContext)this.getContext().dispatcher());
        this.registeredSchemas = this.sourceIdentifiers.stream().map(sourceId -> this.schemaRegistry.registerSchemaSource((SchemaSourceProvider)remoteProvider, PotentialSchemaSource.create((SourceIdentifier)sourceId, YangTextSchemaSource.class, (int)PotentialSchemaSource.Costs.REMOTE_IO.getValue()))).collect(Collectors.toList());
        return this.schemaRepository.createSchemaContextFactory(SchemaSourceFilter.ALWAYS_ACCEPT);
    }

    private void resolveSchemaContext(final SchemaContextFactory schemaContextFactory, final SlaveSalFacade localSlaveSalManager, final ActorRef masterReference, final int tries) {
        ListenableFuture schemaContextFuture = schemaContextFactory.createSchemaContext(this.sourceIdentifiers);
        Futures.addCallback((ListenableFuture)schemaContextFuture, (FutureCallback)new FutureCallback<SchemaContext>(){

            public void onSuccess(@Nonnull SchemaContext result) {
                NetconfNodeActor.this.executeInSelf(() -> {
                    if (NetconfNodeActor.this.slaveSalManager == localSlaveSalManager) {
                        NetconfNodeActor.this.LOG.info("{}: Schema context resolved: {} - registering slave mount point", (Object)NetconfNodeActor.this.id, (Object)result.getModules());
                        NetconfNodeActor.this.slaveSalManager.registerSlaveMountPoint(result, NetconfNodeActor.this.getDOMRpcService(masterReference), masterReference);
                    }
                });
            }

            public void onFailure(@Nonnull Throwable throwable) {
                NetconfNodeActor.this.executeInSelf(() -> {
                    if (NetconfNodeActor.this.slaveSalManager == localSlaveSalManager) {
                        Throwable cause = Throwables.getRootCause((Throwable)throwable);
                        if (cause instanceof AskTimeoutException) {
                            if (tries <= 5 || tries % 10 == 0) {
                                NetconfNodeActor.this.LOG.warn("{}: Failed to resolve schema context - retrying...", (Object)NetconfNodeActor.this.id, (Object)throwable);
                            }
                            NetconfNodeActor.this.resolveSchemaContext(schemaContextFactory, localSlaveSalManager, masterReference, tries + 1);
                        } else {
                            NetconfNodeActor.this.LOG.error("{}: Failed to resolve schema context - unable to register slave mount point", (Object)NetconfNodeActor.this.id, (Object)throwable);
                            NetconfNodeActor.this.closeSchemaSourceRegistrations();
                        }
                    }
                });
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void closeSchemaSourceRegistrations() {
        if (this.registeredSchemas != null) {
            this.registeredSchemas.forEach(SchemaSourceRegistration::close);
            this.registeredSchemas = null;
        }
    }
}

