/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.util.Timeout;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceNotificationService;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceSalProvider;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.impl.ProxyDOMDataBroker;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;

public class SlaveSalFacade {
    private static final Logger LOG = LoggerFactory.getLogger(SlaveSalFacade.class);
    private final RemoteDeviceId id;
    private final NetconfDeviceSalProvider salProvider;
    private final ActorSystem actorSystem;
    private final Timeout actorResponseWaitTime;
    private final AtomicBoolean registered = new AtomicBoolean(false);

    public SlaveSalFacade(RemoteDeviceId id, ActorSystem actorSystem, Timeout actorResponseWaitTime, DOMMountPointService mountPointService) {
        this.id = id;
        this.salProvider = new NetconfDeviceSalProvider(id, mountPointService);
        this.actorSystem = actorSystem;
        this.actorResponseWaitTime = actorResponseWaitTime;
    }

    public void registerSlaveMountPoint(SchemaContext remoteSchemaContext, DOMRpcService deviceRpc, ActorRef masterActorRef) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        NetconfDeviceNotificationService notificationService = new NetconfDeviceNotificationService();
        ProxyDOMDataBroker netconfDeviceDataBroker = new ProxyDOMDataBroker(this.id, masterActorRef, (ExecutionContext)this.actorSystem.dispatcher(), this.actorResponseWaitTime);
        this.salProvider.getMountInstance().onTopologyDeviceConnected(remoteSchemaContext, (DOMDataBroker)netconfDeviceDataBroker, deviceRpc, notificationService);
        LOG.info("{}: Slave mount point registered.", (Object)this.id);
    }

    public void close() {
        if (!this.registered.compareAndSet(true, false)) {
            return;
        }
        this.salProvider.getMountInstance().onTopologyDeviceDisconnected();
        LOG.info("{}: Slave mount point unregistered.", (Object)this.id);
    }
}

