/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.SslHandlerFactory;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfReconnectingClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfReconnectingClientConfigurationBuilder;
import org.opendaylight.netconf.nettyutil.ReconnectStrategyFactory;
import org.opendaylight.netconf.nettyutil.TimedReconnectStrategyFactory;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.netconf.nettyutil.handler.ssh.authentication.LoginPasswordHandler;
import org.opendaylight.netconf.sal.connect.api.RemoteDevice;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.netconf.LibraryModulesSchemas;
import org.opendaylight.netconf.sal.connect.netconf.NetconfDevice;
import org.opendaylight.netconf.sal.connect.netconf.NetconfDeviceBuilder;
import org.opendaylight.netconf.sal.connect.netconf.SchemalessNetconfDevice;
import org.opendaylight.netconf.sal.connect.netconf.auth.DatastoreBackedPublicKeyAuth;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCapabilities;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCommunicator;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.listener.UserPreferences;
import org.opendaylight.netconf.sal.connect.netconf.sal.KeepaliveSalFacade;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfKeystoreAdapter;
import org.opendaylight.netconf.sal.connect.netconf.schema.YangLibrarySchemaYangSourceProvider;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.sal.connect.util.SslHandlerFactoryImpl;
import org.opendaylight.netconf.topology.singleton.api.RemoteDeviceConnector;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfConnectorDTO;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologySetup;
import org.opendaylight.netconf.topology.singleton.impl.utils.NetconfTopologyUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.OdlHelloMessageCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.KeyAuth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPassword;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPw;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPwUnencrypted;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.key.auth.KeyBased;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.login.pw.unencrypted.LoginPasswordUnencrypted;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDeviceConnectorImpl
implements RemoteDeviceConnector {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDeviceConnectorImpl.class);
    private final NetconfTopologySetup netconfTopologyDeviceSetup;
    private final RemoteDeviceId remoteDeviceId;
    private final String privateKeyPath;
    private final String privateKeyPassphrase;
    private final AAAEncryptionService encryptionService;
    private NetconfConnectorDTO deviceCommunicatorDTO;
    private final NetconfKeystoreAdapter keystoreAdapter;

    public RemoteDeviceConnectorImpl(NetconfTopologySetup netconfTopologyDeviceSetup, RemoteDeviceId remoteDeviceId) {
        this.netconfTopologyDeviceSetup = (NetconfTopologySetup)Preconditions.checkNotNull((Object)netconfTopologyDeviceSetup);
        this.remoteDeviceId = remoteDeviceId;
        this.privateKeyPath = netconfTopologyDeviceSetup.getPrivateKeyPath();
        this.privateKeyPassphrase = netconfTopologyDeviceSetup.getPrivateKeyPassphrase();
        this.encryptionService = netconfTopologyDeviceSetup.getEncryptionService();
        this.keystoreAdapter = new NetconfKeystoreAdapter(netconfTopologyDeviceSetup.getDataBroker());
    }

    @Override
    public void startRemoteDeviceConnection(RemoteDeviceHandler<NetconfSessionPreferences> deviceHandler) {
        NetconfNode netconfNode = (NetconfNode)this.netconfTopologyDeviceSetup.getNode().augmentation(NetconfNode.class);
        NodeId nodeId = this.netconfTopologyDeviceSetup.getNode().getNodeId();
        Preconditions.checkNotNull((Object)netconfNode.getHost());
        Preconditions.checkNotNull((Object)netconfNode.getPort());
        Preconditions.checkNotNull((Object)netconfNode.isTcpOnly());
        this.deviceCommunicatorDTO = this.createDeviceCommunicator(nodeId, netconfNode, deviceHandler);
        NetconfDeviceCommunicator deviceCommunicator = this.deviceCommunicatorDTO.getCommunicator();
        NetconfClientSessionListener netconfClientSessionListener = this.deviceCommunicatorDTO.getSessionListener();
        NetconfReconnectingClientConfiguration clientConfig = this.getClientConfig(netconfClientSessionListener, netconfNode);
        ListenableFuture future = deviceCommunicator.initializeRemoteConnection(this.netconfTopologyDeviceSetup.getNetconfClientDispatcher(), (NetconfClientConfiguration)clientConfig);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<NetconfDeviceCapabilities>(){

            public void onSuccess(NetconfDeviceCapabilities result) {
                LOG.debug("{}: Connector started successfully", (Object)RemoteDeviceConnectorImpl.this.remoteDeviceId);
            }

            public void onFailure(@Nullable Throwable throwable) {
                LOG.error("{}: Connector failed", (Object)RemoteDeviceConnectorImpl.this.remoteDeviceId, (Object)throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void stopRemoteDeviceConnection() {
        if (this.deviceCommunicatorDTO != null) {
            try {
                this.deviceCommunicatorDTO.close();
            }
            catch (Exception e) {
                LOG.error("{}: Error at closing device communicator.", (Object)this.remoteDeviceId, (Object)e);
            }
        }
    }

    @VisibleForTesting
    NetconfConnectorDTO createDeviceCommunicator(NodeId nodeId, NetconfNode node, RemoteDeviceHandler<NetconfSessionPreferences> deviceHandler) {
        NetconfDeviceCommunicator netconfDeviceCommunicator;
        int rpcMessageLimit;
        long defaultRequestTimeoutMillis = node.getDefaultRequestTimeoutMillis() == null ? 60000L : node.getDefaultRequestTimeoutMillis();
        long keepaliveDelay = node.getKeepaliveDelay() == null ? 0L : node.getKeepaliveDelay();
        boolean reconnectOnChangedSchema = node.isReconnectOnChangedSchema() == null ? false : node.isReconnectOnChangedSchema();
        KeepaliveSalFacade salFacade = deviceHandler;
        if (keepaliveDelay > 0L) {
            LOG.info("{}: Adding keepalive facade.", (Object)this.remoteDeviceId);
            salFacade = new KeepaliveSalFacade(this.remoteDeviceId, salFacade, this.netconfTopologyDeviceSetup.getKeepaliveExecutor(), keepaliveDelay, defaultRequestTimeoutMillis);
        }
        NetconfDevice.SchemaResourcesDTO schemaResourcesDTO = this.netconfTopologyDeviceSetup.getSchemaResourcesDTO();
        ArrayList registeredYangLibSources = Lists.newArrayList();
        if (node.getYangLibrary() != null) {
            String yangLibURL = node.getYangLibrary().getYangLibraryUrl().getValue();
            String yangLibUsername = node.getYangLibrary().getUsername();
            String yangLigPassword = node.getYangLibrary().getPassword();
            if (yangLibURL != null) {
                LibraryModulesSchemas libraryModulesSchemas = yangLibUsername != null && yangLigPassword != null ? LibraryModulesSchemas.create((String)yangLibURL, (String)yangLibUsername, (String)yangLigPassword) : LibraryModulesSchemas.create((String)yangLibURL);
                for (Map.Entry sourceIdentifierURLEntry : libraryModulesSchemas.getAvailableModels().entrySet()) {
                    registeredYangLibSources.add(schemaResourcesDTO.getSchemaRegistry().registerSchemaSource((SchemaSourceProvider)new YangLibrarySchemaYangSourceProvider(this.remoteDeviceId, libraryModulesSchemas.getAvailableModels()), PotentialSchemaSource.create((SourceIdentifier)((SourceIdentifier)sourceIdentifierURLEntry.getKey()), YangTextSchemaSource.class, (int)PotentialSchemaSource.Costs.REMOTE_IO.getValue())));
                }
            }
        }
        Object device = node.isSchemaless() != false ? new SchemalessNetconfDevice(this.remoteDeviceId, (RemoteDeviceHandler)salFacade) : new NetconfDeviceBuilder().setReconnectOnSchemasChange(reconnectOnChangedSchema).setSchemaResourcesDTO(schemaResourcesDTO).setGlobalProcessingExecutor(this.netconfTopologyDeviceSetup.getProcessingExecutor()).setId(this.remoteDeviceId).setSalFacade((RemoteDeviceHandler)salFacade).build();
        Optional<NetconfSessionPreferences> userCapabilities = RemoteDeviceConnectorImpl.getUserCapabilities(node);
        int n = rpcMessageLimit = node.getConcurrentRpcLimit() == null ? 0 : node.getConcurrentRpcLimit();
        if (rpcMessageLimit < 1) {
            LOG.info("{}: Concurrent rpc limit is smaller than 1, no limit will be enforced.", (Object)this.remoteDeviceId);
        }
        NetconfDeviceCommunicator netconfDeviceCommunicator2 = userCapabilities.isPresent() ? new NetconfDeviceCommunicator(this.remoteDeviceId, (RemoteDevice)device, new UserPreferences(userCapabilities.get(), Objects.isNull(node.getYangModuleCapabilities()) ? false : node.getYangModuleCapabilities().isOverride(), Objects.isNull(node.getNonModuleCapabilities()) ? false : node.getNonModuleCapabilities().isOverride()), rpcMessageLimit) : (netconfDeviceCommunicator = new NetconfDeviceCommunicator(this.remoteDeviceId, (RemoteDevice)device, rpcMessageLimit));
        if (salFacade instanceof KeepaliveSalFacade) {
            salFacade.setListener(netconfDeviceCommunicator);
        }
        return new NetconfConnectorDTO(netconfDeviceCommunicator, (RemoteDeviceHandler<NetconfSessionPreferences>)salFacade);
    }

    private static Optional<NetconfSessionPreferences> getUserCapabilities(NetconfNode node) {
        if (node.getYangModuleCapabilities() == null && node.getNonModuleCapabilities() == null) {
            return Optional.empty();
        }
        ArrayList capabilities = new ArrayList();
        if (node.getYangModuleCapabilities() != null) {
            capabilities.addAll(node.getYangModuleCapabilities().getCapability());
        }
        NetconfSessionPreferences netconfSessionPreferences = NetconfSessionPreferences.fromStrings(capabilities);
        Preconditions.checkState((boolean)netconfSessionPreferences.getNonModuleCaps().isEmpty(), (Object)("List yang-module-capabilities/capability should contain only module based capabilities. Non-module capabilities used: " + netconfSessionPreferences.getNonModuleCaps()));
        if (node.getNonModuleCapabilities() != null) {
            capabilities.addAll(node.getNonModuleCapabilities().getCapability());
        }
        return Optional.of(NetconfSessionPreferences.fromStrings(capabilities, (AvailableCapability.CapabilityOrigin)AvailableCapability.CapabilityOrigin.UserDefined));
    }

    private static InetSocketAddress getSocketAddress(Host host, int port) {
        if (host.getDomainName() != null) {
            return new InetSocketAddress(host.getDomainName().getValue(), port);
        }
        IpAddress ipAddress = host.getIpAddress();
        String ip = ipAddress.getIpv4Address() != null ? ipAddress.getIpv4Address().getValue() : ipAddress.getIpv6Address().getValue();
        return new InetSocketAddress(ip, port);
    }

    @VisibleForTesting
    NetconfReconnectingClientConfiguration getClientConfig(NetconfClientSessionListener listener, NetconfNode node) {
        NetconfReconnectingClientConfigurationBuilder reconnectingClientConfigurationBuilder;
        long clientConnectionTimeoutMillis = node.getConnectionTimeoutMillis() == null ? 20000L : node.getConnectionTimeoutMillis();
        long maxConnectionAttempts = node.getMaxConnectionAttempts() == null ? 0L : node.getMaxConnectionAttempts();
        int betweenAttemptsTimeoutMillis = node.getBetweenAttemptsTimeoutMillis() == null ? 2000 : node.getBetweenAttemptsTimeoutMillis();
        BigDecimal sleepFactor = node.getSleepFactor() == null ? NetconfTopologyUtils.DEFAULT_SLEEP_FACTOR : node.getSleepFactor();
        InetSocketAddress socketAddress = RemoteDeviceConnectorImpl.getSocketAddress(node.getHost(), node.getPort().getValue());
        TimedReconnectStrategyFactory sf = new TimedReconnectStrategyFactory(this.netconfTopologyDeviceSetup.getEventExecutor(), Long.valueOf(maxConnectionAttempts), betweenAttemptsTimeoutMillis, sleepFactor);
        Protocol protocol = node.getProtocol();
        if (node.isTcpOnly().booleanValue()) {
            reconnectingClientConfigurationBuilder = NetconfReconnectingClientConfigurationBuilder.create().withProtocol(NetconfClientConfiguration.NetconfClientProtocol.TCP).withAuthHandler(this.getHandlerFromCredentials(node.getCredentials()));
        } else if (protocol == null || protocol.getName() == Protocol.Name.SSH) {
            reconnectingClientConfigurationBuilder = NetconfReconnectingClientConfigurationBuilder.create().withProtocol(NetconfClientConfiguration.NetconfClientProtocol.SSH).withAuthHandler(this.getHandlerFromCredentials(node.getCredentials()));
        } else if (protocol.getName() == Protocol.Name.TLS) {
            reconnectingClientConfigurationBuilder = NetconfReconnectingClientConfigurationBuilder.create().withSslHandlerFactory((SslHandlerFactory)new SslHandlerFactoryImpl(this.keystoreAdapter, protocol.getSpecification())).withProtocol(NetconfClientConfiguration.NetconfClientProtocol.TLS);
        } else {
            throw new IllegalStateException("Unsupported protocol type: " + protocol.getName());
        }
        List<Uri> odlHelloCapabilities = RemoteDeviceConnectorImpl.getOdlHelloCapabilities(node);
        if (odlHelloCapabilities != null) {
            reconnectingClientConfigurationBuilder.withOdlHelloCapabilities(odlHelloCapabilities);
        }
        return reconnectingClientConfigurationBuilder.withAddress(socketAddress).withConnectionTimeoutMillis(clientConnectionTimeoutMillis).withReconnectStrategy(sf.createReconnectStrategy()).withConnectStrategyFactory((ReconnectStrategyFactory)sf).withSessionListener(listener).build();
    }

    private static List<Uri> getOdlHelloCapabilities(NetconfNode node) {
        OdlHelloMessageCapabilities helloCapabilities = node.getOdlHelloMessageCapabilities();
        return helloCapabilities != null ? helloCapabilities.getCapability() : null;
    }

    private AuthenticationHandler getHandlerFromCredentials(Credentials credentials) {
        if (credentials instanceof LoginPassword) {
            LoginPassword loginPassword = (LoginPassword)credentials;
            return new LoginPasswordHandler(loginPassword.getUsername(), loginPassword.getPassword());
        }
        if (credentials instanceof LoginPwUnencrypted) {
            LoginPasswordUnencrypted loginPassword = ((LoginPwUnencrypted)credentials).getLoginPasswordUnencrypted();
            return new LoginPasswordHandler(loginPassword.getUsername(), loginPassword.getPassword());
        }
        if (credentials instanceof LoginPw) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.login.pw.LoginPassword loginPassword = ((LoginPw)credentials).getLoginPassword();
            return new LoginPasswordHandler(loginPassword.getUsername(), this.encryptionService.decrypt(loginPassword.getPassword()));
        }
        if (credentials instanceof KeyAuth) {
            KeyBased keyPair = ((KeyAuth)credentials).getKeyBased();
            return new DatastoreBackedPublicKeyAuth(keyPair.getUsername(), keyPair.getKeyId(), this.keystoreAdapter, this.encryptionService);
        }
        throw new IllegalStateException("Unsupported credential type: " + credentials.getClass());
    }
}

