/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.impl.tx.ProxyReadTransaction;
import org.opendaylight.netconf.topology.singleton.impl.tx.ProxyReadWriteTransaction;
import org.opendaylight.netconf.topology.singleton.messages.transactions.NewReadTransactionRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.NewReadWriteTransactionRequest;
import org.opendaylight.netconf.topology.singleton.messages.transactions.NewWriteTransactionRequest;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class ProxyDOMDataBroker
implements DOMDataBroker {
    private final Timeout askTimeout;
    private final RemoteDeviceId id;
    private final ActorRef masterNode;
    private final ExecutionContext executionContext;

    public ProxyDOMDataBroker(RemoteDeviceId id, ActorRef masterNode, ExecutionContext executionContext, Timeout askTimeout) {
        this.id = id;
        this.masterNode = masterNode;
        this.executionContext = executionContext;
        this.askTimeout = askTimeout;
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        Future txActorFuture = Patterns.ask((ActorRef)this.masterNode, (Object)new NewReadTransactionRequest(), (Timeout)this.askTimeout);
        return new ProxyReadTransaction(this.id, (Future<Object>)txActorFuture, this.executionContext, this.askTimeout);
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        Future txActorFuture = Patterns.ask((ActorRef)this.masterNode, (Object)new NewReadWriteTransactionRequest(), (Timeout)this.askTimeout);
        return new ProxyReadWriteTransaction(this.id, (Future<Object>)txActorFuture, this.executionContext, this.askTimeout);
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        Future txActorFuture = Patterns.ask((ActorRef)this.masterNode, (Object)new NewWriteTransactionRequest(), (Timeout)this.askTimeout);
        return new ProxyReadWriteTransaction(this.id, (Future<Object>)txActorFuture, this.executionContext, this.askTimeout);
    }

    public DOMTransactionChain createTransactionChain(DOMTransactionChainListener listener) {
        throw new UnsupportedOperationException(this.id + ": Transaction chains not supported for netconf mount point");
    }

    public ClassToInstanceMap<DOMDataBrokerExtension> getExtensions() {
        return ImmutableClassToInstanceMap.of();
    }
}

