/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.singleton.impl;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.cluster.Cluster;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.sal.connect.api.RemoteDeviceHandler;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfDeviceCapabilities;
import org.opendaylight.netconf.sal.connect.netconf.listener.NetconfSessionPreferences;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceDataBroker;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceNotificationService;
import org.opendaylight.netconf.sal.connect.netconf.sal.NetconfDeviceSalProvider;
import org.opendaylight.netconf.sal.connect.util.RemoteDeviceId;
import org.opendaylight.netconf.topology.singleton.impl.ProxyDOMDataBroker;
import org.opendaylight.netconf.topology.singleton.messages.CreateInitialMasterActorData;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

class MasterSalFacade
implements AutoCloseable,
RemoteDeviceHandler<NetconfSessionPreferences> {
    private static final Logger LOG = LoggerFactory.getLogger(MasterSalFacade.class);
    private final RemoteDeviceId id;
    private final Timeout actorResponseWaitTime;
    private final NetconfDeviceSalProvider salProvider;
    private final ActorRef masterActorRef;
    private final ActorSystem actorSystem;
    private SchemaContext currentSchemaContext = null;
    private NetconfSessionPreferences netconfSessionPreferences = null;
    private DOMRpcService deviceRpc = null;
    private DOMDataBroker deviceDataBroker = null;

    MasterSalFacade(RemoteDeviceId id, ActorSystem actorSystem, ActorRef masterActorRef, Timeout actorResponseWaitTime, DOMMountPointService mountService, DataBroker dataBroker) {
        this.id = id;
        this.salProvider = new NetconfDeviceSalProvider(id, mountService, dataBroker);
        this.actorSystem = actorSystem;
        this.masterActorRef = masterActorRef;
        this.actorResponseWaitTime = actorResponseWaitTime;
    }

    public void onDeviceConnected(SchemaContext remoteSchemaContext, NetconfSessionPreferences sessionPreferences, DOMRpcService domRpcService, DOMActionService domActionService) {
        if (domActionService != null) {
            LOG.warn("{}: YANG 1.1 actions are not supported in clustered netconf topology, DOMActionService will not be exposed for the device", (Object)this.id);
        }
        this.onDeviceConnected(remoteSchemaContext, sessionPreferences, domRpcService);
    }

    public void onDeviceConnected(SchemaContext remoteSchemaContext, NetconfSessionPreferences sessionPreferences, DOMRpcService domRpcService) {
        this.currentSchemaContext = remoteSchemaContext;
        this.netconfSessionPreferences = sessionPreferences;
        this.deviceRpc = domRpcService;
        LOG.info("Device {} connected - registering master mount point", (Object)this.id);
        this.registerMasterMountPoint();
        this.sendInitialDataToActor().onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object success) {
                if (failure == null) {
                    MasterSalFacade.this.updateDeviceData();
                    return;
                }
                LOG.error("{}: CreateInitialMasterActorData to {} failed", new Object[]{MasterSalFacade.this.id, MasterSalFacade.this.masterActorRef, failure});
            }
        }, (ExecutionContext)this.actorSystem.dispatcher());
    }

    public void onDeviceDisconnected() {
        LOG.info("Device {} disconnected - unregistering master mount point", (Object)this.id);
        this.salProvider.getTopologyDatastoreAdapter().updateDeviceData(false, new NetconfDeviceCapabilities());
        this.unregisterMasterMountPoint();
    }

    public void onDeviceFailed(Throwable throwable) {
        this.salProvider.getTopologyDatastoreAdapter().setDeviceAsFailed(throwable);
        this.unregisterMasterMountPoint();
    }

    public void onNotification(DOMNotification domNotification) {
        this.salProvider.getMountInstance().publish(domNotification);
    }

    @Override
    public void close() {
        this.unregisterMasterMountPoint();
        this.closeGracefully((AutoCloseable)this.salProvider);
    }

    private void registerMasterMountPoint() {
        Preconditions.checkNotNull((Object)this.id);
        Preconditions.checkNotNull((Object)this.currentSchemaContext, (Object)"Device has no remote schema context yet. Probably not fully connected.");
        Preconditions.checkNotNull((Object)this.netconfSessionPreferences, (Object)"Device has no capabilities yet. Probably not fully connected.");
        NetconfDeviceNotificationService notificationService = new NetconfDeviceNotificationService();
        this.deviceDataBroker = this.newDeviceDataBroker();
        ProxyDOMDataBroker proxyDataBroker = new ProxyDOMDataBroker(this.id, this.masterActorRef, (ExecutionContext)this.actorSystem.dispatcher(), this.actorResponseWaitTime);
        this.salProvider.getMountInstance().onTopologyDeviceConnected(this.currentSchemaContext, (DOMDataBroker)proxyDataBroker, this.deviceRpc, notificationService);
    }

    protected DOMDataBroker newDeviceDataBroker() {
        return new NetconfDeviceDataBroker(this.id, this.currentSchemaContext, this.deviceRpc, this.netconfSessionPreferences);
    }

    private Future<Object> sendInitialDataToActor() {
        List<SourceIdentifier> sourceIdentifiers = SchemaContextUtil.getConstituentModuleIdentifiers((SchemaContext)this.currentSchemaContext).stream().map(mi -> RevisionSourceIdentifier.create((String)mi.getName(), (Optional)mi.getRevision())).collect(Collectors.toList());
        LOG.debug("{}: Sending CreateInitialMasterActorData with sourceIdentifiers {} to {}", new Object[]{this.id, sourceIdentifiers, this.masterActorRef});
        return Patterns.ask((ActorRef)this.masterActorRef, (Object)new CreateInitialMasterActorData(this.deviceDataBroker, sourceIdentifiers, this.deviceRpc), (Timeout)this.actorResponseWaitTime);
    }

    private void updateDeviceData() {
        String masterAddress = Cluster.get((ActorSystem)this.actorSystem).selfAddress().toString();
        LOG.debug("{}: updateDeviceData with master address {}", (Object)this.id, (Object)masterAddress);
        this.salProvider.getTopologyDatastoreAdapter().updateClusteredDeviceData(true, masterAddress, this.netconfSessionPreferences.getNetconfDeviceCapabilities());
    }

    private void unregisterMasterMountPoint() {
        this.salProvider.getMountInstance().onTopologyDeviceDisconnected();
    }

    private void closeGracefully(AutoCloseable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception e) {
                LOG.error("{}: Ignoring exception while closing {}", new Object[]{this.id, resource, e});
            }
        }
    }
}

