/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.collect.Iterators;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.export.ModuleNamespaceContext;

final class YinXMLEventReader
implements XMLEventReader {
    private final Deque<OpenElement> stack = new ArrayDeque<OpenElement>(8);
    private final Queue<XMLEvent> events = new ArrayDeque<XMLEvent>();
    private final ModuleNamespaceContext namespaceContext;
    private final XMLEventFactory eventFactory;

    YinXMLEventReader(XMLEventFactory eventFactory, ModuleNamespaceContext namespaceContext, DeclaredStatement<?> root) {
        this.eventFactory = Objects.requireNonNull(eventFactory);
        this.namespaceContext = Objects.requireNonNull(namespaceContext);
        this.events.add(eventFactory.createStartDocument(StandardCharsets.UTF_8.name()));
        StatementDefinition def = root.statementDefinition();
        QName name = def.getStatementName();
        this.events.add(eventFactory.createStartElement("", name.getNamespace().toString(), name.getLocalName(), (Iterator<? extends Attribute>)Iterators.singletonIterator((Object)this.attribute(def.getArgumentName(), root.rawArgument())), Iterators.transform(namespaceContext.prefixesAndNamespaces().entrySet().iterator(), e -> eventFactory.createNamespace((String)e.getKey(), (String)e.getValue())), namespaceContext));
        this.stack.push(new OpenElement(name, root.declaredSubstatements().iterator()));
    }

    @Override
    public XMLEvent next() {
        XMLEvent event = this.events.poll();
        if (event != null) {
            return event;
        }
        this.nextStatement();
        event = this.events.poll();
        if (event == null) {
            throw new NoSuchElementException("All events have been processed");
        }
        return event;
    }

    @Override
    public XMLEvent nextEvent() {
        return this.next();
    }

    @Override
    public boolean hasNext() {
        if (this.events.isEmpty()) {
            this.nextStatement();
            return this.events.isEmpty();
        }
        return true;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (this.events.isEmpty()) {
            this.nextStatement();
        }
        return this.events.peek();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        XMLEvent current = this.peek();
        if (current == null) {
            throw new XMLStreamException("End of event stream");
        }
        if (!(current instanceof StartElement)) {
            throw new XMLStreamException("Current event is " + current);
        }
        current = this.next();
        if (!(current instanceof Characters)) {
            throw new XMLStreamException("Encountered non-text event " + current);
        }
        String ret = ((Characters)current).getData();
        current = this.next();
        if (!(current instanceof EndElement)) {
            throw new XMLStreamException("Encountered unexpected event " + current);
        }
        return ret;
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent next = this.next();
        if (next instanceof Characters) {
            throw new XMLStreamException("Significant characters encountered: " + next);
        }
        return next;
    }

    @Override
    public Object getProperty(String name) {
        throw new IllegalArgumentException("Property " + name + " not supported");
    }

    @Override
    public void close() {
        this.events.clear();
        this.stack.clear();
    }

    private Attribute attribute(QName qname, String value) {
        Map.Entry<String, String> ns = this.namespaceContext.prefixAndNamespaceFor(qname.getModule());
        return this.eventFactory.createAttribute(ns.getKey(), ns.getValue(), qname.getLocalName(), value);
    }

    private StartElement startElement(QName qname) {
        Map.Entry<String, String> ns = this.namespaceContext.prefixAndNamespaceFor(qname.getModule());
        return this.eventFactory.createStartElement(ns.getKey(), ns.getValue(), qname.getLocalName(), Collections.emptyIterator(), Collections.emptyIterator(), this.namespaceContext);
    }

    private EndElement endElement(QName qname) {
        Map.Entry<String, String> ns = this.namespaceContext.prefixAndNamespaceFor(qname.getModule());
        return this.eventFactory.createEndElement(ns.getKey(), ns.getValue(), qname.getLocalName());
    }

    private void nextStatement() {
        OpenElement current = this.stack.peek();
        if (current == null) {
            return;
        }
        block4: while (true) {
            if (current.children.hasNext()) {
                DeclaredStatement<?> child = current.children.next();
                switch (child.getStatementSource()) {
                    case CONTEXT: {
                        Iterator it = child.declaredSubstatements().iterator();
                        if (!it.hasNext()) continue block4;
                        current = new OpenElement(it);
                        continue block4;
                    }
                    case DECLARATION: {
                        this.addStatement(child);
                        return;
                    }
                }
                throw new IllegalStateException("Unhandled statement source " + child.getStatementSource());
            }
            if (current.name != null) {
                this.events.add(this.endElement(current.name));
            }
            this.stack.pop();
            if (this.stack.isEmpty()) {
                this.events.add(this.eventFactory.createEndDocument());
            }
            if (!this.events.isEmpty()) break;
        }
    }

    private void addStatement(DeclaredStatement<?> statement) {
        StatementDefinition def = statement.statementDefinition();
        QName name = def.getStatementName();
        QName argName = def.getArgumentName();
        if (argName != null) {
            if (def.isArgumentYinElement()) {
                this.events.addAll(Arrays.asList(this.startElement(name), this.startElement(argName), this.eventFactory.createCharacters(statement.rawArgument()), this.endElement(argName)));
            } else {
                Map.Entry<String, String> ns = this.namespaceContext.prefixAndNamespaceFor(name.getModule());
                this.events.add(this.eventFactory.createStartElement(ns.getKey(), ns.getValue(), name.getLocalName(), (Iterator<? extends Attribute>)Iterators.singletonIterator((Object)this.attribute(argName, statement.rawArgument())), Collections.emptyIterator(), this.namespaceContext));
            }
        } else {
            this.events.add(this.startElement(name));
        }
        this.stack.push(new OpenElement(name, statement.declaredSubstatements().iterator()));
    }

    private static final class OpenElement {
        final Iterator<? extends DeclaredStatement<?>> children;
        final QName name;

        OpenElement(Iterator<? extends DeclaredStatement<?>> children) {
            this.children = Objects.requireNonNull(children);
            this.name = null;
        }

        OpenElement(QName name, Iterator<? extends DeclaredStatement<?>> children) {
            this.children = Objects.requireNonNull(children);
            this.name = Objects.requireNonNull(name);
        }
    }
}

