/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.export.SchemaContextEmitter;
import org.opendaylight.yangtools.yang.model.export.SingleModuleYinStatementWriter;
import org.opendaylight.yangtools.yang.model.export.StatementTextWriter;
import org.opendaylight.yangtools.yang.model.export.YinXMLEventReaderFactory;

public final class YinExportUtils {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final XMLOutputFactory OUTPUT_FACTORY = XMLOutputFactory.newFactory();

    private YinExportUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String wellFormedYinName(String name, Optional<Revision> revision) {
        return YinExportUtils.wellFormedYinName(name, revision.map(Revision::toString).orElse(null));
    }

    public static String wellFormedYinName(String name, String revision) {
        if (revision == null) {
            return name + ".yin";
        }
        return Objects.requireNonNull(name) + '@' + revision + ".yin";
    }

    @Beta
    public static void writeModuleAsYinText(Module module, OutputStream output) throws XMLStreamException {
        Objects.requireNonNull(module);
        Preconditions.checkArgument((boolean)(module instanceof ModuleEffectiveStatement), (String)"Module %s is not a ModuleEffectiveStatement", (Object)module);
        ModuleEffectiveStatement effective = (ModuleEffectiveStatement)module;
        YinExportUtils.writeReaderToOutput(YinXMLEventReaderFactory.defaultInstance().createXMLEventReader(effective), output);
    }

    @Beta
    public static void writeSubmoduleAsYinText(Module parentModule, Module submodule, OutputStream output) throws XMLStreamException {
        Objects.requireNonNull(parentModule);
        Preconditions.checkArgument((boolean)(parentModule instanceof ModuleEffectiveStatement), (String)"Parent %s is not a ModuleEffectiveStatement", (Object)parentModule);
        Objects.requireNonNull(submodule);
        Preconditions.checkArgument((boolean)(submodule instanceof SubmoduleEffectiveStatement), (String)"Submodule %s is not a SubmoduleEffectiveStatement", (Object)submodule);
        YinExportUtils.writeReaderToOutput(YinXMLEventReaderFactory.defaultInstance().createXMLEventReader((ModuleEffectiveStatement)parentModule, (SubmoduleEffectiveStatement)submodule), output);
    }

    @Deprecated
    public static void writeModuleToOutputStream(SchemaContext ctx, Module module, OutputStream str) throws XMLStreamException {
        YinExportUtils.writeModuleToOutputStream(ctx, module, str, false);
    }

    @Deprecated
    public static void writeModuleToOutputStream(SchemaContext ctx, Module module, OutputStream str, boolean emitInstantiated) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = OUTPUT_FACTORY.createXMLStreamWriter(str);
        YinExportUtils.writeModuleToOutputStream(ctx, module, xmlStreamWriter, emitInstantiated);
        xmlStreamWriter.flush();
    }

    private static void writeModuleToOutputStream(SchemaContext ctx, Module module, XMLStreamWriter xmlStreamWriter, boolean emitInstantiated) {
        URI moduleNs = module.getNamespace();
        Map<String, URI> prefixToNs = YinExportUtils.prefixToNamespace(ctx, module);
        StatementTextWriter yinWriter = SingleModuleYinStatementWriter.create(xmlStreamWriter, moduleNs, prefixToNs);
        SchemaContextEmitter.writeToStatementWriter(module, ctx, yinWriter, emitInstantiated);
    }

    private static Map<String, URI> prefixToNamespace(SchemaContext ctx, Module module) {
        HashBiMap prefixMap = HashBiMap.create((int)(module.getImports().size() + 1));
        prefixMap.put((Object)module.getPrefix(), (Object)module.getNamespace());
        for (ModuleImport imp : module.getImports()) {
            String prefix = imp.getPrefix();
            URI namespace = YinExportUtils.getModuleNamespace(ctx, imp.getModuleName());
            prefixMap.put((Object)prefix, (Object)namespace);
        }
        return prefixMap;
    }

    private static URI getModuleNamespace(SchemaContext ctx, String moduleName) {
        for (Module module : ctx.getModules()) {
            if (!moduleName.equals(module.getName())) continue;
            return module.getNamespace();
        }
        throw new IllegalArgumentException("Module " + moduleName + "does not exists in provided schema context");
    }

    private static void writeReaderToOutput(XMLEventReader reader, OutputStream output) throws XMLStreamException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.transform(new StAXSource(reader), new StreamResult(output));
        }
        catch (TransformerException e) {
            throw new XMLStreamException("Failed to stream XML events", e);
        }
    }
}

