/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.export.ExportUtils;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
final class YangTextSnippetIterator
extends AbstractIterator<String> {
    private static final CharMatcher NEED_QUOTE_MATCHER = CharMatcher.anyOf((CharSequence)" \t\r'\";{}");
    private static final CharMatcher DQUOT_MATCHER = CharMatcher.is((char)'\"');
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    private static final Collection<StatementDefinition> QUOTE_MULTILINE_STATEMENTS = ImmutableSet.of((Object)YangStmtMapping.CONTACT, (Object)YangStmtMapping.DESCRIPTION, (Object)YangStmtMapping.ERROR_MESSAGE, (Object)YangStmtMapping.ORGANIZATION, (Object)YangStmtMapping.REFERENCE);
    private static final Map<StatementDefinition, String> DEFAULT_STATEMENTS = ImmutableMap.builder().put((Object)YangStmtMapping.CONFIG, (Object)"true").put((Object)YangStmtMapping.MANDATORY, (Object)"true").put((Object)YangStmtMapping.MAX_ELEMENTS, (Object)"unbounded").put((Object)YangStmtMapping.MIN_ELEMENTS, (Object)"0").put((Object)YangStmtMapping.ORDERED_BY, (Object)"system").put((Object)YangStmtMapping.REQUIRE_INSTANCE, (Object)"true").put((Object)YangStmtMapping.STATUS, (Object)"current").put((Object)YangStmtMapping.YIN_ELEMENT, (Object)"false").build();
    private static final String INDENT = "  ";
    private static final int INDENT_STRINGS_SIZE = 16;
    private static final String[] INDENT_STRINGS = new String[16];
    private final Queue<String> strings = new ArrayDeque<String>(8);
    private final Deque<Iterator<? extends DeclaredStatement<?>>> stack = new ArrayDeque(8);
    private final Map<QNameModule, @NonNull String> namespaces;
    private final Set<StatementDefinition> ignoredStatements;
    private final boolean omitDefaultStatements;

    YangTextSnippetIterator(DeclaredStatement<?> stmt, Map<QNameModule, @NonNull String> namespaces, Set<StatementDefinition> ignoredStatements, boolean omitDefaultStatements) {
        this.namespaces = Objects.requireNonNull(namespaces);
        this.ignoredStatements = Objects.requireNonNull(ignoredStatements);
        this.omitDefaultStatements = omitDefaultStatements;
        this.pushStatement(Objects.requireNonNull(stmt));
    }

    protected @NonNull String computeNext() {
        String nextString = this.strings.poll();
        if (nextString != null) {
            return nextString;
        }
        Iterator<DeclaredStatement<?>> it = this.stack.peek();
        if (it == null) {
            this.endOfData();
            return "";
        }
        while (it.hasNext()) {
            if (!this.pushStatement(it.next())) continue;
            return this.strings.remove();
        }
        this.stack.pop();
        this.addIndent();
        this.strings.add("}\n");
        return this.strings.remove();
    }

    private boolean pushStatement(DeclaredStatement<?> stmt) {
        String suppressValue;
        StatementDefinition def = stmt.statementDefinition();
        if (this.ignoredStatements.contains(def)) {
            return false;
        }
        Collection children = stmt.declaredSubstatements();
        if (this.omitDefaultStatements && children.isEmpty() && (suppressValue = DEFAULT_STATEMENTS.get(def)) != null && suppressValue.equals(stmt.rawArgument())) {
            return false;
        }
        this.addIndent();
        QName stmtName = def.getStatementName();
        Optional<String> prefix = ExportUtils.statementPrefix(this.namespaces, stmtName);
        if (prefix.isPresent()) {
            this.strings.add(prefix.get());
            this.strings.add(":");
        }
        this.strings.add(stmtName.getLocalName());
        this.addArgument(def, stmt.rawArgument());
        if (!children.isEmpty()) {
            this.strings.add(" {\n");
            this.stack.push(children.iterator());
        } else {
            this.strings.add(";\n");
        }
        return true;
    }

    private void addIndent() {
        int depth;
        for (depth = this.stack.size(); depth >= 16; depth -= 16) {
            this.strings.add(INDENT_STRINGS[15]);
        }
        if (depth > 0) {
            this.strings.add(INDENT_STRINGS[depth]);
        }
    }

    private void addArgument(StatementDefinition def, @Nullable String arg) {
        if (arg == null) {
            return;
        }
        switch (YangTextSnippetIterator.quoteKind(def, arg)) {
            case EMPTY: {
                this.strings.add(" \"\"");
                break;
            }
            case NONE: {
                this.strings.add(" ");
                this.strings.add(arg);
                break;
            }
            case SIMPLE: {
                this.strings.add(" \"");
                this.strings.add(DQUOT_MATCHER.replaceFrom((CharSequence)arg, (CharSequence)"\\\""));
                this.strings.add("\"");
                break;
            }
            case MULTILINE: {
                this.strings.add("\n");
                this.addIndent();
                this.strings.add("  \"");
                Iterator it = NEWLINE_SPLITTER.split((CharSequence)DQUOT_MATCHER.replaceFrom((CharSequence)arg, (CharSequence)"\\\"")).iterator();
                String first = (String)it.next();
                if (!first.isEmpty()) {
                    this.strings.add(first);
                }
                while (it.hasNext()) {
                    this.strings.add("\n");
                    String str = (String)it.next();
                    if (str.isEmpty()) continue;
                    this.addIndent();
                    this.strings.add("   ");
                    this.strings.add(str);
                }
                this.strings.add("\"");
                break;
            }
            default: {
                throw new IllegalStateException("Illegal quoting for " + def + " argument \"" + arg + "\"");
            }
        }
    }

    private static Quoting quoteKind(StatementDefinition def, String str) {
        if (str.isEmpty()) {
            return Quoting.EMPTY;
        }
        if (QUOTE_MULTILINE_STATEMENTS.contains(def) || str.indexOf(10) != -1) {
            return Quoting.MULTILINE;
        }
        if (NEED_QUOTE_MATCHER.matchesAnyOf((CharSequence)str) || str.contains("//") || str.contains("/*") || str.contains("*/")) {
            return Quoting.SIMPLE;
        }
        return Quoting.NONE;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            YangTextSnippetIterator.INDENT_STRINGS[i] = Strings.repeat((String)INDENT, (int)i).intern();
        }
    }

    private static enum Quoting {
        NONE,
        EMPTY,
        SIMPLE,
        MULTILINE;

    }
}

