/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.primitives.UnsignedInteger;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AnyDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.MustConstraintAware;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UniqueConstraint;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ArgumentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BitStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BodyGroup;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ConfigStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContactStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataDefinitionContainer;
import org.opendaylight.yangtools.yang.model.api.stmt.DataDefinitionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviateStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DocumentationGroup;
import org.opendaylight.yangtools.yang.model.api.stmt.DocumentedConstraintGroup;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorAppTagStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorMessageStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IncludeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LinkageGroup;
import org.opendaylight.yangtools.yang.model.api.stmt.ListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MaxElementsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MetaGroup;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModifierStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MustStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OperationGroup;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrganizationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PathStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PositionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionGroup;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UniqueStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YinElementStatement;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.export.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.export.SchemaToStatementWriterAdaptor;
import org.opendaylight.yangtools.yang.model.export.StatementTextWriter;
import org.opendaylight.yangtools.yang.model.export.YangModuleWriter;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;

@Deprecated
@Beta
@NotThreadSafe
abstract class SchemaContextEmitter {
    final YangModuleWriter writer;
    final boolean emitInstantiated;
    final boolean emitUses;
    final Map<QName, StatementDefinition> extensions;
    final YangVersion yangVersion;

    SchemaContextEmitter(YangModuleWriter writer, Map<QName, StatementDefinition> extensions, YangVersion yangVersion) {
        this(writer, extensions, yangVersion, false, true);
    }

    SchemaContextEmitter(YangModuleWriter writer, Map<QName, StatementDefinition> extensions, YangVersion yangVersion, boolean emitInstantiated, boolean emitUses) {
        this.writer = Objects.requireNonNull(writer);
        this.emitInstantiated = emitInstantiated;
        this.emitUses = emitUses;
        this.extensions = Objects.requireNonNull(extensions);
        this.yangVersion = yangVersion;
    }

    static void writeToStatementWriter(Module module, SchemaContext ctx, StatementTextWriter statementWriter, boolean emitInstantiated) {
        YangModuleWriter yangSchemaWriter = SchemaToStatementWriterAdaptor.from(statementWriter);
        Map<QName, StatementDefinition> extensions = ExtensionStatement.mapFrom(ctx.getExtensions());
        if (module instanceof EffectiveStatement && !emitInstantiated) {
            new DeclaredSchemaContextEmitter(yangSchemaWriter, extensions, module.getYangVersion()).emitModule(((EffectiveStatement)module).getDeclared());
        } else {
            new EffectiveSchemaContextEmitter(yangSchemaWriter, extensions, module.getYangVersion(), emitInstantiated).emitModule(module);
        }
    }

    static <T> boolean isPrefix(Iterable<T> prefix, Iterable<T> other) {
        Iterator<T> prefixIt = prefix.iterator();
        Iterator<T> otherIt = other.iterator();
        while (prefixIt.hasNext()) {
            if (!otherIt.hasNext()) {
                return false;
            }
            if (Objects.deepEquals(prefixIt.next(), otherIt.next())) continue;
            return false;
        }
        return true;
    }

    static class EffectiveSchemaContextEmitter
    extends SchemaContextEmitter {
        EffectiveSchemaContextEmitter(YangModuleWriter writer, Map<QName, StatementDefinition> extensions, YangVersion yangVersion, boolean emitInstantiated) {
            super(writer, extensions, yangVersion, emitInstantiated, true);
        }

        void emitModule(Module input) {
            this.writer.startModuleNode(input.getName());
            this.emitModuleHeader(input);
            this.emitLinkageNodes(input);
            this.emitMetaNodes(input);
            this.emitRevisionNodes(input);
            this.emitBodyNodes(input);
            this.writer.endNode();
        }

        private void emitModuleHeader(Module input) {
            this.emitYangVersionNode(input.getYangVersion());
            this.emitNamespace(input.getNamespace());
            this.emitPrefixNode(input.getPrefix());
        }

        private void emitSubmodule(String input) {
        }

        private void emitSubmoduleHeaderNodes(Module input) {
        }

        private void emitMetaNodes(Module input) {
            input.getOrganization().ifPresent(this::emitOrganizationNode);
            input.getContact().ifPresent(this::emitContact);
            this.emitDocumentedNode((DocumentedNode)input);
        }

        private void emitLinkageNodes(Module input) {
            for (ModuleImport importNode : input.getImports()) {
                this.emitImport(importNode);
            }
        }

        private void emitRevisionNodes(Module input) {
            input.getRevision().ifPresent(this::emitRevision);
        }

        private void emitBodyNodes(Module input) {
            for (ExtensionDefinition extension : input.getExtensionSchemaNodes()) {
                this.emitExtension(extension);
            }
            for (FeatureDefinition definition : input.getFeatures()) {
                this.emitFeature(definition);
            }
            for (IdentitySchemaNode identity : input.getIdentities()) {
                this.emitIdentity(identity);
            }
            for (Deviation deviation : input.getDeviations()) {
                this.emitDeviation(deviation);
            }
            this.emitDataNodeContainer((DataNodeContainer)input);
            for (AugmentationSchemaNode augmentation : input.getAugmentations()) {
                this.emitAugment(augmentation);
            }
            for (RpcDefinition rpc : input.getRpcs()) {
                this.emitRpc(rpc);
            }
            this.emitNotifications(input.getNotifications());
        }

        private void emitDataNodeContainer(DataNodeContainer input) {
            for (TypeDefinition typedef : input.getTypeDefinitions()) {
                this.emitTypedefNode(typedef);
            }
            for (GroupingDefinition grouping : input.getGroupings()) {
                this.emitGrouping(grouping);
            }
            for (DataSchemaNode child : input.getChildNodes()) {
                this.emitDataSchemaNode(child);
            }
            for (UsesNode usesNode : input.getUses()) {
                this.emitUsesNode(usesNode);
            }
        }

        private void emitDataSchemaNode(DataSchemaNode child) {
            if (!this.emitInstantiated && (child.isAddedByUses() || child.isAugmenting())) {
                return;
            }
            if (child instanceof ContainerSchemaNode) {
                this.emitContainer((ContainerSchemaNode)child);
            } else if (child instanceof LeafSchemaNode) {
                this.emitLeaf((LeafSchemaNode)child);
            } else if (child instanceof LeafListSchemaNode) {
                this.emitLeafList((LeafListSchemaNode)child);
            } else if (child instanceof ListSchemaNode) {
                this.emitList((ListSchemaNode)child);
            } else if (child instanceof ChoiceSchemaNode) {
                this.emitChoice((ChoiceSchemaNode)child);
            } else if (child instanceof AnyXmlSchemaNode) {
                this.emitAnyxml((AnyXmlSchemaNode)child);
            } else if (child instanceof AnyDataSchemaNode) {
                this.emitAnydata((AnyDataSchemaNode)child);
            } else {
                throw new UnsupportedOperationException("Not supported DataSchemaNode type " + child.getClass());
            }
        }

        private void emitYangVersionNode(YangVersion input) {
            this.writer.startYangVersionNode(input.toString());
            this.writer.endNode();
        }

        private void emitImport(ModuleImport importNode) {
            this.writer.startImportNode(importNode.getModuleName());
            this.emitDocumentedNode((DocumentedNode)importNode);
            this.emitPrefixNode(importNode.getPrefix());
            importNode.getRevision().ifPresent(this::emitRevisionDateNode);
            this.writer.endNode();
        }

        private void emitInclude(String input) {
        }

        private void emitNamespace(URI uri) {
            this.writer.startNamespaceNode(uri);
            this.writer.endNode();
        }

        private void emitPrefixNode(String input) {
            this.writer.startPrefixNode(input);
            this.writer.endNode();
        }

        private void emitBelongsTo(String input) {
        }

        private void emitOrganizationNode(String input) {
            this.writer.startOrganizationNode(input);
            this.writer.endNode();
        }

        private void emitContact(String input) {
            this.writer.startContactNode(input);
            this.writer.endNode();
        }

        private void emitDescriptionNode(String input) {
            this.writer.startDescriptionNode(input);
            this.writer.endNode();
        }

        private void emitReferenceNode(String input) {
            this.writer.startReferenceNode(input);
            this.writer.endNode();
        }

        private void emitUnitsNode(@Nullable String input) {
            this.writer.startUnitsNode(input);
            this.writer.endNode();
        }

        private void emitRevision(Revision date) {
            if (date != null) {
                this.writer.startRevisionNode(date);
                this.writer.endNode();
            }
        }

        private void emitRevisionDateNode(Revision date) {
            this.writer.startRevisionDateNode(date);
            this.writer.endNode();
        }

        private void emitExtension(ExtensionDefinition extension) {
            this.writer.startExtensionNode(extension.getQName());
            this.emitArgument(extension.getArgument(), extension.isYinElement());
            this.emitDocumentedNode((DocumentedNode.WithStatus)extension);
            this.emitUnknownStatementNodes(extension.getUnknownSchemaNodes());
            this.writer.endNode();
        }

        private void emitArgument(@Nullable String input, boolean yinElement) {
            if (input != null) {
                this.writer.startArgumentNode(input);
                this.emitYinElement(yinElement);
                this.writer.endNode();
            }
        }

        private void emitYinElement(boolean yinElement) {
            this.writer.startYinElementNode(yinElement);
            this.writer.endNode();
        }

        private void emitIdentity(IdentitySchemaNode identity) {
            this.writer.startIdentityNode(identity.getQName());
            this.emitBaseIdentities(identity.getBaseIdentities());
            this.emitDocumentedNode((DocumentedNode.WithStatus)identity);
            this.writer.endNode();
        }

        private void emitBaseIdentities(Set<IdentitySchemaNode> identities) {
            for (IdentitySchemaNode identitySchemaNode : identities) {
                this.emitBase(identitySchemaNode.getQName());
            }
        }

        private void emitBase(QName qname) {
            this.writer.startBaseNode(qname);
            this.writer.endNode();
        }

        private void emitFeature(FeatureDefinition definition) {
            this.writer.startFeatureNode(definition.getQName());
            this.emitDocumentedNode((DocumentedNode.WithStatus)definition);
            this.writer.endNode();
        }

        private void emitIfFeature(String input) {
        }

        private void emitTypedefNode(TypeDefinition<?> typedef) {
            this.writer.startTypedefNode(typedef.getQName());
            this.emitTypeNodeDerived(typedef);
            typedef.getUnits().ifPresent(this::emitUnitsNode);
            typedef.getDefaultValue().ifPresent(this::emitDefaultNode);
            this.emitDocumentedNode((DocumentedNode.WithStatus)typedef);
            this.emitUnknownStatementNodes(typedef.getUnknownSchemaNodes());
            this.writer.endNode();
        }

        private void emitTypeNode(SchemaPath parentPath, TypeDefinition<?> subtype) {
            SchemaPath path = subtype.getPath();
            if (EffectiveSchemaContextEmitter.isPrefix(parentPath.getPathFromRoot(), path.getPathFromRoot())) {
                this.emitTypeNodeDerived(subtype);
            } else {
                this.emitTypeNodeReferenced(subtype);
            }
        }

        private void emitTypeNodeReferenced(TypeDefinition<?> typeDefinition) {
            this.writer.startTypeNode(typeDefinition.getQName());
            this.writer.endNode();
        }

        private void emitTypeNodeDerived(TypeDefinition<?> typeDefinition) {
            TypeDefinition b = typeDefinition.getBaseType();
            TypeDefinition baseType = b == null ? typeDefinition : b;
            this.writer.startTypeNode(baseType.getQName());
            this.emitTypeBodyNodes(typeDefinition);
            this.writer.endNode();
        }

        private void emitTypeBodyNodes(TypeDefinition<?> typeDef) {
            if (typeDef instanceof DecimalTypeDefinition) {
                this.emitDecimal64Specification((DecimalTypeDefinition)typeDef);
            } else if (typeDef instanceof RangeRestrictedTypeDefinition) {
                this.emitRangeRestrictedSpecification((RangeRestrictedTypeDefinition)typeDef);
            } else if (typeDef instanceof StringTypeDefinition) {
                this.emitStringRestrictions((StringTypeDefinition)typeDef);
            } else if (typeDef instanceof EnumTypeDefinition) {
                this.emitEnumSpecification((EnumTypeDefinition)typeDef);
            } else if (typeDef instanceof LeafrefTypeDefinition) {
                this.emitLeafrefSpecification((LeafrefTypeDefinition)typeDef);
            } else if (typeDef instanceof IdentityrefTypeDefinition) {
                this.emitIdentityrefSpecification((IdentityrefTypeDefinition)typeDef);
            } else if (typeDef instanceof InstanceIdentifierTypeDefinition) {
                this.emitInstanceIdentifierSpecification((InstanceIdentifierTypeDefinition)typeDef);
            } else if (typeDef instanceof BitsTypeDefinition) {
                this.emitBitsSpecification((BitsTypeDefinition)typeDef);
            } else if (typeDef instanceof UnionTypeDefinition) {
                this.emitUnionSpecification((UnionTypeDefinition)typeDef);
            } else if (typeDef instanceof BinaryTypeDefinition) {
                ((BinaryTypeDefinition)typeDef).getLengthConstraint().ifPresent(this::emitLength);
            } else if (!(typeDef instanceof BooleanTypeDefinition) && !(typeDef instanceof EmptyTypeDefinition)) {
                throw new IllegalArgumentException("Not supported type " + typeDef.getClass());
            }
        }

        private void emitRangeRestrictedSpecification(RangeRestrictedTypeDefinition<?, ?> typeDef) {
            typeDef.getRangeConstraint().ifPresent(this::emitRangeNode);
        }

        private void emitRangeNode(RangeConstraint<?> constraint) {
            this.writer.startRangeNode(EffectiveSchemaContextEmitter.toRangeString(constraint.getAllowedRanges()));
            constraint.getErrorMessage().ifPresent(this::emitErrorMessageNode);
            constraint.getErrorAppTag().ifPresent(this::emitErrorAppTagNode);
            this.emitDocumentedNode((DocumentedNode)constraint);
            this.writer.endNode();
        }

        private void emitDecimal64Specification(DecimalTypeDefinition typeDefinition) {
            this.emitFranctionDigitsNode(typeDefinition.getFractionDigits());
            this.emitRangeRestrictedSpecification((RangeRestrictedTypeDefinition<?, ?>)typeDefinition);
        }

        private void emitFranctionDigitsNode(Integer fractionDigits) {
            this.writer.startFractionDigitsNode(fractionDigits);
            this.writer.endNode();
        }

        private void emitStringRestrictions(StringTypeDefinition typeDef) {
            typeDef.getLengthConstraint().ifPresent(this::emitLength);
            for (PatternConstraint pattern : typeDef.getPatternConstraints()) {
                this.emitPatternNode(pattern);
            }
        }

        private void emitLength(LengthConstraint constraint) {
            this.writer.startLengthNode(EffectiveSchemaContextEmitter.toLengthString((RangeSet<Integer>)constraint.getAllowedRanges()));
            constraint.getErrorMessage().ifPresent(this::emitErrorMessageNode);
            constraint.getErrorAppTag().ifPresent(this::emitErrorAppTagNode);
            this.emitDocumentedNode((DocumentedNode)constraint);
            this.writer.endNode();
        }

        private static String toLengthString(RangeSet<Integer> ranges) {
            boolean haveNext;
            Iterator it = ranges.asRanges().iterator();
            if (!it.hasNext()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            do {
                Range current = (Range)it.next();
                haveNext = it.hasNext();
                EffectiveSchemaContextEmitter.appendRange(sb, current.lowerEndpoint(), current.upperEndpoint(), haveNext);
            } while (haveNext);
            return sb.toString();
        }

        private static String toRangeString(RangeSet<?> ranges) {
            boolean haveNext;
            Iterator it = ranges.asRanges().iterator();
            if (!it.hasNext()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            do {
                Range current = (Range)it.next();
                haveNext = it.hasNext();
                EffectiveSchemaContextEmitter.appendRange(sb, current.lowerEndpoint(), current.upperEndpoint(), haveNext);
            } while (haveNext);
            return sb.toString();
        }

        private static void appendRange(StringBuilder sb, Object min, Object max, boolean haveNext) {
            sb.append(min);
            if (!min.equals(max)) {
                sb.append("..");
                sb.append(max);
            }
            if (haveNext) {
                sb.append('|');
            }
        }

        private void emitPatternNode(PatternConstraint pattern) {
            this.writer.startPatternNode(pattern.getRegularExpressionString());
            pattern.getErrorMessage().ifPresent(this::emitErrorMessageNode);
            pattern.getErrorAppTag().ifPresent(this::emitErrorAppTagNode);
            this.emitDocumentedNode((DocumentedNode)pattern);
            pattern.getModifier().ifPresent(this::emitModifier);
            this.writer.endNode();
        }

        private void emitModifier(ModifierKind modifier) {
            this.writer.startModifierNode(modifier);
            this.writer.endNode();
        }

        private void emitDefaultNodes(Collection<? extends Object> defaults) {
            for (Object object : defaults) {
                this.emitDefaultNode(object);
            }
        }

        private void emitDefaultNode(@Nullable Object object) {
            this.writer.startDefaultNode(object.toString());
            this.writer.endNode();
        }

        private void emitEnumSpecification(EnumTypeDefinition typeDefinition) {
            for (EnumTypeDefinition.EnumPair enumValue : typeDefinition.getValues()) {
                this.emitEnumNode(enumValue);
            }
        }

        private void emitEnumNode(EnumTypeDefinition.EnumPair enumValue) {
            this.writer.startEnumNode(enumValue.getName());
            this.emitValueNode(enumValue.getValue());
            this.emitDocumentedNode((DocumentedNode.WithStatus)enumValue);
            this.writer.endNode();
        }

        private void emitLeafrefSpecification(LeafrefTypeDefinition typeDefinition) {
            this.emitPathNode(typeDefinition.getPathStatement());
            if (YangVersion.VERSION_1_1 == this.yangVersion) {
                this.emitRequireInstanceNode(typeDefinition.requireInstance());
            }
        }

        private void emitPathNode(RevisionAwareXPath revisionAwareXPath) {
            this.writer.startPathNode(revisionAwareXPath);
            this.writer.endNode();
        }

        private void emitRequireInstanceNode(boolean require) {
            this.writer.startRequireInstanceNode(require);
            this.writer.endNode();
        }

        private void emitInstanceIdentifierSpecification(InstanceIdentifierTypeDefinition typeDefinition) {
            this.emitRequireInstanceNode(typeDefinition.requireInstance());
        }

        private void emitIdentityrefSpecification(IdentityrefTypeDefinition typeDefinition) {
            this.emitBaseIdentities(typeDefinition.getIdentities());
        }

        private void emitUnionSpecification(UnionTypeDefinition typeDefinition) {
            for (TypeDefinition subtype : typeDefinition.getTypes()) {
                this.emitTypeNode(typeDefinition.getPath(), subtype);
            }
        }

        private void emitBitsSpecification(BitsTypeDefinition typeDefinition) {
            for (BitsTypeDefinition.Bit bit : typeDefinition.getBits()) {
                this.emitBit(bit);
            }
        }

        private void emitBit(BitsTypeDefinition.Bit bit) {
            this.writer.startBitNode(bit.getName());
            this.emitPositionNode(bit.getPosition());
            this.emitDocumentedNode((DocumentedNode.WithStatus)bit);
            this.writer.endNode();
        }

        private void emitPositionNode(@Nullable Long position) {
            if (position != null) {
                this.writer.startPositionNode(UnsignedInteger.valueOf((long)position));
                this.writer.endNode();
            }
        }

        private void emitStatusNode(@Nullable Status status) {
            if (status != null) {
                this.writer.startStatusNode(status);
                this.writer.endNode();
            }
        }

        private void emitConfigNode(boolean config) {
            this.writer.startConfigNode(config);
            this.writer.endNode();
        }

        private void emitMandatoryNode(boolean mandatory) {
            this.writer.startMandatoryNode(mandatory);
            this.writer.endNode();
        }

        private void emitPresenceNode(boolean presence) {
            this.writer.startPresenceNode(presence);
            this.writer.endNode();
        }

        private void emitOrderedBy(boolean userOrdered) {
            if (userOrdered) {
                this.writer.startOrderedByNode("user");
            } else {
                this.writer.startOrderedByNode("system");
            }
            this.writer.endNode();
        }

        private void emitMust(@Nullable MustDefinition mustCondition) {
            if (mustCondition != null && mustCondition.getXpath() != null) {
                this.writer.startMustNode(mustCondition.getXpath());
                mustCondition.getErrorMessage().ifPresent(this::emitErrorMessageNode);
                mustCondition.getErrorAppTag().ifPresent(this::emitErrorAppTagNode);
                this.emitDocumentedNode((DocumentedNode)mustCondition);
                this.writer.endNode();
            }
        }

        private void emitErrorMessageNode(@Nullable String input) {
            this.writer.startErrorMessageNode(input);
            this.writer.endNode();
        }

        private void emitErrorAppTagNode(String input) {
            this.writer.startErrorAppTagNode(input);
            this.writer.endNode();
        }

        private void emitMinElementsNode(Integer min) {
            if (min != null) {
                this.writer.startMinElementsNode(min);
                this.writer.endNode();
            }
        }

        private void emitMaxElementsNode(@Nullable Integer max) {
            if (max != null) {
                this.writer.startMaxElementsNode(max);
                this.writer.endNode();
            }
        }

        private void emitValueNode(@Nullable Integer value) {
            if (value != null) {
                this.writer.startValueNode(value);
                this.writer.endNode();
            }
        }

        private void emitDocumentedNode(DocumentedNode input) {
            input.getDescription().ifPresent(this::emitDescriptionNode);
            input.getReference().ifPresent(this::emitReferenceNode);
        }

        private void emitDocumentedNode(DocumentedNode.WithStatus input) {
            this.emitStatusNode(input.getStatus());
            this.emitDocumentedNode((DocumentedNode)input);
        }

        private void emitGrouping(GroupingDefinition grouping) {
            this.writer.startGroupingNode(grouping.getQName());
            this.emitDocumentedNode((DocumentedNode.WithStatus)grouping);
            this.emitDataNodeContainer((DataNodeContainer)grouping);
            this.emitUnknownStatementNodes(grouping.getUnknownSchemaNodes());
            this.emitNotifications(grouping.getNotifications());
            this.emitActions(grouping.getActions());
            this.writer.endNode();
        }

        private void emitContainer(ContainerSchemaNode child) {
            this.writer.startContainerNode(child.getQName());
            child.getMustConstraints().forEach(this::emitMust);
            child.getWhenCondition().ifPresent(this::emitWhen);
            this.emitPresenceNode(child.isPresenceContainer());
            this.emitConfigNode(child.isConfiguration());
            this.emitDocumentedNode((DocumentedNode.WithStatus)child);
            this.emitDataNodeContainer((DataNodeContainer)child);
            this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
            this.emitNotifications(child.getNotifications());
            this.emitActions(child.getActions());
            this.writer.endNode();
        }

        private void emitLeaf(LeafSchemaNode child) {
            this.writer.startLeafNode(child.getQName());
            child.getWhenCondition().ifPresent(this::emitWhen);
            this.emitTypeNode(child.getPath(), child.getType());
            child.getType().getUnits().ifPresent(this::emitUnitsNode);
            child.getMustConstraints().forEach(this::emitMust);
            child.getType().getDefaultValue().ifPresent(this::emitDefaultNode);
            this.emitConfigNode(child.isConfiguration());
            this.emitMandatoryNode(child.isMandatory());
            this.emitDocumentedNode((DocumentedNode.WithStatus)child);
            this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
            this.writer.endNode();
        }

        private void emitCountConstraint(ElementCountConstraint constraint) {
            this.emitMinElementsNode(constraint.getMinElements());
            this.emitMaxElementsNode(constraint.getMaxElements());
        }

        private void emitLeafList(LeafListSchemaNode child) {
            this.writer.startLeafListNode(child.getQName());
            child.getWhenCondition().ifPresent(this::emitWhen);
            this.emitTypeNode(child.getPath(), child.getType());
            child.getType().getUnits().ifPresent(this::emitUnitsNode);
            child.getMustConstraints().forEach(this::emitMust);
            this.emitConfigNode(child.isConfiguration());
            this.emitDefaultNodes(child.getDefaults());
            child.getElementCountConstraint().ifPresent(this::emitCountConstraint);
            this.emitOrderedBy(child.isUserOrdered());
            this.emitDocumentedNode((DocumentedNode.WithStatus)child);
            this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
            this.writer.endNode();
        }

        private void emitList(ListSchemaNode child) {
            this.writer.startListNode(child.getQName());
            child.getWhenCondition().ifPresent(this::emitWhen);
            child.getMustConstraints().forEach(this::emitMust);
            this.emitKey(child.getKeyDefinition());
            this.emitUniqueConstraints(child.getUniqueConstraints());
            this.emitConfigNode(child.isConfiguration());
            child.getElementCountConstraint().ifPresent(this::emitCountConstraint);
            this.emitOrderedBy(child.isUserOrdered());
            this.emitDocumentedNode((DocumentedNode.WithStatus)child);
            this.emitDataNodeContainer((DataNodeContainer)child);
            this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
            this.emitNotifications(child.getNotifications());
            this.emitActions(child.getActions());
            this.writer.endNode();
        }

        private void emitKey(List<QName> keyList) {
            if (keyList != null && !keyList.isEmpty()) {
                this.writer.startKeyNode(keyList);
                this.writer.endNode();
            }
        }

        private void emitUniqueConstraints(Collection<UniqueConstraint> uniqueConstraints) {
            for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
                this.emitUnique(uniqueConstraint);
            }
        }

        private void emitUnique(UniqueConstraint uniqueConstraint) {
            this.writer.startUniqueNode(uniqueConstraint);
            this.writer.endNode();
        }

        private void emitChoice(ChoiceSchemaNode choice) {
            this.writer.startChoiceNode(choice.getQName());
            choice.getWhenCondition().ifPresent(this::emitWhen);
            this.emitConfigNode(choice.isConfiguration());
            this.emitMandatoryNode(choice.isMandatory());
            this.emitDocumentedNode((DocumentedNode.WithStatus)choice);
            for (CaseSchemaNode caze : choice.getCases().values()) {
                this.emitCaseNode(caze);
            }
            this.emitUnknownStatementNodes(choice.getUnknownSchemaNodes());
            this.writer.endNode();
        }

        private void emitCaseNode(CaseSchemaNode caze) {
            if (!this.emitInstantiated && caze.isAugmenting()) {
                return;
            }
            this.writer.startCaseNode(caze.getQName());
            caze.getWhenCondition().ifPresent(this::emitWhen);
            this.emitDocumentedNode((DocumentedNode.WithStatus)caze);
            this.emitDataNodeContainer((DataNodeContainer)caze);
            this.emitUnknownStatementNodes(caze.getUnknownSchemaNodes());
            this.writer.endNode();
        }

        private void emitAnyxml(AnyXmlSchemaNode anyxml) {
            this.writer.startAnyxmlNode(anyxml.getQName());
            this.emitBodyOfDataSchemaNode((DataSchemaNode)anyxml);
            this.writer.endNode();
        }

        private void emitAnydata(AnyDataSchemaNode anydata) {
            this.writer.startAnydataNode(anydata.getQName());
            this.emitBodyOfDataSchemaNode((DataSchemaNode)anydata);
            this.writer.endNode();
        }

        private void emitBodyOfDataSchemaNode(DataSchemaNode dataSchemaNode) {
            dataSchemaNode.getWhenCondition().ifPresent(this::emitWhen);
            if (dataSchemaNode instanceof MustConstraintAware) {
                ((MustConstraintAware)dataSchemaNode).getMustConstraints().forEach(this::emitMust);
            }
            this.emitConfigNode(dataSchemaNode.isConfiguration());
            this.emitDocumentedNode((DocumentedNode.WithStatus)dataSchemaNode);
            this.emitUnknownStatementNodes(dataSchemaNode.getUnknownSchemaNodes());
        }

        private void emitUsesNode(UsesNode usesNode) {
            if (this.emitUses && !usesNode.isAddedByUses() && !usesNode.isAugmenting()) {
                this.writer.startUsesNode(usesNode.getGroupingPath().getLastComponent());
                for (Map.Entry<SchemaPath, SchemaNode> entry : usesNode.getRefines().entrySet()) {
                    this.emitRefine(entry);
                }
                for (AugmentationSchemaNode augmentationSchemaNode : usesNode.getAugmentations()) {
                    this.emitUsesAugmentNode(augmentationSchemaNode);
                }
                this.writer.endNode();
            }
        }

        private void emitRefine(Map.Entry<SchemaPath, SchemaNode> refine) {
            SchemaPath path = refine.getKey();
            SchemaNode value = refine.getValue();
            this.writer.startRefineNode(path);
            if (value instanceof LeafSchemaNode) {
                this.emitRefineLeafNodes((LeafSchemaNode)value);
            } else if (value instanceof LeafListSchemaNode) {
                this.emitRefineLeafListNodes((LeafListSchemaNode)value);
            } else if (value instanceof ListSchemaNode) {
                this.emitRefineListNodes((ListSchemaNode)value);
            } else if (value instanceof ChoiceSchemaNode) {
                this.emitRefineChoiceNodes((ChoiceSchemaNode)value);
            } else if (value instanceof CaseSchemaNode) {
                this.emitRefineCaseNodes((CaseSchemaNode)value);
            } else if (value instanceof ContainerSchemaNode) {
                this.emitRefineContainerNodes((ContainerSchemaNode)value);
            } else if (value instanceof AnyXmlSchemaNode) {
                this.emitRefineAnyxmlNodes((AnyXmlSchemaNode)value);
            }
            this.writer.endNode();
        }

        private static <T extends SchemaNode> T getOriginalChecked(T value) {
            Optional original = SchemaNodeUtils.getOriginalIfPossible(value);
            Preconditions.checkArgument((boolean)original.isPresent(), (Object)"Original unmodified version of node is not present.");
            SchemaNode ret = (SchemaNode)original.get();
            return (T)ret;
        }

        private void emitDocumentedNodeRefine(DocumentedNode original, DocumentedNode value) {
            if (Objects.deepEquals(original.getDescription(), value.getDescription())) {
                value.getDescription().ifPresent(this::emitDescriptionNode);
            }
            if (Objects.deepEquals(original.getReference(), value.getReference())) {
                value.getReference().ifPresent(this::emitReferenceNode);
            }
        }

        private void emitRefineContainerNodes(ContainerSchemaNode value) {
            ContainerSchemaNode original = EffectiveSchemaContextEmitter.getOriginalChecked(value);
            if (Objects.deepEquals(original.isPresenceContainer(), value.isPresenceContainer())) {
                this.emitPresenceNode(value.isPresenceContainer());
            }
            if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
                this.emitConfigNode(value.isConfiguration());
            }
            this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
        }

        private void emitRefineLeafNodes(LeafSchemaNode value) {
            LeafSchemaNode original = EffectiveSchemaContextEmitter.getOriginalChecked(value);
            if (Objects.deepEquals(original.getType().getDefaultValue(), value.getType().getDefaultValue())) {
                this.emitDefaultNode(value.getType().getDefaultValue());
            }
            if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
                this.emitConfigNode(value.isConfiguration());
            }
            this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
            if (Objects.deepEquals(original.isMandatory(), value.isMandatory())) {
                this.emitMandatoryNode(value.isMandatory());
            }
        }

        private void emitRefinedMinMaxNodes(Optional<ElementCountConstraint> value, Optional<ElementCountConstraint> original) {
            Integer orig;
            Integer val = value.map(ElementCountConstraint::getMinElements).orElse(null);
            if (Objects.equals(val, orig = (Integer)original.map(ElementCountConstraint::getMinElements).orElse(null))) {
                this.emitMinElementsNode(val);
            }
            if (Objects.equals(val = (Integer)value.map(ElementCountConstraint::getMinElements).orElse(null), orig = (Integer)original.map(ElementCountConstraint::getMinElements).orElse(null))) {
                this.emitMaxElementsNode(val);
            }
        }

        private void emitRefineLeafListNodes(LeafListSchemaNode value) {
            LeafListSchemaNode original = EffectiveSchemaContextEmitter.getOriginalChecked(value);
            if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
                this.emitConfigNode(value.isConfiguration());
            }
            this.emitRefinedMinMaxNodes(value.getElementCountConstraint(), original.getElementCountConstraint());
            this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
        }

        private void emitRefineListNodes(ListSchemaNode value) {
            ListSchemaNode original = EffectiveSchemaContextEmitter.getOriginalChecked(value);
            if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
                this.emitConfigNode(value.isConfiguration());
            }
            this.emitRefinedMinMaxNodes(value.getElementCountConstraint(), original.getElementCountConstraint());
            this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
        }

        private void emitRefineChoiceNodes(ChoiceSchemaNode value) {
            ChoiceSchemaNode original = EffectiveSchemaContextEmitter.getOriginalChecked(value);
            if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
                this.emitConfigNode(value.isConfiguration());
            }
            if (Objects.deepEquals(original.isMandatory(), value.isMandatory())) {
                this.emitMandatoryNode(value.isMandatory());
            }
            this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
        }

        private void emitRefineCaseNodes(CaseSchemaNode value) {
            CaseSchemaNode original = EffectiveSchemaContextEmitter.getOriginalChecked(value);
            this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
        }

        private void emitRefineAnyxmlNodes(AnyXmlSchemaNode value) {
            AnyXmlSchemaNode original = EffectiveSchemaContextEmitter.getOriginalChecked(value);
            if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
                this.emitConfigNode(value.isConfiguration());
            }
            if (Objects.deepEquals(original.isMandatory(), value.isMandatory())) {
                this.emitMandatoryNode(value.isMandatory());
            }
            this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
        }

        private void emitUsesAugmentNode(AugmentationSchemaNode aug) {
            this.emitAugment(aug);
        }

        private void emitAugment(AugmentationSchemaNode augmentation) {
            this.writer.startAugmentNode(augmentation.getTargetPath());
            this.emitDocumentedNode((DocumentedNode.WithStatus)augmentation);
            for (UsesNode uses : augmentation.getUses()) {
                this.emitUsesNode(uses);
            }
            for (DataSchemaNode childNode : augmentation.getChildNodes()) {
                if (childNode instanceof CaseSchemaNode) {
                    this.emitCaseNode((CaseSchemaNode)childNode);
                    continue;
                }
                this.emitDataSchemaNode(childNode);
            }
            this.emitUnknownStatementNodes(augmentation.getUnknownSchemaNodes());
            this.emitNotifications(augmentation.getNotifications());
            this.emitActions(augmentation.getActions());
            this.writer.endNode();
        }

        private void emitUnknownStatementNodes(List<UnknownSchemaNode> unknownNodes) {
            for (UnknownSchemaNode unknonwnNode : unknownNodes) {
                if (unknonwnNode.isAddedByAugmentation() || unknonwnNode.isAddedByUses()) continue;
                this.emitUnknownStatementNode(unknonwnNode);
            }
        }

        private void emitUnknownStatementNode(UnknownSchemaNode node) {
            StatementDefinition def = this.getStatementChecked(node.getNodeType());
            if (def.getArgumentName() == null) {
                this.writer.startUnknownNode(def);
            } else {
                this.writer.startUnknownNode(def, node.getNodeParameter());
            }
            this.emitUnknownStatementNodes(node.getUnknownSchemaNodes());
            this.writer.endNode();
        }

        private StatementDefinition getStatementChecked(QName nodeType) {
            StatementDefinition ret = this.extensions.get(nodeType);
            Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"Unknown extension %s used during export.", (Object)nodeType);
            return ret;
        }

        private void emitWhen(RevisionAwareXPath revisionAwareXPath) {
            if (revisionAwareXPath != null) {
                this.writer.startWhenNode(revisionAwareXPath);
                this.writer.endNode();
            }
        }

        private void emitRpc(RpcDefinition rpc) {
            this.writer.startRpcNode(rpc.getQName());
            this.emitOperationBody((OperationDefinition)rpc);
            this.writer.endNode();
        }

        private void emitOperationBody(OperationDefinition rpc) {
            this.emitDocumentedNode((DocumentedNode.WithStatus)rpc);
            for (TypeDefinition typedef : rpc.getTypeDefinitions()) {
                this.emitTypedefNode(typedef);
            }
            for (GroupingDefinition grouping : rpc.getGroupings()) {
                this.emitGrouping(grouping);
            }
            this.emitInput(rpc.getInput());
            this.emitOutput(rpc.getOutput());
            this.emitUnknownStatementNodes(rpc.getUnknownSchemaNodes());
        }

        private void emitActions(Set<ActionDefinition> actions) {
            for (ActionDefinition actionDefinition : actions) {
                this.emitAction(actionDefinition);
            }
        }

        private void emitAction(ActionDefinition action) {
            if (!this.emitInstantiated && (action.isAddedByUses() || action.isAugmenting())) {
                return;
            }
            this.writer.startActionNode(action.getQName());
            this.emitOperationBody((OperationDefinition)action);
            this.writer.endNode();
        }

        private void emitInput(@NonNull ContainerSchemaNode input) {
            if (EffectiveSchemaContextEmitter.isExplicitStatement(input)) {
                this.writer.startInputNode();
                input.getMustConstraints().forEach(this::emitMust);
                this.emitDataNodeContainer((DataNodeContainer)input);
                this.emitUnknownStatementNodes(input.getUnknownSchemaNodes());
                this.writer.endNode();
            }
        }

        private void emitOutput(@NonNull ContainerSchemaNode output) {
            if (EffectiveSchemaContextEmitter.isExplicitStatement(output)) {
                this.writer.startOutputNode();
                output.getMustConstraints().forEach(this::emitMust);
                this.emitDataNodeContainer((DataNodeContainer)output);
                this.emitUnknownStatementNodes(output.getUnknownSchemaNodes());
                this.writer.endNode();
            }
        }

        private static boolean isExplicitStatement(ContainerSchemaNode node) {
            return node instanceof EffectiveStatement && ((EffectiveStatement)node).getDeclared().getStatementSource() == StatementSource.DECLARATION;
        }

        private void emitNotifications(Set<NotificationDefinition> notifications) {
            for (NotificationDefinition notification : notifications) {
                this.emitNotificationNode(notification);
            }
        }

        private void emitNotificationNode(NotificationDefinition notification) {
            if (!this.emitInstantiated && (notification.isAddedByUses() || notification.isAugmenting())) {
                return;
            }
            this.writer.startNotificationNode(notification.getQName());
            for (MustDefinition mustCondition : notification.getMustConstraints()) {
                this.emitMust(mustCondition);
            }
            this.emitDocumentedNode((DocumentedNode.WithStatus)notification);
            this.emitDataNodeContainer((DataNodeContainer)notification);
            this.emitUnknownStatementNodes(notification.getUnknownSchemaNodes());
            this.writer.endNode();
        }

        private void emitDeviation(Deviation deviation) {
        }
    }

    static class DeclaredSchemaContextEmitter
    extends SchemaContextEmitter {
        DeclaredSchemaContextEmitter(YangModuleWriter writer, Map<QName, StatementDefinition> extensions, YangVersion yangVersion) {
            super(writer, extensions, yangVersion);
        }

        void emitModule(DeclaredStatement<?> declaredRootStmt) {
            if (declaredRootStmt instanceof ModuleStatement) {
                this.emitModule((ModuleStatement)declaredRootStmt);
            } else if (declaredRootStmt instanceof SubmoduleStatement) {
                this.emitSubmodule((SubmoduleStatement)declaredRootStmt);
            } else {
                throw new UnsupportedOperationException(String.format("Yin export: unsupported declared statement %s", declaredRootStmt));
            }
        }

        private void emitModule(ModuleStatement module) {
            this.writer.startModuleNode(module.rawArgument());
            this.emitModuleHeader(module);
            this.emitLinkageNodes((LinkageGroup)module);
            this.emitMetaNodes((MetaGroup)module);
            this.emitRevisionNodes((RevisionGroup)module);
            this.emitBodyNodes((BodyGroup)module);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)module);
            this.writer.endNode();
        }

        private void emitModuleHeader(ModuleStatement input) {
            this.emitYangVersionNode(input.getYangVersion());
            this.emitNamespace(input.getNamespace());
            this.emitPrefixNode(input.getPrefix());
        }

        private void emitSubmodule(SubmoduleStatement submodule) {
            this.writer.startSubmoduleNode(submodule.rawArgument());
            this.emitSubmoduleHeaderNodes(submodule);
            this.emitLinkageNodes((LinkageGroup)submodule);
            this.emitMetaNodes((MetaGroup)submodule);
            this.emitRevisionNodes((RevisionGroup)submodule);
            this.emitBodyNodes((BodyGroup)submodule);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)submodule);
            this.writer.endNode();
        }

        private void emitSubmoduleHeaderNodes(SubmoduleStatement input) {
            this.emitYangVersionNode(input.getYangVersion());
            this.emitBelongsTo(input.getBelongsTo());
        }

        private void emitBelongsTo(BelongsToStatement belongsTo) {
            this.writer.startBelongsToNode(belongsTo.rawArgument());
            this.emitPrefixNode(belongsTo.getPrefix());
            this.writer.endNode();
        }

        private void emitMetaNodes(MetaGroup input) {
            this.emitOrganizationNode(input.getOrganization());
            this.emitContact(input.getContact());
            this.emitDescriptionNode(input.getDescription());
            this.emitReferenceNode(input.getReference());
        }

        private void emitLinkageNodes(LinkageGroup input) {
            for (ImportStatement importNode : input.getImports()) {
                this.emitImport(importNode);
            }
            for (ImportStatement importNode : input.getIncludes()) {
                this.emitInclude((IncludeStatement)importNode);
            }
        }

        private void emitRevisionNodes(RevisionGroup input) {
            this.emitRevisions(input.getRevisions());
        }

        private void emitBodyNodes(BodyGroup input) {
            for (org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement extension : input.getExtensions()) {
                this.emitExtension(extension);
            }
            for (FeatureStatement definition : input.getFeatures()) {
                this.emitFeature(definition);
            }
            for (IdentityStatement identity : input.getIdentities()) {
                this.emitIdentity(identity);
            }
            for (DeviationStatement deviation : input.getDeviations()) {
                this.emitDeviation(deviation);
            }
            this.emitDataNodeContainer((DataDefinitionContainer.WithReusableDefinitions)input);
            for (AugmentStatement augmentation : input.getAugments()) {
                this.emitAugment(augmentation);
            }
            for (RpcStatement rpc : input.getRpcs()) {
                this.emitRpc(rpc);
            }
            this.emitNotifications(input.getNotifications());
        }

        private void emitDataNodeContainer(DataDefinitionContainer input) {
            for (DataDefinitionStatement child : input.getDataDefinitions()) {
                this.emitDataSchemaNode(child);
            }
        }

        private void emitDataNodeContainer(DataDefinitionContainer.WithReusableDefinitions input) {
            for (TypedefStatement typedef : input.getTypedefs()) {
                this.emitTypedefNode(typedef);
            }
            for (GroupingStatement grouping : input.getGroupings()) {
                this.emitGrouping(grouping);
            }
            for (DataDefinitionStatement child : input.getDataDefinitions()) {
                this.emitDataSchemaNode(child);
            }
        }

        private void emitDataSchemaNode(DataDefinitionStatement child) {
            if (child instanceof ContainerStatement) {
                this.emitContainer((ContainerStatement)child);
            } else if (child instanceof LeafStatement) {
                this.emitLeaf((LeafStatement)child);
            } else if (child instanceof LeafListStatement) {
                this.emitLeafList((LeafListStatement)child);
            } else if (child instanceof ListStatement) {
                this.emitList((ListStatement)child);
            } else if (child instanceof ChoiceStatement) {
                this.emitChoice((ChoiceStatement)child);
            } else if (child instanceof AnyxmlStatement) {
                this.emitAnyxml((AnyxmlStatement)child);
            } else if (child instanceof AnydataStatement) {
                this.emitAnydata((AnydataStatement)child);
            } else if (child instanceof UsesStatement) {
                this.emitUsesNode((UsesStatement)child);
            } else {
                throw new UnsupportedOperationException("Not supported DataStatement type " + child.getClass());
            }
        }

        private void emitYangVersionNode(@Nullable YangVersionStatement yangVersionStatement) {
            if (yangVersionStatement != null) {
                this.writer.startYangVersionNode(yangVersionStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitImport(ImportStatement importNode) {
            this.writer.startImportNode(importNode.rawArgument());
            this.emitDocumentedNode((DocumentationGroup)importNode);
            this.emitPrefixNode(importNode.getPrefix());
            this.emitRevisionDateNode(importNode.getRevisionDate());
            this.writer.endNode();
        }

        private void emitInclude(IncludeStatement include) {
            this.writer.startIncludeNode(include.rawArgument());
            this.emitDocumentedNode((DocumentationGroup)include);
            this.emitRevisionDateNode(include.getRevisionDate());
            this.writer.endNode();
        }

        private void emitNamespace(NamespaceStatement namespaceStatement) {
            this.writer.startNamespaceNode(Objects.requireNonNull(namespaceStatement, "Namespace must not be null").getUri());
            this.writer.endNode();
        }

        private void emitPrefixNode(PrefixStatement prefixStatement) {
            this.writer.startPrefixNode(Objects.requireNonNull(prefixStatement, "Prefix must not be null").rawArgument());
            this.writer.endNode();
        }

        private void emitOrganizationNode(@Nullable OrganizationStatement organizationStatement) {
            if (organizationStatement != null) {
                this.writer.startOrganizationNode(organizationStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitContact(@Nullable ContactStatement contactStatement) {
            if (contactStatement != null) {
                this.writer.startContactNode(contactStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitDescriptionNode(@Nullable DescriptionStatement descriptionStatement) {
            if (descriptionStatement != null) {
                this.writer.startDescriptionNode(descriptionStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitReferenceNode(@Nullable ReferenceStatement referenceStatement) {
            if (referenceStatement != null) {
                this.writer.startReferenceNode(referenceStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitUnitsNode(@Nullable UnitsStatement unitsStatement) {
            if (unitsStatement != null) {
                this.writer.startUnitsNode(unitsStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitRevisions(Collection<? extends RevisionStatement> revisions) {
            for (RevisionStatement revisionStatement : revisions) {
                this.emitRevision(revisionStatement);
            }
        }

        private void emitRevision(RevisionStatement revision) {
            this.writer.startRevisionNode(revision.rawArgument());
            this.emitDocumentedNode((DocumentationGroup)revision);
            this.writer.endNode();
        }

        private void emitRevisionDateNode(@Nullable RevisionDateStatement revisionDateStatement) {
            if (revisionDateStatement != null) {
                this.writer.startRevisionDateNode(revisionDateStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitExtension(org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement extension) {
            this.writer.startExtensionNode(extension.rawArgument());
            this.emitArgument(extension.getArgument());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)extension);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)extension);
            this.writer.endNode();
        }

        private void emitArgument(@Nullable ArgumentStatement input) {
            if (input != null) {
                this.writer.startArgumentNode(input.rawArgument());
                this.emitYinElement(input.getYinElement());
                this.writer.endNode();
            }
        }

        private void emitYinElement(@Nullable YinElementStatement yinElementStatement) {
            if (yinElementStatement != null) {
                this.writer.startYinElementNode(yinElementStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitIdentity(IdentityStatement identity) {
            this.writer.startIdentityNode(identity.rawArgument());
            this.emitBaseIdentities(identity.getBases());
            this.emitStatusNode(identity.getStatus());
            this.emitDescriptionNode(identity.getDescription());
            this.emitReferenceNode(identity.getReference());
            this.writer.endNode();
        }

        private void emitBaseIdentities(Collection<? extends BaseStatement> collection) {
            for (BaseStatement baseStatement : collection) {
                this.emitBase(baseStatement);
            }
        }

        private void emitBase(BaseStatement baseStmt) {
            this.writer.startBaseNode(baseStmt.rawArgument());
            this.writer.endNode();
        }

        private void emitFeature(FeatureStatement feature) {
            this.writer.startFeatureNode(feature.rawArgument());
            this.emitIfFeatures(feature.getIfFeatures());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)feature);
            this.writer.endNode();
        }

        private void emitIfFeatures(Collection<? extends IfFeatureStatement> ifFeatures) {
            for (IfFeatureStatement ifFeatureStatement : ifFeatures) {
                this.emitIfFeature(ifFeatureStatement);
            }
        }

        private void emitIfFeature(IfFeatureStatement ifFeature) {
            this.writer.startIfFeatureNode(ifFeature.rawArgument());
            this.writer.endNode();
        }

        private void emitTypedefNode(TypedefStatement typedef) {
            this.writer.startTypedefNode(typedef.rawArgument());
            this.emitType(typedef.getType());
            this.emitUnitsNode(typedef.getUnits());
            this.emitDefaultNode(typedef.getDefault());
            this.emitStatusNode(typedef.getStatus());
            this.emitDescriptionNode(typedef.getDescription());
            this.emitReferenceNode(typedef.getReference());
            this.emitUnknownStatementNodes((DeclaredStatement<?>)typedef);
            this.writer.endNode();
        }

        private void emitType(TypeStatement typeStatement) {
            this.writer.startTypeNode(typeStatement.rawArgument());
            for (DeclaredStatement typeSubstmt : typeStatement.declaredSubstatements()) {
                if (typeSubstmt instanceof RangeStatement) {
                    this.emitRange((RangeStatement)typeSubstmt);
                    continue;
                }
                if (typeSubstmt instanceof LengthStatement) {
                    this.emitLength((LengthStatement)typeSubstmt);
                    continue;
                }
                if (typeSubstmt instanceof PatternStatement) {
                    this.emitPattern((PatternStatement)typeSubstmt);
                    continue;
                }
                if (typeSubstmt instanceof FractionDigitsStatement) {
                    this.emitFractionDigits((FractionDigitsStatement)typeSubstmt);
                    continue;
                }
                if (typeSubstmt instanceof EnumStatement) {
                    this.emitEnum((EnumStatement)typeSubstmt);
                    continue;
                }
                if (typeSubstmt instanceof PathStatement) {
                    this.emitPath((PathStatement)typeSubstmt);
                    continue;
                }
                if (typeSubstmt instanceof RequireInstanceStatement) {
                    this.emitRequireInstance((RequireInstanceStatement)typeSubstmt);
                    continue;
                }
                if (typeSubstmt instanceof BaseStatement) {
                    this.emitBase((BaseStatement)typeSubstmt);
                    continue;
                }
                if (typeSubstmt instanceof BitStatement) {
                    this.emitBit((BitStatement)typeSubstmt);
                    continue;
                }
                if (!(typeSubstmt instanceof TypeStatement)) continue;
                this.emitType((TypeStatement)typeSubstmt);
            }
            this.writer.endNode();
        }

        private void emitRange(RangeStatement range) {
            this.writer.startRangeNode(range.rawArgument());
            this.emitDocumentedConstraint((DocumentedConstraintGroup)range);
            this.writer.endNode();
        }

        private void emitFractionDigits(FractionDigitsStatement fractionDigits) {
            this.writer.startFractionDigitsNode(fractionDigits.rawArgument());
            this.writer.endNode();
        }

        private void emitLength(LengthStatement lengthStatement) {
            this.writer.startLengthNode(lengthStatement.rawArgument());
            this.emitDocumentedConstraint((DocumentedConstraintGroup)lengthStatement);
            this.writer.endNode();
        }

        private void emitPattern(PatternStatement pattern) {
            this.writer.startPatternNode(pattern.rawArgument());
            this.emitModifier(pattern.getModifierStatement());
            this.emitDocumentedConstraint((DocumentedConstraintGroup)pattern);
            this.writer.endNode();
        }

        private void emitModifier(ModifierStatement modifierStatement) {
            if (modifierStatement != null) {
                this.writer.startModifierNode(modifierStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitDefaultNodes(Collection<? extends DefaultStatement> collection) {
            for (DefaultStatement defaultStatement : collection) {
                this.emitDefaultNode(defaultStatement);
            }
        }

        private void emitDefaultNode(@Nullable DefaultStatement defaultStmt) {
            if (defaultStmt != null) {
                this.writer.startDefaultNode(defaultStmt.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitEnum(EnumStatement enumStmt) {
            this.writer.startEnumNode(enumStmt.rawArgument());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)enumStmt);
            this.emitValueNode(enumStmt.getValue());
            this.writer.endNode();
        }

        private void emitPath(PathStatement path) {
            this.writer.startPathNode(path.rawArgument());
            this.writer.endNode();
        }

        private void emitRequireInstance(RequireInstanceStatement require) {
            this.writer.startRequireInstanceNode(require.rawArgument());
            this.writer.endNode();
        }

        private void emitBit(BitStatement bit) {
            this.writer.startBitNode(bit.rawArgument());
            this.emitPositionNode(bit.getPosition());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)bit);
            this.writer.endNode();
        }

        private void emitPositionNode(@Nullable PositionStatement positionStatement) {
            if (positionStatement != null) {
                this.writer.startPositionNode(positionStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitStatusNode(@Nullable StatusStatement statusStatement) {
            if (statusStatement != null) {
                this.writer.startStatusNode(statusStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitConfigNode(@Nullable ConfigStatement configStatement) {
            if (configStatement != null) {
                this.writer.startConfigNode(configStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitMandatoryNode(@Nullable MandatoryStatement mandatoryStatement) {
            if (mandatoryStatement != null) {
                this.writer.startMandatoryNode(mandatoryStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitPresenceNode(@Nullable PresenceStatement presenceStatement) {
            if (presenceStatement != null) {
                this.writer.startPresenceNode(presenceStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitOrderedBy(@Nullable OrderedByStatement orderedByStatement) {
            if (orderedByStatement != null) {
                this.writer.startOrderedByNode(orderedByStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitMust(@Nullable MustStatement must) {
            if (must != null) {
                this.writer.startMustNode(must.rawArgument());
                this.emitErrorMessageNode(must.getErrorMessageStatement());
                this.emitErrorAppTagNode(must.getErrorAppTagStatement());
                this.emitDescriptionNode(must.getDescription());
                this.emitReferenceNode(must.getReference());
                this.writer.endNode();
            }
        }

        private void emitErrorMessageNode(@Nullable ErrorMessageStatement errorMessageStatement) {
            if (errorMessageStatement != null) {
                this.writer.startErrorMessageNode(errorMessageStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitErrorAppTagNode(@Nullable ErrorAppTagStatement errorAppTagStatement) {
            if (errorAppTagStatement != null) {
                this.writer.startErrorAppTagNode(errorAppTagStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitMinElementsNode(@Nullable MinElementsStatement minElementsStatement) {
            if (minElementsStatement != null) {
                this.writer.startMinElementsNode(minElementsStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitMaxElementsNode(@Nullable MaxElementsStatement maxElementsStatement) {
            if (maxElementsStatement != null) {
                this.writer.startMaxElementsNode(maxElementsStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitValueNode(@Nullable ValueStatement valueStatement) {
            if (valueStatement != null) {
                this.writer.startValueNode(valueStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitDocumentedNodeWithStatus(DocumentationGroup.WithStatus input) {
            this.emitStatusNode(input.getStatus());
            this.emitDocumentedNode((DocumentationGroup)input);
        }

        private void emitDocumentedNode(DocumentationGroup input) {
            this.emitDescriptionNode(input.getDescription());
            this.emitReferenceNode(input.getReference());
        }

        private void emitDocumentedConstraint(DocumentedConstraintGroup input) {
            this.emitDescriptionNode(input.getDescription());
            this.emitReferenceNode(input.getReference());
            this.emitErrorMessageNode(input.getErrorMessageStatement());
            this.emitErrorAppTagNode(input.getErrorAppTagStatement());
        }

        private void emitGrouping(GroupingStatement grouping) {
            this.writer.startGroupingNode(grouping.rawArgument());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)grouping);
            this.emitDataNodeContainer((DataDefinitionContainer.WithReusableDefinitions)grouping);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)grouping);
            this.emitNotifications(grouping.getNotifications());
            this.emitActions(grouping.getActions());
            this.writer.endNode();
        }

        private void emitContainer(ContainerStatement container) {
            this.writer.startContainerNode(container.rawArgument());
            this.emitWhen(container.getWhenStatement());
            this.emitMustNodes(container.getMusts());
            this.emitIfFeatures(container.getIfFeatures());
            this.emitPresenceNode(container.getPresence());
            this.emitConfigNode(container.getConfig());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)container);
            this.emitDataNodeContainer((DataDefinitionContainer.WithReusableDefinitions)container);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)container);
            this.emitNotifications(container.getNotifications());
            this.emitActions(container.getActions());
            this.writer.endNode();
        }

        private void emitLeaf(LeafStatement leaf) {
            this.writer.startLeafNode(leaf.rawArgument());
            this.emitWhen(leaf.getWhenStatement());
            this.emitIfFeatures(leaf.getIfFeatures());
            this.emitType(leaf.getType());
            this.emitUnitsNode(leaf.getUnits());
            this.emitMustNodes(leaf.getMusts());
            this.emitDefaultNode(leaf.getDefault());
            this.emitConfigNode(leaf.getConfig());
            this.emitMandatoryNode(leaf.getMandatory());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)leaf);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)leaf);
            this.writer.endNode();
        }

        private void emitLeafList(LeafListStatement leafList) {
            this.writer.startLeafListNode(leafList.rawArgument());
            this.emitWhen(leafList.getWhenStatement());
            this.emitIfFeatures(leafList.getIfFeatures());
            this.emitType(leafList.getType());
            this.emitUnitsNode(leafList.getUnits());
            this.emitMustNodes(leafList.getMusts());
            this.emitConfigNode(leafList.getConfig());
            this.emitDefaultNodes(leafList.getDefaults());
            this.emitMinElementsNode(leafList.getMinElements());
            this.emitMaxElementsNode(leafList.getMaxElements());
            this.emitOrderedBy(leafList.getOrderedBy());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)leafList);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)leafList);
            this.writer.endNode();
        }

        private void emitList(ListStatement list) {
            this.writer.startListNode(list.rawArgument());
            this.emitWhen(list.getWhenStatement());
            this.emitIfFeatures(list.getIfFeatures());
            this.emitMustNodes(list.getMusts());
            this.emitKey(list.getKey());
            this.emitUniqueConstraints(list.getUnique());
            this.emitConfigNode(list.getConfig());
            this.emitMinElementsNode(list.getMinElements());
            this.emitMaxElementsNode(list.getMaxElements());
            this.emitOrderedBy(list.getOrderedBy());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)list);
            this.emitDataNodeContainer((DataDefinitionContainer.WithReusableDefinitions)list);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)list);
            this.emitNotifications(list.getNotifications());
            this.emitActions(list.getActions());
            this.writer.endNode();
        }

        private void emitMustNodes(Collection<? extends MustStatement> collection) {
            for (MustStatement mustStatement : collection) {
                this.emitMust(mustStatement);
            }
        }

        private void emitKey(KeyStatement keyStatement) {
            if (keyStatement != null) {
                this.writer.startKeyNode(keyStatement.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitUniqueConstraints(Collection<? extends UniqueStatement> collection) {
            for (UniqueStatement uniqueStatement : collection) {
                this.emitUnique(uniqueStatement);
            }
        }

        private void emitUnique(UniqueStatement uniqueConstraint) {
            if (uniqueConstraint != null) {
                this.writer.startUniqueNode(uniqueConstraint.rawArgument());
                this.writer.endNode();
            }
        }

        private void emitChoice(ChoiceStatement choice) {
            this.writer.startChoiceNode(choice.rawArgument());
            this.emitWhen(choice.getWhenStatement());
            this.emitIfFeatures(choice.getIfFeatures());
            this.emitDefaultNode(choice.getDefault());
            this.emitConfigNode(choice.getConfig());
            this.emitMandatoryNode(choice.getMandatory());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)choice);
            this.emitCases(choice.getCases());
            this.emitUnknownStatementNodes((DeclaredStatement<?>)choice);
            this.writer.endNode();
        }

        private void emitShortCases(Collection<? extends DeclaredStatement<?>> declaredSubstatements) {
            for (DeclaredStatement<?> child : declaredSubstatements) {
                if (child instanceof ContainerStatement) {
                    this.emitContainer((ContainerStatement)child);
                    continue;
                }
                if (child instanceof LeafStatement) {
                    this.emitLeaf((LeafStatement)child);
                    continue;
                }
                if (child instanceof LeafListStatement) {
                    this.emitLeafList((LeafListStatement)child);
                    continue;
                }
                if (child instanceof ListStatement) {
                    this.emitList((ListStatement)child);
                    continue;
                }
                if (child instanceof ChoiceStatement) {
                    this.emitChoice((ChoiceStatement)child);
                    continue;
                }
                if (child instanceof AnyxmlStatement) {
                    this.emitAnyxml((AnyxmlStatement)child);
                    continue;
                }
                if (!(child instanceof AnydataStatement)) continue;
                this.emitAnydata((AnydataStatement)child);
            }
        }

        private void emitCases(Collection<? extends CaseStatement> cases) {
            for (CaseStatement caseStatement : cases) {
                if (DeclaredSchemaContextEmitter.isExplicitStatement(caseStatement)) {
                    this.emitCaseNode(caseStatement);
                    continue;
                }
                Collection shortCaseChilds = caseStatement.declaredSubstatements();
                Preconditions.checkState((shortCaseChilds.size() == 1 ? 1 : 0) != 0, (Object)"Only one child is allowed for each short case node");
                this.emitShortCases(shortCaseChilds);
            }
        }

        private void emitCaseNode(CaseStatement caze) {
            this.writer.startCaseNode(caze.rawArgument());
            this.emitWhen(caze.getWhenStatement());
            this.emitIfFeatures(caze.getIfFeatures());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)caze);
            this.emitDataNodeContainer((DataDefinitionContainer)caze);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)caze);
            this.writer.endNode();
        }

        private void emitAnyxml(AnyxmlStatement anyxml) {
            this.writer.startAnyxmlNode(anyxml.rawArgument());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)anyxml);
            this.emitWhen(anyxml.getWhenStatement());
            this.emitIfFeatures(anyxml.getIfFeatures());
            this.emitMustNodes(anyxml.getMusts());
            this.emitConfigNode(anyxml.getConfig());
            this.emitMandatoryNode(anyxml.getMandatory());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)anyxml);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)anyxml);
            this.writer.endNode();
        }

        private void emitAnydata(AnydataStatement anydata) {
            this.writer.startAnydataNode(anydata.rawArgument());
            this.emitWhen(anydata.getWhenStatement());
            this.emitIfFeatures(anydata.getIfFeatures());
            this.emitMustNodes(anydata.getMusts());
            this.emitConfigNode(anydata.getConfig());
            this.emitMandatoryNode(anydata.getMandatory());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)anydata);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)anydata);
            this.writer.endNode();
        }

        private void emitUsesNode(UsesStatement uses) {
            this.writer.startUsesNode(uses.rawArgument());
            this.emitWhen(uses.getWhenStatement());
            this.emitIfFeatures(uses.getIfFeatures());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)uses);
            for (RefineStatement refine : uses.getRefines()) {
                this.emitRefine(refine);
            }
            for (AugmentStatement aug : uses.getAugments()) {
                this.emitUsesAugmentNode(aug);
            }
            this.writer.endNode();
        }

        private void emitRefine(RefineStatement refine) {
            this.writer.startRefineNode(refine.rawArgument());
            this.emitDocumentedNode((DocumentationGroup)refine);
            this.emitIfFeatures(refine.getIfFeatures());
            this.emitMustNodes(refine.getMusts());
            this.emitPresenceNode(refine.getPresence());
            this.emitDefaultNodes(refine.getDefaults());
            this.emitConfigNode(refine.getConfig());
            this.emitMandatoryNode(refine.getMandatory());
            this.emitMinElementsNode(refine.getMinElements());
            this.emitMaxElementsNode(refine.getMaxElements());
            this.writer.endNode();
        }

        private void emitUsesAugmentNode(AugmentStatement aug) {
            this.emitAugment(aug);
        }

        private void emitAugment(AugmentStatement augmentation) {
            this.writer.startAugmentNode(augmentation.rawArgument());
            this.emitIfFeatures(augmentation.getIfFeatures());
            this.emitWhen(augmentation.getWhenStatement());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)augmentation);
            this.emitDataNodeContainer((DataDefinitionContainer)augmentation);
            this.emitCases(augmentation.getCases());
            this.emitUnknownStatementNodes((DeclaredStatement<?>)augmentation);
            this.emitNotifications(augmentation.getNotifications());
            this.emitActions(augmentation.getActions());
            this.writer.endNode();
        }

        private void emitUnknownStatementNodes(DeclaredStatement<?> declaredStmt) {
            declaredStmt.streamDeclaredSubstatements(UnknownStatement.class).forEach(this::emitUnknownStatementNode);
        }

        private void emitUnknownStatementNode(UnknownStatement<?> unknonwnStmt) {
            StatementDefinition def = unknonwnStmt.statementDefinition();
            if (def.getArgumentName() == null) {
                this.writer.startUnknownNode(def);
            } else {
                this.writer.startUnknownNode(def, unknonwnStmt.rawArgument());
            }
            this.emitUnknownStatementNodes((DeclaredStatement<?>)unknonwnStmt);
            this.writer.endNode();
        }

        private void emitWhen(WhenStatement whenStatement) {
            if (whenStatement != null) {
                this.writer.startWhenNode(whenStatement.rawArgument());
                this.emitDocumentedNode((DocumentationGroup)whenStatement);
                this.writer.endNode();
            }
        }

        private void emitRpc(RpcStatement rpc) {
            this.writer.startRpcNode(rpc.rawArgument());
            this.emitOperationBody((OperationGroup)rpc);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)rpc);
            this.writer.endNode();
        }

        private void emitOperationBody(OperationGroup operationStmt) {
            this.emitIfFeatures(operationStmt.getIfFeatures());
            this.emitStatusNode(operationStmt.getStatus());
            this.emitDescriptionNode(operationStmt.getDescription());
            this.emitReferenceNode(operationStmt.getReference());
            for (TypedefStatement typedef : operationStmt.getTypedefs()) {
                this.emitTypedefNode(typedef);
            }
            for (GroupingStatement grouping : operationStmt.getGroupings()) {
                this.emitGrouping(grouping);
            }
            this.emitInput(operationStmt.getInput());
            this.emitOutput(operationStmt.getOutput());
        }

        private void emitActions(Collection<? extends ActionStatement> collection) {
            for (ActionStatement actionStatement : collection) {
                this.emitAction(actionStatement);
            }
        }

        private void emitAction(ActionStatement actionDefinition) {
            this.writer.startActionNode(actionDefinition.rawArgument());
            this.emitOperationBody((OperationGroup)actionDefinition);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)actionDefinition);
            this.writer.endNode();
        }

        private void emitInput(InputStatement inputStatement) {
            if (DeclaredSchemaContextEmitter.isExplicitStatement(inputStatement)) {
                this.writer.startInputNode();
                this.emitMustNodes(inputStatement.getMusts());
                this.emitDataNodeContainer((DataDefinitionContainer.WithReusableDefinitions)inputStatement);
                this.emitUnknownStatementNodes((DeclaredStatement<?>)inputStatement);
                this.writer.endNode();
            }
        }

        private void emitOutput(OutputStatement output) {
            if (DeclaredSchemaContextEmitter.isExplicitStatement(output)) {
                this.writer.startOutputNode();
                this.emitMustNodes(output.getMusts());
                this.emitDataNodeContainer((DataDefinitionContainer.WithReusableDefinitions)output);
                this.emitUnknownStatementNodes((DeclaredStatement<?>)output);
                this.writer.endNode();
            }
        }

        private static boolean isExplicitStatement(DeclaredStatement<?> stmt) {
            return stmt != null && stmt.getStatementSource() == StatementSource.DECLARATION;
        }

        private void emitNotifications(Collection<? extends NotificationStatement> collection) {
            for (NotificationStatement notificationStatement : collection) {
                this.emitNotificationNode(notificationStatement);
            }
        }

        private void emitNotificationNode(NotificationStatement notification) {
            this.writer.startNotificationNode(notification.rawArgument());
            this.emitIfFeatures(notification.getIfFeatures());
            this.emitMustNodes(notification.getMusts());
            this.emitDocumentedNodeWithStatus((DocumentationGroup.WithStatus)notification);
            this.emitDataNodeContainer((DataDefinitionContainer.WithReusableDefinitions)notification);
            this.emitUnknownStatementNodes((DeclaredStatement<?>)notification);
            this.writer.endNode();
        }

        private void emitDeviation(DeviationStatement deviation) {
            this.writer.startDeviationNode(deviation.rawArgument());
            this.emitDeviateStatements(deviation.getDeviateStatements());
            this.emitUnknownStatementNodes((DeclaredStatement<?>)deviation);
            this.writer.endNode();
        }

        private void emitDeviateStatements(Collection<? extends DeviateStatement> deviateStatements) {
            for (DeviateStatement deviateStatement : deviateStatements) {
                this.emitDeviate(deviateStatement);
            }
        }

        private void emitDeviate(DeviateStatement deviateStatement) {
            this.writer.startDeviateNode(deviateStatement.rawArgument());
            for (DeclaredStatement child : deviateStatement.declaredSubstatements()) {
                if (child instanceof MustStatement) {
                    this.emitMust((MustStatement)child);
                    continue;
                }
                if (child instanceof DefaultStatement) {
                    this.emitDefaultNode((DefaultStatement)child);
                    continue;
                }
                if (child instanceof UniqueStatement) {
                    this.emitUnique((UniqueStatement)child);
                    continue;
                }
                if (child instanceof UnitsStatement) {
                    this.emitUnitsNode((UnitsStatement)child);
                    continue;
                }
                if (child instanceof TypeStatement) {
                    this.emitType((TypeStatement)child);
                    continue;
                }
                if (child instanceof MinElementsStatement) {
                    this.emitMinElementsNode((MinElementsStatement)child);
                    continue;
                }
                if (child instanceof MaxElementsStatement) {
                    this.emitMaxElementsNode((MaxElementsStatement)child);
                    continue;
                }
                if (child instanceof MandatoryStatement) {
                    this.emitMandatoryNode((MandatoryStatement)child);
                    continue;
                }
                if (child instanceof ConfigStatement) {
                    this.emitConfigNode((ConfigStatement)child);
                    continue;
                }
                if (!(child instanceof UnknownStatement)) continue;
                this.emitUnknownStatementNode((UnknownStatement)child);
            }
            this.writer.endNode();
        }
    }
}

