/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.export.ExportUtils;

final class ModuleNamespaceContext
implements NamespaceContext {
    private static final Map.Entry<String, String> YIN_PREFIX_AND_NAMESPACE = new AbstractMap.SimpleImmutableEntry<String, String>("", "urn:ietf:params:xml:ns:yang:yin:1");
    private final ListMultimap<@NonNull String, @NonNull String> namespaceToPrefix;
    private final Map<String, @NonNull ModuleEffectiveStatement> prefixToModule;
    private final Map<QNameModule, @NonNull String> moduleToPrefix;

    ModuleNamespaceContext(ModuleEffectiveStatement module) {
        this.prefixToModule = Objects.requireNonNull(module.getAll(ModuleEffectiveStatement.PrefixToEffectiveModuleNamespace.class));
        this.moduleToPrefix = Objects.requireNonNull(module.getAll(ModuleEffectiveStatement.QNameModuleToPrefixNamespace.class));
        ImmutableListMultimap.Builder namespaces = ImmutableListMultimap.builder();
        for (Map.Entry<QNameModule, String> e : this.moduleToPrefix.entrySet()) {
            namespaces.put((Object)e.getKey().getNamespace().toString(), (Object)e.getValue());
        }
        this.namespaceToPrefix = namespaces.build();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0);
        switch (prefix) {
            case "": {
                return "urn:ietf:params:xml:ns:yang:yin:1";
            }
            case "xml": {
                return "http://www.w3.org/XML/1998/namespace";
            }
            case "xmlns": {
                return "http://www.w3.org/2000/xmlns/";
            }
        }
        ModuleEffectiveStatement module = this.prefixToModule.get(prefix);
        return module != null ? module.localQNameModule().getNamespace().toString() : "";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public String getPrefix(String namespaceURI) {
        Preconditions.checkArgument((namespaceURI != null ? 1 : 0) != 0);
        switch (namespaceURI) {
            case "urn:ietf:params:xml:ns:yang:yin:1": {
                return "";
            }
            case "http://www.w3.org/XML/1998/namespace": {
                return "xml";
            }
            case "http://www.w3.org/2000/xmlns/": {
                return "xmlns";
            }
        }
        @NonNull List prefixes = this.namespaceToPrefix.get((Object)namespaceURI);
        return prefixes.isEmpty() ? null : (String)prefixes.get(0);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        Preconditions.checkArgument((namespaceURI != null ? 1 : 0) != 0);
        switch (namespaceURI) {
            case "urn:ietf:params:xml:ns:yang:yin:1": {
                return Iterators.singletonIterator((Object)"");
            }
            case "http://www.w3.org/XML/1998/namespace": {
                return Iterators.singletonIterator((Object)"xml");
            }
            case "http://www.w3.org/2000/xmlns/": {
                return Iterators.singletonIterator((Object)"xmlns");
            }
        }
        return this.namespaceToPrefix.get((Object)namespaceURI).iterator();
    }

    Map.Entry<String, String> prefixAndNamespaceFor(QNameModule module) {
        if (YangConstants.RFC6020_YIN_MODULE.equals((Object)module)) {
            return YIN_PREFIX_AND_NAMESPACE;
        }
        String prefix = this.moduleToPrefix.get(module);
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (String)"Module %s does not map to a prefix", (Object)module);
        return new AbstractMap.SimpleImmutableEntry<String, String>(prefix, module.getNamespace().toString());
    }

    Map.Entry<String, String> prefixAndNamespaceForStatement(QName stmtName) {
        Optional<String> prefix = ExportUtils.statementPrefix(this.moduleToPrefix, stmtName);
        if (!prefix.isPresent()) {
            return YIN_PREFIX_AND_NAMESPACE;
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(prefix.get(), stmtName.getNamespace().toString());
    }

    Map<String, String> prefixesAndNamespaces() {
        return Maps.transformValues(this.prefixToModule, module -> module.localQNameModule().getNamespace().toString());
    }
}

