/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangConstants;

final class ExportUtils {
    private ExportUtils() {
    }

    static Optional<String> statementPrefix(Map<QNameModule, String> namespaces, QName stmtName) {
        QNameModule namespace = stmtName.getModule();
        if (YangConstants.RFC6020_YIN_MODULE.equals((Object)namespace)) {
            return Optional.empty();
        }
        @Nullable String prefix = namespaces.get(namespace);
        if (prefix == null && !namespace.getRevision().isPresent()) {
            Map.Entry<QNameModule, String> match = null;
            for (Map.Entry<QNameModule, String> entry : namespaces.entrySet()) {
                QNameModule ns = entry.getKey();
                if (!namespace.equals((Object)ns.withoutRevision()) || match != null && Revision.compare((Optional)((QNameModule)match.getKey()).getRevision(), (Optional)ns.getRevision()) >= 0) continue;
                match = entry;
            }
            if (match != null) {
                prefix = (String)match.getValue();
            }
        }
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (String)"Failed to find prefix for statement %s", (Object)stmtName);
        Verify.verify((!prefix.isEmpty() ? 1 : 0) != 0, (String)"Empty prefix for statement %s", (Object)stmtName);
        return Optional.of(prefix);
    }
}

