/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.export.YangTextSnippet;

@Beta
@ThreadSafe
@NonNullByDefault
public final class DeclaredStatementFormatter
implements Immutable {
    private static final DeclaredStatementFormatter DEFAULT = new DeclaredStatementFormatter((Set<StatementDefinition>)ImmutableSet.of(), true);
    private final Set<StatementDefinition> ignoredStatements;
    private final boolean omitDefaultStatements;

    DeclaredStatementFormatter(Set<StatementDefinition> ignoredStatements, boolean omitDefaultStatements) {
        this.ignoredStatements = Objects.requireNonNull(ignoredStatements);
        this.omitDefaultStatements = omitDefaultStatements;
    }

    public YangTextSnippet toYangTextSnippet(ModuleEffectiveStatement module, DeclaredStatement<?> statement) {
        return new YangTextSnippet(statement, module.findAll(ModuleEffectiveStatement.QNameModuleToPrefixNamespace.class), this.ignoredStatements, this.omitDefaultStatements);
    }

    public static DeclaredStatementFormatter defaultInstance() {
        return DEFAULT;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Beta
    @NotThreadSafe
    public static final class Builder
    implements org.opendaylight.yangtools.concepts.Builder<DeclaredStatementFormatter> {
        private final Set<StatementDefinition> ignoredStatements = new HashSet<StatementDefinition>(4);
        private boolean retainDefaultStatements;

        Builder() {
        }

        public Builder addIgnoredStatement(StatementDefinition statementDef) {
            this.ignoredStatements.add(Objects.requireNonNull(statementDef));
            return this;
        }

        public Builder retainDefaultStatements() {
            this.retainDefaultStatements = true;
            return this;
        }

        public DeclaredStatementFormatter build() {
            return new DeclaredStatementFormatter((Set<StatementDefinition>)ImmutableSet.copyOf(this.ignoredStatements), !this.retainDefaultStatements);
        }
    }
}

