/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TrustKeystoreBuilder
implements Builder<TrustKeystore> {
    private String _name;
    private String _storePassword;
    Map<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>> augmentation = Collections.emptyMap();

    public TrustKeystoreBuilder() {
    }

    public TrustKeystoreBuilder(TrustKeystore base) {
        Map aug;
        this._name = base.getName();
        this._storePassword = base.getStorePassword();
        if (base instanceof TrustKeystoreImpl) {
            TrustKeystoreImpl impl = (TrustKeystoreImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>>(aug);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getStorePassword() {
        return this._storePassword;
    }

    public <E$$ extends Augmentation<TrustKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TrustKeystoreBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TrustKeystoreBuilder setStorePassword(String value) {
        this._storePassword = value;
        return this;
    }

    public TrustKeystoreBuilder addAugmentation(Class<? extends Augmentation<TrustKeystore>> augmentationType, Augmentation<TrustKeystore> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TrustKeystoreBuilder removeAugmentation(Class<? extends Augmentation<TrustKeystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TrustKeystore build() {
        return new TrustKeystoreImpl(this);
    }

    private static final class TrustKeystoreImpl
    implements TrustKeystore {
        private final String _name;
        private final String _storePassword;
        private Map<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TrustKeystoreImpl(TrustKeystoreBuilder base) {
            this._name = base.getName();
            this._storePassword = base.getStorePassword();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<TrustKeystore> getImplementedInterface() {
            return TrustKeystore.class;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getStorePassword() {
            return this._storePassword;
        }

        public <E$$ extends Augmentation<TrustKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._storePassword);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TrustKeystore.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TrustKeystore other = (TrustKeystore)obj;
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._storePassword, other.getStorePassword())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TrustKeystoreImpl otherImpl = (TrustKeystoreImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TrustKeystore");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_storePassword", (Object)this._storePassword);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

