/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.ssl.data.TrustKeystore;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TrustKeystoreBuilder
implements Builder<TrustKeystore> {
    private String _alias;
    private String _dname;
    private String _keyAlg;
    private Integer _keysize;
    private byte[] _keystoreFile;
    private String _name;
    private String _signAlg;
    private String _storePassword;
    private Integer _validity;
    Map<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>> augmentation = Collections.emptyMap();

    public TrustKeystoreBuilder() {
    }

    public TrustKeystoreBuilder(Keystore arg) {
        this._name = arg.getName();
        this._alias = arg.getAlias();
        this._storePassword = arg.getStorePassword();
        this._dname = arg.getDname();
        this._validity = arg.getValidity();
        this._keyAlg = arg.getKeyAlg();
        this._signAlg = arg.getSignAlg();
        this._keysize = arg.getKeysize();
        this._keystoreFile = arg.getKeystoreFile();
    }

    public TrustKeystoreBuilder(TrustKeystore base) {
        Map aug;
        this._alias = base.getAlias();
        this._dname = base.getDname();
        this._keyAlg = base.getKeyAlg();
        this._keysize = base.getKeysize();
        this._keystoreFile = base.getKeystoreFile();
        this._name = base.getName();
        this._signAlg = base.getSignAlg();
        this._storePassword = base.getStorePassword();
        this._validity = base.getValidity();
        if (base instanceof TrustKeystoreImpl) {
            TrustKeystoreImpl impl = (TrustKeystoreImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Keystore) {
            this._name = ((Keystore)arg).getName();
            this._alias = ((Keystore)arg).getAlias();
            this._storePassword = ((Keystore)arg).getStorePassword();
            this._dname = ((Keystore)arg).getDname();
            this._validity = ((Keystore)arg).getValidity();
            this._keyAlg = ((Keystore)arg).getKeyAlg();
            this._signAlg = ((Keystore)arg).getSignAlg();
            this._keysize = ((Keystore)arg).getKeysize();
            this._keystoreFile = ((Keystore)arg).getKeystoreFile();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.Keystore]");
    }

    public String getAlias() {
        return this._alias;
    }

    public String getDname() {
        return this._dname;
    }

    public String getKeyAlg() {
        return this._keyAlg;
    }

    public Integer getKeysize() {
        return this._keysize;
    }

    public byte[] getKeystoreFile() {
        return this._keystoreFile == null ? null : (byte[])this._keystoreFile.clone();
    }

    public String getName() {
        return this._name;
    }

    public String getSignAlg() {
        return this._signAlg;
    }

    public String getStorePassword() {
        return this._storePassword;
    }

    public Integer getValidity() {
        return this._validity;
    }

    public <E$$ extends Augmentation<TrustKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TrustKeystoreBuilder setAlias(String value) {
        this._alias = value;
        return this;
    }

    public TrustKeystoreBuilder setDname(String value) {
        this._dname = value;
        return this;
    }

    public TrustKeystoreBuilder setKeyAlg(String value) {
        this._keyAlg = value;
        return this;
    }

    public TrustKeystoreBuilder setKeysize(Integer value) {
        this._keysize = value;
        return this;
    }

    public TrustKeystoreBuilder setKeystoreFile(byte[] value) {
        this._keystoreFile = value;
        return this;
    }

    public TrustKeystoreBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TrustKeystoreBuilder setSignAlg(String value) {
        this._signAlg = value;
        return this;
    }

    public TrustKeystoreBuilder setStorePassword(String value) {
        this._storePassword = value;
        return this;
    }

    public TrustKeystoreBuilder setValidity(Integer value) {
        this._validity = value;
        return this;
    }

    public TrustKeystoreBuilder addAugmentation(Class<? extends Augmentation<TrustKeystore>> augmentationType, Augmentation<TrustKeystore> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TrustKeystoreBuilder removeAugmentation(Class<? extends Augmentation<TrustKeystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TrustKeystore build() {
        return new TrustKeystoreImpl(this);
    }

    private static final class TrustKeystoreImpl
    implements TrustKeystore {
        private final String _alias;
        private final String _dname;
        private final String _keyAlg;
        private final Integer _keysize;
        private final byte[] _keystoreFile;
        private final String _name;
        private final String _signAlg;
        private final String _storePassword;
        private final Integer _validity;
        private Map<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TrustKeystoreImpl(TrustKeystoreBuilder base) {
            this._alias = base.getAlias();
            this._dname = base.getDname();
            this._keyAlg = base.getKeyAlg();
            this._keysize = base.getKeysize();
            this._keystoreFile = base.getKeystoreFile();
            this._name = base.getName();
            this._signAlg = base.getSignAlg();
            this._storePassword = base.getStorePassword();
            this._validity = base.getValidity();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<TrustKeystore> getImplementedInterface() {
            return TrustKeystore.class;
        }

        @Override
        public String getAlias() {
            return this._alias;
        }

        @Override
        public String getDname() {
            return this._dname;
        }

        @Override
        public String getKeyAlg() {
            return this._keyAlg;
        }

        @Override
        public Integer getKeysize() {
            return this._keysize;
        }

        @Override
        public byte[] getKeystoreFile() {
            return this._keystoreFile == null ? null : (byte[])this._keystoreFile.clone();
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getSignAlg() {
            return this._signAlg;
        }

        @Override
        public String getStorePassword() {
            return this._storePassword;
        }

        @Override
        public Integer getValidity() {
            return this._validity;
        }

        public <E$$ extends Augmentation<TrustKeystore>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._alias);
            result = 31 * result + Objects.hashCode(this._dname);
            result = 31 * result + Objects.hashCode(this._keyAlg);
            result = 31 * result + Objects.hashCode(this._keysize);
            result = 31 * result + Arrays.hashCode(this._keystoreFile);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._signAlg);
            result = 31 * result + Objects.hashCode(this._storePassword);
            result = 31 * result + Objects.hashCode(this._validity);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TrustKeystore.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TrustKeystore other = (TrustKeystore)obj;
            if (!Objects.equals(this._alias, other.getAlias())) {
                return false;
            }
            if (!Objects.equals(this._dname, other.getDname())) {
                return false;
            }
            if (!Objects.equals(this._keyAlg, other.getKeyAlg())) {
                return false;
            }
            if (!Objects.equals(this._keysize, other.getKeysize())) {
                return false;
            }
            if (!Arrays.equals(this._keystoreFile, other.getKeystoreFile())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._signAlg, other.getSignAlg())) {
                return false;
            }
            if (!Objects.equals(this._storePassword, other.getStorePassword())) {
                return false;
            }
            if (!Objects.equals(this._validity, other.getValidity())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TrustKeystoreImpl otherImpl = (TrustKeystoreImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TrustKeystore>>, Augmentation<TrustKeystore>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TrustKeystore");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_alias", (Object)this._alias);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dname", (Object)this._dname);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_keyAlg", (Object)this._keyAlg);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_keysize", (Object)this._keysize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_keystoreFile", (byte[])this._keystoreFile);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_signAlg", (Object)this._signAlg);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_storePassword", (Object)this._storePassword);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_validity", (Object)this._validity);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

