/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.mdsal.rev160321.cipher.suite.CipherSuites;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CipherSuitesBuilder
implements Builder<CipherSuites> {
    private String _suiteName;
    Map<Class<? extends Augmentation<CipherSuites>>, Augmentation<CipherSuites>> augmentation = Collections.emptyMap();

    public CipherSuitesBuilder() {
    }

    public CipherSuitesBuilder(CipherSuites base) {
        Map aug;
        this._suiteName = base.getSuiteName();
        if (base instanceof CipherSuitesImpl) {
            CipherSuitesImpl impl = (CipherSuitesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CipherSuites>>, Augmentation<CipherSuites>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CipherSuites>>, Augmentation<CipherSuites>>(aug);
        }
    }

    public String getSuiteName() {
        return this._suiteName;
    }

    public <E$$ extends Augmentation<CipherSuites>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public CipherSuitesBuilder setSuiteName(String value) {
        this._suiteName = value;
        return this;
    }

    public CipherSuitesBuilder addAugmentation(Class<? extends Augmentation<CipherSuites>> augmentationType, Augmentation<CipherSuites> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CipherSuites>>, Augmentation<CipherSuites>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CipherSuitesBuilder removeAugmentation(Class<? extends Augmentation<CipherSuites>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CipherSuites build() {
        return new CipherSuitesImpl(this);
    }

    private static final class CipherSuitesImpl
    implements CipherSuites {
        private final String _suiteName;
        private Map<Class<? extends Augmentation<CipherSuites>>, Augmentation<CipherSuites>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        CipherSuitesImpl(CipherSuitesBuilder base) {
            this._suiteName = base.getSuiteName();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<CipherSuites> getImplementedInterface() {
            return CipherSuites.class;
        }

        @Override
        public String getSuiteName() {
            return this._suiteName;
        }

        public <E$$ extends Augmentation<CipherSuites>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._suiteName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CipherSuites.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CipherSuites other = (CipherSuites)obj;
            if (!Objects.equals(this._suiteName, other.getSuiteName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CipherSuitesImpl otherImpl = (CipherSuitesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CipherSuites>>, Augmentation<CipherSuites>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"CipherSuites");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_suiteName", (Object)this._suiteName);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

