/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyStoreConstant {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreConstant.class);
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String BEGIN_CERTIFICATE_REQUEST = "-----BEGIN CERTIFICATE REQUEST-----";
    public static final long DAY_TIME = 86400000L;
    public static final String DEFAULT_KEY_ALG = "RSA";
    public static final int DEFAULT_KEY_SIZE = 2048;
    public static final String DEFAULT_SIGN_ALG = "SHA1WithRSAEncryption";
    public static final int DEFAULT_VALIDITY = 365;
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String END_CERTIFICATE_REQUEST = "-----END CERTIFICATE REQUEST-----";
    public static final String TLS_PROTOCOL = "TLS";
    public static final String KEY_STORE_PATH = "configuration" + File.separator + "ssl" + File.separator;

    private KeyStoreConstant() {
    }

    public static boolean checkKeyStoreFile(String fileName) {
        File file = new File(KEY_STORE_PATH + fileName);
        return file.exists();
    }

    public static String createDir(String dir) {
        File file = new File(dir);
        if (!file.exists() && !file.mkdirs()) {
            LOG.error("Failed to create directories {}", (Object)file);
        }
        return file.getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(String certFile) {
        if (certFile == null) return null;
        if (certFile.isEmpty()) {
            return null;
        }
        String path = KEY_STORE_PATH + certFile;
        try (FileInputStream fInputStream = new FileInputStream(path);){
            int available = fInputStream.available();
            byte[] certBytes = new byte[available];
            int numRead = fInputStream.read(certBytes);
            if (numRead != available) {
                LOG.warn("Expected {} bytes read from {}, actual was {}", new Object[]{available, path, numRead});
            }
            String string = new String(certBytes, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveCert(String fileName, String cert) {
        if (fileName == null) return false;
        if (fileName.isEmpty()) {
            return false;
        }
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(KEY_STORE_PATH + fileName), StandardCharsets.UTF_8));){
            out.write(cert);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

