/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.cert.impl;

import com.google.common.base.MoreObjects;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.aaa.cert.api.IAaaCertProvider;
import org.opendaylight.aaa.cert.impl.AaaCertMdsalProvider;
import org.opendaylight.aaa.cert.impl.ODLKeyTool;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.CtlKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.TrustKeystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.aaa.cert.rev151126.aaa.cert.service.config.ctlkeystore.CipherSuites;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMdsalSslData
implements IAaaCertProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMdsalSslData.class);
    private static final String ERROR_MESSAGE = "password is not correct or keystore has been corrupted";
    private final AaaCertMdsalProvider aaaCertMdsalProv;
    private final CtlKeystore ctlKeyStore;
    private final TrustKeystore trustKeystore;
    private final String bundleName;

    public DefaultMdsalSslData(AaaCertMdsalProvider aaaCertMdsalProv, String bundleName, CtlKeystore ctlKeyStore, TrustKeystore trustKeystore) {
        this.bundleName = bundleName;
        this.aaaCertMdsalProv = aaaCertMdsalProv;
        this.ctlKeyStore = ctlKeyStore;
        this.trustKeystore = trustKeystore;
        this.aaaCertMdsalProv.initializeKeystoreDataTree();
    }

    @Override
    public boolean addCertificateODLKeyStore(String storePasswd, String alias, String certificate) {
        if (!this.aaaCertMdsalProv.getSslData(this.bundleName).getOdlKeystore().getStorePassword().equals(storePasswd)) {
            LOG.debug(ERROR_MESSAGE);
            return false;
        }
        return this.aaaCertMdsalProv.addODLStoreSignedCertificate(this.bundleName, alias, certificate);
    }

    @Override
    public boolean addCertificateODLKeyStore(String alias, String certificate) {
        return this.aaaCertMdsalProv.addODLStoreSignedCertificate(this.bundleName, alias, certificate);
    }

    @Override
    public boolean addCertificateTrustStore(String storePasswd, String alias, String certificate) {
        if (this.aaaCertMdsalProv.getSslData(this.bundleName).getTrustKeystore().getStorePassword().equals(storePasswd)) {
            LOG.debug(ERROR_MESSAGE);
            return false;
        }
        return this.aaaCertMdsalProv.addTrustNodeCertificate(this.bundleName, alias, certificate);
    }

    @Override
    public boolean addCertificateTrustStore(String alias, String certificate) {
        return this.aaaCertMdsalProv.addTrustNodeCertificate(this.bundleName, alias, certificate);
    }

    @Override
    public String genODLKeyStoreCertificateReq(String storePasswd, boolean withTag) {
        if (!this.aaaCertMdsalProv.getSslData(this.bundleName).getOdlKeystore().getStorePassword().equals(storePasswd)) {
            LOG.debug(ERROR_MESSAGE);
            return "";
        }
        return this.aaaCertMdsalProv.genODLKeyStoreCertificateReq(this.bundleName, withTag);
    }

    @Override
    public String genODLKeyStoreCertificateReq(boolean withTag) {
        return this.aaaCertMdsalProv.genODLKeyStoreCertificateReq(this.bundleName, withTag);
    }

    @Override
    public String getCertificateTrustStore(String storePasswd, String alias, boolean withTag) {
        if (!this.aaaCertMdsalProv.getSslData(this.bundleName).getTrustKeystore().getStorePassword().equals(storePasswd)) {
            LOG.debug(ERROR_MESSAGE);
            return "";
        }
        return this.aaaCertMdsalProv.getTrustStoreCertificate(this.bundleName, alias, withTag);
    }

    @Override
    public String getCertificateTrustStore(String alias, boolean withTag) {
        return (String)MoreObjects.firstNonNull((Object)this.aaaCertMdsalProv.getTrustStoreCertificate(this.bundleName, alias, withTag), (Object)"");
    }

    @Override
    public String getODLKeyStoreCertificate(String storePasswd, boolean withTag) {
        if (!this.aaaCertMdsalProv.getSslData(this.bundleName).getOdlKeystore().getStorePassword().equals(storePasswd)) {
            LOG.debug(ERROR_MESSAGE);
            return "";
        }
        return this.aaaCertMdsalProv.getODLStoreCertificate(this.bundleName, withTag);
    }

    @Override
    public String getODLKeyStoreCertificate(boolean withTag) {
        return (String)MoreObjects.firstNonNull((Object)this.aaaCertMdsalProv.getODLStoreCertificate(this.bundleName, withTag), (Object)"");
    }

    @Override
    public KeyStore getODLKeyStore() {
        return this.aaaCertMdsalProv.getODLKeyStore(this.bundleName);
    }

    @Override
    public KeyStore getTrustKeyStore() {
        return this.aaaCertMdsalProv.getTrustKeyStore(this.bundleName);
    }

    @Override
    public String[] getCipherSuites() {
        return this.aaaCertMdsalProv.getCipherSuites(this.bundleName);
    }

    private String[] getCipherSuites(List<CipherSuites> cipherSuites) {
        ArrayList suites = new ArrayList();
        if (cipherSuites != null && !cipherSuites.isEmpty()) {
            cipherSuites.forEach(cs -> suites.add(cs.getSuiteName()));
        }
        return suites.toArray(new String[suites.size()]);
    }

    @Override
    public TrustKeystore getTrustKeyStoreInfo() {
        return this.trustKeystore;
    }

    @Override
    public CtlKeystore getOdlKeyStoreInfo() {
        return this.ctlKeyStore;
    }

    @Override
    public boolean createKeyStores() {
        if (this.aaaCertMdsalProv.getSslData(this.bundleName) == null) {
            return this.aaaCertMdsalProv.addSslDataKeystores(this.bundleName, this.ctlKeyStore.getName(), this.ctlKeyStore.getStorePassword(), this.ctlKeyStore.getAlias(), this.ctlKeyStore.getDname(), this.ctlKeyStore.getKeyAlg(), this.ctlKeyStore.getSignAlg(), this.ctlKeyStore.getKeysize(), this.ctlKeyStore.getValidity(), this.trustKeystore.getName(), this.trustKeystore.getStorePassword(), this.getCipherSuites(this.ctlKeyStore.getCipherSuites()), this.ctlKeyStore.getTlsProtocols()) != null;
        }
        return true;
    }

    @Override
    public String[] getTlsProtocols() {
        return this.aaaCertMdsalProv.getTlsProtocols(this.bundleName);
    }

    public void exportSslDataKeystores() {
        this.aaaCertMdsalProv.exportSslDataKeystores(this.bundleName);
    }

    public boolean importSslDataKeystores(String odlKeystoreName, String odlKeystorePwd, String odlKeystoreAlias, String trustKeystoreName, String trustKeystorePwd, String[] cipherSuites, String tlsProtocols) {
        KeyStore trustKeyStore;
        ODLKeyTool keyTool = new ODLKeyTool();
        KeyStore odlKeyStore = keyTool.loadKeyStore(odlKeystoreName, odlKeystorePwd);
        return this.aaaCertMdsalProv.importSslDataKeystores(this.bundleName, odlKeystoreName, odlKeystorePwd, odlKeystoreAlias, odlKeyStore, trustKeystoreName, trustKeystorePwd, trustKeyStore = keyTool.loadKeyStore(trustKeystoreName, trustKeystorePwd), cipherSuites, tlsProtocols) != null;
    }
}

