/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.ssh.client;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.WritePendingException;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncSshHandlerWriter
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncSshHandlerWriter.class);
    private final Object asyncInLock = new Object();
    private volatile IoOutputStream asyncIn;
    private final Deque<PendingWriteRequest> pending = new LinkedList<PendingWriteRequest>();
    private @GuardedBy(value={"asyncInLock"}) boolean isWriteExecuted = false;

    public AsyncSshHandlerWriter(IoOutputStream asyncIn) {
        this.asyncIn = asyncIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.asyncIn == null) {
            promise.setFailure((Throwable)new IllegalStateException("Channel closed"));
            return;
        }
        Object object = this.asyncInLock;
        synchronized (object) {
            if (this.asyncIn.isClosed() || this.asyncIn.isClosing()) {
                promise.setFailure((Throwable)new IllegalStateException("Channel closed"));
            } else {
                ByteBuf byteBufMsg = (ByteBuf)msg;
                if (this.isWriteExecuted) {
                    this.queueRequest(ctx, byteBufMsg, promise);
                    return;
                }
                this.writeWithPendingDetection(ctx, promise, byteBufMsg, false);
            }
        }
    }

    private void writeWithPendingDetection(ChannelHandlerContext ctx, ChannelPromise promise, ByteBuf byteBufMsg, boolean wasPending) {
        block3: {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Writing request on channel: {}, message: {}", (Object)ctx.channel(), (Object)AsyncSshHandlerWriter.byteBufToString(byteBufMsg));
                }
                this.isWriteExecuted = true;
                this.asyncIn.writePacket(AsyncSshHandlerWriter.toBuffer(byteBufMsg)).addListener(future -> {
                    Object object = this.asyncInLock;
                    synchronized (object) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Ssh write request finished on channel: {} with result: {}: and ex:{}, message: {}", new Object[]{ctx.channel(), future.isWritten(), future.getException(), AsyncSshHandlerWriter.byteBufToString(byteBufMsg)});
                        }
                        if (future.isWritten()) {
                            promise.setSuccess();
                        } else {
                            LOG.warn("Ssh write request failed on channel: {} for message: {}", new Object[]{ctx.channel(), AsyncSshHandlerWriter.byteBufToString(byteBufMsg), future.getException()});
                            promise.setFailure(future.getException());
                        }
                        if (wasPending) {
                            byteBufMsg.resetReaderIndex();
                            this.pending.remove();
                        }
                        byteBufMsg.release();
                    }
                    this.writePendingIfAny();
                });
            }
            catch (IOException | WritePendingException e) {
                if (wasPending) break block3;
                this.queueRequest(ctx, byteBufMsg, promise);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePendingIfAny() {
        Object object = this.asyncInLock;
        synchronized (object) {
            if (this.pending.peek() == null) {
                this.isWriteExecuted = false;
                return;
            }
            PendingWriteRequest pendingWrite = this.pending.peek();
            ByteBuf msg = pendingWrite.msg;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Writing pending request on channel: {}, message: {}", (Object)pendingWrite.ctx.channel(), (Object)AsyncSshHandlerWriter.byteBufToString(msg));
            }
            this.writeWithPendingDetection(pendingWrite.ctx, pendingWrite.promise, msg, true);
        }
    }

    public static String byteBufToString(ByteBuf msg) {
        String s = msg.toString(StandardCharsets.UTF_8);
        msg.resetReaderIndex();
        return s;
    }

    private void queueRequest(ChannelHandlerContext ctx, ByteBuf msg, ChannelPromise promise) {
        LOG.debug("Write pending on channel: {}, queueing, current queue size: {}", (Object)ctx.channel(), (Object)this.pending.size());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Queueing request due to pending: {}", (Object)AsyncSshHandlerWriter.byteBufToString(msg));
        }
        new PendingWriteRequest(ctx, msg, promise).pend(this.pending);
    }

    @Override
    public void close() {
        this.asyncIn = null;
    }

    private static Buffer toBuffer(ByteBuf msg) {
        msg.resetReaderIndex();
        byte[] temp = new byte[msg.readableBytes()];
        msg.readBytes(temp, 0, msg.readableBytes());
        return new ByteArrayBuffer(temp);
    }

    private static final class PendingWriteRequest {
        private final ChannelHandlerContext ctx;
        private final ByteBuf msg;
        private final ChannelPromise promise;

        PendingWriteRequest(ChannelHandlerContext ctx, ByteBuf msg, ChannelPromise promise) {
            this.ctx = ctx;
            msg.resetReaderIndex();
            this.msg = msg;
            this.promise = promise;
        }

        public void pend(Queue<PendingWriteRequest> pending) {
            Preconditions.checkState((boolean)pending.offer(this), (String)"Cannot pend another request write (pending count: %s) on channel: %s", (int)pending.size(), (Object)this.ctx.channel());
        }
    }
}

