/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler.ssh.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoReadFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.opendaylight.netconf.nettyutil.handler.ssh.client.AsyncSshHandlerWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncSshHandlerReader
implements SshFutureListener<IoReadFuture>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncSshHandlerReader.class);
    private static final int BUFFER_SIZE = 2048;
    private final AutoCloseable connectionClosedCallback;
    private final ReadMsgHandler readHandler;
    private final String channelId;
    private IoInputStream asyncOut;
    private Buffer buf;
    private IoReadFuture currentReadFuture;

    public AsyncSshHandlerReader(AutoCloseable connectionClosedCallback, ReadMsgHandler readHandler, String channelId, IoInputStream asyncOut) {
        this.connectionClosedCallback = connectionClosedCallback;
        this.readHandler = readHandler;
        this.channelId = channelId;
        this.asyncOut = asyncOut;
        this.buf = new ByteArrayBuffer(2048);
        asyncOut.read(this.buf).addListener((SshFutureListener)this);
    }

    public void operationComplete(IoReadFuture future) {
        if (this.checkDisconnect(future)) {
            this.invokeDisconnect();
        }
    }

    private synchronized boolean checkDisconnect(IoReadFuture future) {
        if (future.getException() != null) {
            if (this.asyncOut == null) {
                return false;
            }
            if (this.asyncOut.isClosed() || this.asyncOut.isClosing()) {
                LOG.debug("Ssh session dropped on channel: {}", (Object)this.channelId, (Object)future.getException());
            } else {
                LOG.warn("Exception while reading from SSH remote on channel {}", (Object)this.channelId, (Object)future.getException());
            }
            return true;
        }
        if (future.getRead() > 0) {
            ByteBuf msg = Unpooled.wrappedBuffer((byte[])this.buf.array(), (int)0, (int)future.getRead());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Reading message on channel: {}, message: {}", (Object)this.channelId, (Object)AsyncSshHandlerWriter.byteBufToString(msg));
            }
            this.readHandler.onMessageRead(msg);
            this.buf = new ByteArrayBuffer(2048);
            this.currentReadFuture = this.asyncOut.read(this.buf);
            this.currentReadFuture.addListener((SshFutureListener)this);
        }
        return false;
    }

    private void invokeDisconnect() {
        try {
            this.connectionClosedCallback.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void close() {
        if (this.currentReadFuture != null) {
            this.currentReadFuture.removeListener((SshFutureListener)this);
            this.currentReadFuture = null;
        }
        this.asyncOut = null;
    }

    public static interface ReadMsgHandler {
        public void onMessageRead(ByteBuf var1);
    }
}

