/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opendaylight.netconf.api.NetconfMessage;
import org.opendaylight.netconf.nettyutil.handler.BufferedWriter;
import org.opendaylight.netconf.nettyutil.handler.ThreadLocalTransformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;

public class NetconfMessageToXMLEncoder
extends MessageToByteEncoder<NetconfMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageToXMLEncoder.class);
    private final Optional<String> clientId;

    public NetconfMessageToXMLEncoder() {
        this((Optional<String>)Optional.absent());
    }

    public NetconfMessageToXMLEncoder(Optional<String> clientId) {
        this.clientId = clientId;
    }

    @VisibleForTesting
    public void encode(ChannelHandlerContext ctx, NetconfMessage msg, ByteBuf out) throws IOException, TransformerException {
        LOG.trace("Sent to encode : {}", (Object)msg);
        if (this.clientId.isPresent()) {
            Comment comment = msg.getDocument().createComment("clientId:" + (String)this.clientId.get());
            msg.getDocument().appendChild(comment);
        }
        try (ByteBufOutputStream os = new ByteBufOutputStream(out);){
            StreamResult result = new StreamResult(new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8)));
            DOMSource source = new DOMSource(msg.getDocument());
            ThreadLocalTransformers.getPrettyTransformer().transform(source, result);
        }
    }
}

