/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.nettyutil.AbstractNetconfDispatcher;
import org.opendaylight.netconf.nettyutil.ReconnectStrategy;
import org.opendaylight.netconf.nettyutil.ReconnectStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class ReconnectPromise<S extends NetconfSession, L extends NetconfSessionListener<? super S>>
extends DefaultPromise<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ReconnectPromise.class);
    private final AbstractNetconfDispatcher<S, L> dispatcher;
    private final InetSocketAddress address;
    private final ReconnectStrategyFactory strategyFactory;
    private final Bootstrap bootstrap;
    private final AbstractNetconfDispatcher.PipelineInitializer<S> initializer;
    private Future<?> pending;

    ReconnectPromise(EventExecutor executor, AbstractNetconfDispatcher<S, L> dispatcher, InetSocketAddress address, ReconnectStrategyFactory connectStrategyFactory, Bootstrap bootstrap, AbstractNetconfDispatcher.PipelineInitializer<S> initializer) {
        super(executor);
        this.bootstrap = bootstrap;
        this.initializer = (AbstractNetconfDispatcher.PipelineInitializer)Preconditions.checkNotNull(initializer);
        this.dispatcher = (AbstractNetconfDispatcher)Preconditions.checkNotNull(dispatcher);
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address);
        this.strategyFactory = (ReconnectStrategyFactory)Preconditions.checkNotNull((Object)connectStrategyFactory);
    }

    synchronized void connect() {
        ReconnectStrategy cs = this.strategyFactory.createReconnectStrategy();
        this.pending = this.dispatcher.createClient(this.address, cs, this.bootstrap, (channel, promise) -> {
            this.initializer.initializeChannel(channel, promise);
            channel.pipeline().addLast(new ChannelHandler[]{new ClosedChannelHandler(this)});
        });
        this.pending.addListener(future -> {
            if (!future.isSuccess() && !this.isDone()) {
                this.setFailure(future.cause());
            }
        });
    }

    private synchronized boolean isInitialConnectFinished() {
        Preconditions.checkNotNull(this.pending);
        return this.pending.isDone() && this.pending.isSuccess();
    }

    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            Preconditions.checkNotNull(this.pending);
            this.pending.cancel(mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    private static final class ClosedChannelHandler
    extends ChannelInboundHandlerAdapter {
        private final ReconnectPromise<?, ?> promise;

        ClosedChannelHandler(ReconnectPromise<?, ?> promise) {
            this.promise = promise;
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            if (this.promise.isCancelled()) {
                return;
            }
            if (!((ReconnectPromise)this.promise).isInitialConnectFinished()) {
                LOG.debug("Connection to {} was dropped during negotiation, reattempting", (Object)((ReconnectPromise)this.promise).address);
            }
            LOG.debug("Reconnecting after connection to {} was dropped", (Object)((ReconnectPromise)this.promise).address);
            this.promise.connect();
        }
    }
}

