/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.nettyutil;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.nettyutil.NetconfSessionPromise;
import org.opendaylight.netconf.nettyutil.ReconnectPromise;
import org.opendaylight.netconf.nettyutil.ReconnectStrategy;
import org.opendaylight.netconf.nettyutil.ReconnectStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractNetconfDispatcher<S extends NetconfSession, L extends NetconfSessionListener<? super S>>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetconfDispatcher.class);
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final EventExecutor executor;

    protected AbstractNetconfDispatcher(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this((EventExecutor)GlobalEventExecutor.INSTANCE, bossGroup, workerGroup);
    }

    protected AbstractNetconfDispatcher(EventExecutor executor, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.bossGroup = (EventLoopGroup)Preconditions.checkNotNull((Object)bossGroup);
        this.workerGroup = (EventLoopGroup)Preconditions.checkNotNull((Object)workerGroup);
        this.executor = (EventExecutor)Preconditions.checkNotNull((Object)executor);
    }

    protected ChannelFuture createServer(InetSocketAddress address, PipelineInitializer<S> initializer) {
        return this.createServer(address, NioServerSocketChannel.class, initializer);
    }

    protected <C extends Channel> ChannelFuture createServer(SocketAddress address, Class<? extends ServerChannel> channelClass, final ChannelPipelineInitializer<C, S> initializer) {
        ServerBootstrap b = new ServerBootstrap();
        b.childHandler((ChannelHandler)new ChannelInitializer<C>(){

            protected void initChannel(C ch) {
                initializer.initializeChannel(ch, new DefaultPromise(AbstractNetconfDispatcher.this.executor));
            }
        });
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        if (!LocalServerChannel.class.equals(channelClass)) {
            b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        }
        b.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.customizeBootstrap(b);
        if (b.group() == null) {
            b.group(this.bossGroup, this.workerGroup);
        }
        try {
            b.channel(channelClass);
        }
        catch (IllegalStateException e) {
            LOG.trace("Not overriding channelFactory on bootstrap {}", (Object)b, (Object)e);
        }
        ChannelFuture f = b.bind(address);
        LOG.debug("Initiated server {} at {}.", (Object)f, (Object)address);
        return f;
    }

    protected void customizeBootstrap(ServerBootstrap bootstrap) {
    }

    protected void customizeBootstrap(Bootstrap bootstrap) {
    }

    protected Future<S> createClient(InetSocketAddress address, ReconnectStrategy strategy, final PipelineInitializer<S> initializer) {
        Bootstrap b = new Bootstrap();
        final NetconfSessionPromise p = new NetconfSessionPromise(this.executor, address, strategy, b);
        ((Bootstrap)b.option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                initializer.initializeChannel(ch, p);
            }
        });
        this.customizeBootstrap(b);
        this.setWorkerGroup(b);
        AbstractNetconfDispatcher.setChannelFactory(b);
        p.connect();
        LOG.debug("Client created.");
        return p;
    }

    protected Future<S> createClient(InetSocketAddress address, ReconnectStrategy strategy, Bootstrap bootstrap, final PipelineInitializer<S> initializer) {
        final NetconfSessionPromise p = new NetconfSessionPromise(this.executor, address, strategy, bootstrap);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                initializer.initializeChannel(ch, p);
            }
        });
        p.connect();
        LOG.debug("Client created.");
        return p;
    }

    @Deprecated
    protected Future<Void> createReconnectingClient(InetSocketAddress address, ReconnectStrategyFactory connectStrategyFactory, ReconnectStrategy reestablishStrategy, PipelineInitializer<S> initializer) {
        return this.createReconnectingClient(address, connectStrategyFactory, initializer);
    }

    protected Future<Void> createReconnectingClient(InetSocketAddress address, ReconnectStrategyFactory connectStrategyFactory, PipelineInitializer<S> initializer) {
        Bootstrap b = new Bootstrap();
        ReconnectPromise p = new ReconnectPromise((EventExecutor)GlobalEventExecutor.INSTANCE, this, address, connectStrategyFactory, b, initializer);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.customizeBootstrap(b);
        this.setWorkerGroup(b);
        AbstractNetconfDispatcher.setChannelFactory(b);
        p.connect();
        return p;
    }

    private static void setChannelFactory(Bootstrap bootstrap) {
        try {
            bootstrap.channel(NioSocketChannel.class);
        }
        catch (IllegalStateException e) {
            LOG.trace("Not overriding channelFactory on bootstrap {}", (Object)bootstrap, (Object)e);
        }
    }

    private void setWorkerGroup(Bootstrap bootstrap) {
        if (bootstrap.group() == null) {
            bootstrap.group(this.workerGroup);
        }
    }

    @Override
    @Deprecated
    public void close() {
    }

    protected static interface PipelineInitializer<S extends NetconfSession>
    extends ChannelPipelineInitializer<SocketChannel, S> {
    }

    protected static interface ChannelPipelineInitializer<C extends Channel, S extends NetconfSession> {
        public void initializeChannel(C var1, Promise<S> var2);
    }
}

