/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.config.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jasypt.encryption.StringEncryptor;

public class Decryptor {
    private static final String ENCRYPTED_PROPERTY_PREFIX = "ENC(";
    private static final String ENCRYPTED_PROPERTY_SUFFIX = ")";
    private static final char ALIAS_SEPARATOR = ',';
    private static final String DECRYPTOR_ALIAS = "decryptor";
    private StringEncryptor decryptor;

    public Decryptor(StringEncryptor decryptor) {
        this.decryptor = decryptor;
    }

    public static String getAlias(Dictionary<String, Object> config) {
        String alias = Decryptor.getValue(config, DECRYPTOR_ALIAS);
        Enumeration<String> e = config.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = Decryptor.getValue(config, key);
            String newAlias = Decryptor.getAlias(value);
            if (newAlias == null) continue;
            if (alias == null) {
                alias = newAlias;
                continue;
            }
            if (alias.equals(newAlias)) continue;
            throw new RuntimeException("Only one alias is supported but found at least two: " + newAlias + ", " + alias);
        }
        return alias;
    }

    private static String getValue(Dictionary<String, Object> config, String key) {
        Object value = config.get(key);
        return value == null ? null : value.toString();
    }

    private static String getAlias(String value) {
        if (!Decryptor.isEncrypted(value)) {
            return null;
        }
        String argument = value.substring(ENCRYPTED_PROPERTY_PREFIX.length(), value.length() - ENCRYPTED_PROPERTY_SUFFIX.length());
        int aliasPos = argument.indexOf(44);
        return aliasPos > -1 ? argument.substring(aliasPos + 1).trim() : null;
    }

    public Dictionary<String, Object> decrypt(Dictionary<String, Object> config) {
        if (this.decryptor == null) {
            return config;
        }
        Hashtable<String, Object> decryptedConfig = new Hashtable<String, Object>();
        Enumeration<String> e = config.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = String.valueOf(config.get(key));
            if (config.get(key) instanceof String && Decryptor.isEncrypted(value)) {
                String plainText = this.decryptValue(value);
                if (plainText == null) continue;
                ((Dictionary)decryptedConfig).put(key, plainText);
                continue;
            }
            ((Dictionary)decryptedConfig).put(key, value);
        }
        return decryptedConfig;
    }

    private String decryptValue(String value) {
        String argument = value.substring(ENCRYPTED_PROPERTY_PREFIX.length(), value.length() - ENCRYPTED_PROPERTY_SUFFIX.length());
        int aliasPos = argument.indexOf(44);
        String cipherText = aliasPos > -1 ? argument.substring(0, aliasPos) : argument;
        return this.decryptor.decrypt(cipherText);
    }

    public static boolean isEncrypted(String value) {
        return value.startsWith(ENCRYPTED_PROPERTY_PREFIX) && value.endsWith(ENCRYPTED_PROPERTY_SUFFIX);
    }

    public static boolean isEncrypted(Dictionary<String, Object> loadedConfig) {
        Enumeration<Object> values = loadedConfig.elements();
        while (values.hasMoreElements()) {
            Object value = values.nextElement();
            if (!(value instanceof String) || !Decryptor.isEncrypted((String)value)) continue;
            return true;
        }
        return false;
    }
}

