/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.CommitInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CommitInputBuilder
implements Builder<CommitInput> {
    private Long _confirmTimeout;
    private String _persist;
    private String _persistId;
    private Boolean _confirmed;
    Map<Class<? extends Augmentation<CommitInput>>, Augmentation<CommitInput>> augmentation = Collections.emptyMap();

    public CommitInputBuilder() {
    }

    public CommitInputBuilder(CommitInput base) {
        Map aug;
        this._confirmTimeout = base.getConfirmTimeout();
        this._persist = base.getPersist();
        this._persistId = base.getPersistId();
        this._confirmed = base.isConfirmed();
        if (base instanceof CommitInputImpl) {
            CommitInputImpl impl = (CommitInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CommitInput>>, Augmentation<CommitInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CommitInput>>, Augmentation<CommitInput>>(aug);
        }
    }

    public Long getConfirmTimeout() {
        return this._confirmTimeout;
    }

    public String getPersist() {
        return this._persist;
    }

    public String getPersistId() {
        return this._persistId;
    }

    public Boolean isConfirmed() {
        return this._confirmed;
    }

    public <E$$ extends Augmentation<CommitInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkConfirmTimeoutRange(long value) {
        if (value >= 1L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..4294967295]]", (long)value);
    }

    public CommitInputBuilder setConfirmTimeout(Long value) {
        if (value != null) {
            CommitInputBuilder.checkConfirmTimeoutRange(value);
        }
        this._confirmTimeout = value;
        return this;
    }

    public CommitInputBuilder setPersist(String value) {
        this._persist = value;
        return this;
    }

    public CommitInputBuilder setPersistId(String value) {
        this._persistId = value;
        return this;
    }

    public CommitInputBuilder setConfirmed(Boolean value) {
        this._confirmed = value;
        return this;
    }

    public CommitInputBuilder addAugmentation(Class<? extends Augmentation<CommitInput>> augmentationType, Augmentation<CommitInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CommitInput>>, Augmentation<CommitInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CommitInputBuilder removeAugmentation(Class<? extends Augmentation<CommitInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CommitInput build() {
        return new CommitInputImpl(this);
    }

    private static final class CommitInputImpl
    implements CommitInput {
        private final Long _confirmTimeout;
        private final String _persist;
        private final String _persistId;
        private final Boolean _confirmed;
        private Map<Class<? extends Augmentation<CommitInput>>, Augmentation<CommitInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        CommitInputImpl(CommitInputBuilder base) {
            this._confirmTimeout = base.getConfirmTimeout();
            this._persist = base.getPersist();
            this._persistId = base.getPersistId();
            this._confirmed = base.isConfirmed();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<CommitInput> getImplementedInterface() {
            return CommitInput.class;
        }

        @Override
        public Long getConfirmTimeout() {
            return this._confirmTimeout;
        }

        @Override
        public String getPersist() {
            return this._persist;
        }

        @Override
        public String getPersistId() {
            return this._persistId;
        }

        @Override
        public Boolean isConfirmed() {
            return this._confirmed;
        }

        public <E$$ extends Augmentation<CommitInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._confirmTimeout);
            result = 31 * result + Objects.hashCode(this._persist);
            result = 31 * result + Objects.hashCode(this._persistId);
            result = 31 * result + Objects.hashCode(this._confirmed);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CommitInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CommitInput other = (CommitInput)obj;
            if (!Objects.equals(this._confirmTimeout, other.getConfirmTimeout())) {
                return false;
            }
            if (!Objects.equals(this._persist, other.getPersist())) {
                return false;
            }
            if (!Objects.equals(this._persistId, other.getPersistId())) {
                return false;
            }
            if (!Objects.equals(this._confirmed, other.isConfirmed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CommitInputImpl otherImpl = (CommitInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CommitInput>>, Augmentation<CommitInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"CommitInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_confirmTimeout", (Object)this._confirmTimeout);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_persist", (Object)this._persist);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_persistId", (Object)this._persistId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_confirmed", (Object)this._confirmed);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

