/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.configuration.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="security-realmType", namespace="urn:org.ops4j.pax.web:undertow:1.0", propOrder={"identities", "authentication", "userPrincipalClassName", "rolePrincipalClassNames"})
public class SecurityRealm {
    @XmlAttribute
    private String name;
    @XmlElement(name="server-identities", namespace="urn:jboss:domain:5.0")
    private ServerIdentities identities;
    @XmlElement(name="authentication", namespace="urn:jboss:domain:5.0")
    private Authentication authentication;
    @XmlElement(name="user-principal-class-name")
    private String userPrincipalClassName;
    @XmlElement(name="role-principal-class-name")
    private List<String> rolePrincipalClassNames = new ArrayList<String>();

    public ServerIdentities getIdentities() {
        return this.identities;
    }

    public void setIdentities(ServerIdentities identities) {
        this.identities = identities;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserPrincipalClassName() {
        return this.userPrincipalClassName;
    }

    public void setUserPrincipalClassName(String userPrincipalClassName) {
        this.userPrincipalClassName = userPrincipalClassName;
    }

    public List<String> getRolePrincipalClassNames() {
        return this.rolePrincipalClassNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append("\t\t\tname: " + this.name);
        if (this.identities != null) {
            sb.append("\n\t\t\tssl: " + this.identities.getSsl());
        }
        sb.append("\n\t\t\tauthentication: " + this.authentication);
        sb.append("\n\t\t\tuser principal class name: " + this.userPrincipalClassName);
        sb.append("\n\t\t\trole principal class names: " + this.rolePrincipalClassNames);
        sb.append("\n\t\t}");
        return sb.toString();
    }

    @XmlType(name="propertiesAuthenticationType", namespace="urn:jboss:domain:5.0")
    public static class PropertiesAuth {
        @XmlAttribute
        private String path;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("path: ").append(this.path);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="jaasAuthenticationType", namespace="urn:jboss:domain:5.0")
    public static class JaasAuth {
        @XmlAttribute
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("name: ").append(this.name);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="realmExtendedKeyStoreType", namespace="urn:jboss:domain:5.0")
    public static class Keystore
    extends Truststore {
        @XmlAttribute
        private String alias;
        @XmlAttribute(name="key-password")
        private String keyPassword;
        @XmlAttribute(name="generate-self-signed-certificate-host")
        private String generateSelfSignedCertificateHost;

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public String getGenerateSelfSignedCertificateHost() {
            return this.generateSelfSignedCertificateHost;
        }

        public void setGenerateSelfSignedCertificateHost(String generateSelfSignedCertificateHost) {
            this.generateSelfSignedCertificateHost = generateSelfSignedCertificateHost;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("provider: ").append(this.getProvider());
            sb.append(", path: ").append(this.getPath());
            sb.append(", alias: ").append(this.alias);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="realmKeyStoreType", namespace="urn:jboss:domain:5.0")
    public static class Truststore {
        @XmlAttribute
        private String provider;
        @XmlAttribute
        private String path;
        @XmlAttribute(name="keystore-password")
        private String password;

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("provider: ").append(this.provider);
            sb.append(", path: ").append(this.path);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="engineType", namespace="urn:jboss:domain:5.0")
    public static class Engine {
        @XmlAttribute(name="enabled-cipher-suites")
        private List<String> enabledCipherSuites = new ArrayList<String>();
        @XmlAttribute(name="enabled-protocols")
        private List<String> enabledProtocols = new ArrayList<String>();

        public List<String> getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        public List<String> getEnabledProtocols() {
            return this.enabledProtocols;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("enabled ciphers: ").append(this.enabledCipherSuites);
            sb.append(", enabled protocols: ").append(this.enabledProtocols);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="authenticationType", namespace="urn:jboss:domain:5.0", propOrder={"truststore", "jaas", "properties"})
    public static class Authentication {
        @XmlElement
        private Truststore truststore;
        @XmlElement
        private JaasAuth jaas;
        @XmlElement
        private PropertiesAuth properties;

        public Truststore getTruststore() {
            return this.truststore;
        }

        public void setTruststore(Truststore truststore) {
            this.truststore = truststore;
        }

        public JaasAuth getJaas() {
            return this.jaas;
        }

        public void setJaas(JaasAuth jaas) {
            this.jaas = jaas;
        }

        public PropertiesAuth getProperties() {
            return this.properties;
        }

        public void setProperties(PropertiesAuth properties) {
            this.properties = properties;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("truststore: ").append(this.truststore);
            sb.append(", jaas: ").append(this.jaas);
            sb.append(", properties: ").append(this.properties);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="sslType", namespace="urn:jboss:domain:5.0", propOrder={"engine", "keystore"})
    public static class SSLConfig {
        @XmlElement(name="engine")
        private Engine engine;
        @XmlElement(name="keystore")
        private Keystore keystore;

        public Engine getEngine() {
            return this.engine;
        }

        public void setEngine(Engine engine) {
            this.engine = engine;
        }

        public Keystore getKeystore() {
            return this.keystore;
        }

        public void setKeystore(Keystore keystore) {
            this.keystore = keystore;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{\n");
            sb.append("\t\t\t\tengine: ").append(this.engine);
            sb.append("\n\t\t\t\tkeystore: ").append(this.keystore);
            sb.append("\n\t\t\t}");
            return sb.toString();
        }
    }

    @XmlType(name="server-identitiesType", namespace="urn:jboss:domain:5.0", propOrder={"ssl"})
    public static class ServerIdentities {
        @XmlElement(name="ssl")
        private SSLConfig ssl;

        public SSLConfig getSsl() {
            return this.ssl;
        }

        public void setSsl(SSLConfig ssl) {
            this.ssl = ssl;
        }
    }
}

