/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.servlet.api.SessionPersistenceManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSessionPersistence
implements SessionPersistenceManager {
    public static Logger LOG = LoggerFactory.getLogger(FileSessionPersistence.class);
    private File sessionsDir;

    public FileSessionPersistence(File sessionsDir) {
        this.sessionsDir = sessionsDir;
    }

    public void persistSessions(String deploymentName, Map<String, SessionPersistenceManager.PersistentSession> sessionData) {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry<String, SessionPersistenceManager.PersistentSession> e : sessionData.entrySet()) {
            LinkedHashMap<String, Object> mps = new LinkedHashMap<String, Object>();
            mps.put("expiration", e.getValue().getExpiration().getTime());
            mps.put("data", e.getValue().getSessionData());
            map.put(e.getKey(), mps);
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.sessionsDir, deploymentName))));){
            oos.writeObject(map);
        }
        catch (Exception e) {
            LOG.info("Error persisting sessions for deployment " + deploymentName, (Throwable)e);
        }
    }

    public Map<String, SessionPersistenceManager.PersistentSession> loadSessionAttributes(String deploymentName, ClassLoader classLoader) {
        LinkedHashMap<String, SessionPersistenceManager.PersistentSession> sessionData = new LinkedHashMap<String, SessionPersistenceManager.PersistentSession>();
        try (ObjectInputStream ois2 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(this.sessionsDir, deploymentName))));){
            Map map = (Map)ois2.readObject();
            for (Map.Entry e : map.entrySet()) {
                long expiration = (Long)((Map)e.getValue()).get("expiration");
                Map data = (Map)((Map)e.getValue()).get("data");
                sessionData.put((String)e.getKey(), new SessionPersistenceManager.PersistentSession(new Date(expiration), data));
            }
        }
        catch (FileNotFoundException ois2) {
        }
        catch (Exception e) {
            LOG.info("Error loading sessions for deployment " + deploymentName, (Throwable)e);
        }
        return sessionData;
    }

    public void clear(String deploymentName) {
        new File(this.sessionsDir, deploymentName).delete();
    }
}

