/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public abstract class AbstractStatementSupport<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
implements StatementDefinition,
StatementFactory<A, D, E>,
StatementSupport<A, D, E> {
    private final @NonNull StatementDefinition type;

    protected AbstractStatementSupport(StatementDefinition publicDefinition) {
        this.type = Objects.requireNonNull(publicDefinition);
        Preconditions.checkArgument((publicDefinition != this ? 1 : 0) != 0);
    }

    @Override
    public final StatementDefinition getPublicView() {
        return this.type;
    }

    @Override
    public void onStatementAdded(StmtContext.Mutable<A, D, E> stmt) {
    }

    @Override
    public void onPreLinkageDeclared(StmtContext.Mutable<A, D, E> stmt) {
    }

    @Override
    public void onLinkageDeclared(StmtContext.Mutable<A, D, E> stmt) {
    }

    @Override
    public void onStatementDefinitionDeclared(StmtContext.Mutable<A, D, E> stmt) {
    }

    @Override
    public void onFullDefinitionDeclared(StmtContext.Mutable<A, D, E> stmt) {
        SubstatementValidator validator = this.getSubstatementValidator();
        if (validator != null) {
            validator.validate(stmt);
        }
    }

    @Override
    public boolean hasArgumentSpecificSupports() {
        return false;
    }

    @Override
    public StatementSupport<?, ?, ?> getSupportSpecificForArgument(String argument) {
        return null;
    }

    protected abstract @Nullable SubstatementValidator getSubstatementValidator();
}

