/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import akka.persistence.RecoveryCompleted;
import akka.persistence.SnapshotOffer;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.client.AbstractClientActorBehavior;
import org.opendaylight.controller.cluster.access.client.InitialClientActorContext;
import org.opendaylight.controller.cluster.access.client.SavingClientActorBehavior;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecoveringClientActorBehavior
extends AbstractClientActorBehavior<InitialClientActorContext> {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveringClientActorBehavior.class);
    private final FrontendIdentifier currentFrontend;
    private ClientIdentifier lastId = null;

    RecoveringClientActorBehavior(InitialClientActorContext context, FrontendIdentifier frontendId) {
        super(context);
        this.currentFrontend = (FrontendIdentifier)Preconditions.checkNotNull((Object)frontendId);
    }

    @Override
    AbstractClientActorBehavior<?> onReceiveCommand(Object command) {
        throw new IllegalStateException("Frontend is recovering");
    }

    @Override
    AbstractClientActorBehavior<?> onReceiveRecover(Object recover) {
        if (recover instanceof RecoveryCompleted) {
            ClientIdentifier nextId;
            if (this.lastId != null) {
                if (!this.currentFrontend.equals((Object)this.lastId.getFrontendId())) {
                    LOG.error("{}: Mismatched frontend identifier, shutting down. Current: {} Saved: {}", new Object[]{this.persistenceId(), this.currentFrontend, this.lastId.getFrontendId()});
                    return null;
                }
                nextId = ClientIdentifier.create((FrontendIdentifier)this.currentFrontend, (long)(this.lastId.getGeneration() + 1L));
            } else {
                nextId = ClientIdentifier.create((FrontendIdentifier)this.currentFrontend, (long)0L);
            }
            LOG.debug("{}: persisting new identifier {}", (Object)this.persistenceId(), (Object)nextId);
            ((InitialClientActorContext)this.context()).saveSnapshot(nextId);
            return new SavingClientActorBehavior((InitialClientActorContext)this.context(), nextId);
        }
        if (recover instanceof SnapshotOffer) {
            this.lastId = (ClientIdentifier)((SnapshotOffer)recover).snapshot();
            LOG.debug("{}: recovered identifier {}", (Object)this.persistenceId(), (Object)this.lastId);
        } else {
            LOG.warn("{}: ignoring recovery message {}", (Object)this.persistenceId(), recover);
        }
        return this;
    }
}

