#!/bin/bash

source utils.sh

declare NUM_COREDUMPS=0

# Initialize the coredumps monitor engine
# Params:
#    $1: deploy name to be used when sending messages/logs
# Returns:
#    NONE
function monitor_coredumps_init() {
    local DEPLOY=${1:-no-name-set-for-deploy}

    NUM_COREDUMPS=$(ls /var/core/ | wc -l)
    send_notification "[$DEPLOY][$(date)] : Info init! Started script with $NUM_COREDUMPS cores in folder '/var/cores'"
    log_message "[$DEPLOY][$(date)] : Info init! Started script with $NUM_COREDUMPS cores in folder '/var/cores'" "${FUNCNAME[0]}" "$LINENO"
}

# Check for new core dumps in the /var/core/ folder
# Params:
#    $1: deploy name to be used when sending messages/logs
# Returns:
#    NONE
function monitor_coredumps_run() {
    local DEPLOY=${1:-no-name-set-for-deploy}

    cores=$(ls /var/core/ | wc -l)

    if [[ $cores -ne $NUM_COREDUMPS ]]; then
        send_notification "[$DEPLOY][$(date)] : Error! Coredumps changed from $NUM_COREDUMPS to $cores"
        log_message "[$DEPLOY][$(date)] : Error! Coredumps changed from $NUM_COREDUMPS to $cores" "${FUNCNAME[0]}" "$LINENO"
        NUM_COREDUMPS=$cores
    fi
}