#!/bin/bash

###############################################################################
# This script checks the magma services status and see if they are all
# running. If not, an Discord message is sent.
###############################################################################
source utils.sh

declare -r SERVICES=("enodebd" "mme" "subscriberdb" "state" "magmad" "smsd" "ctraced" "redis" "policydb" "control_proxy" "pipelined" "envoy_controller" "sessiond" "eventd" "dnsd" "mobilityd" "directoryd" "health")
declare -A CURRENT_STATUS
declare -A PREVIOUS_STATUS

declare CURRENT_OVS
declare PREVIOUS_OVS

function check_service_status() {
    local service_name=$1

    service magma@$service_name status | grep "Active: active (running)" >/dev/null
    ret=$?
    if [[ $ret -ne 0 ]]; then echo 0; else echo 1; fi
}

function init_magma_status() {
    local DEPLOY=${1:-no-name-set-for-deploy}

    for service in "${SERVICES[@]}"; do
        status=""
        PREVIOUS_STATUS[$service]=$(check_service_status "$service")
        if [[ ${PREVIOUS_STATUS[$service]} -eq 0 ]]; then status="not running"; else status="running"; fi

        log_message "[$DEPLOY][$(date)] : Info init! service **$service** is $status" "${FUNCNAME[0]}" "$LINENO"
    done

    grep "active (running)" <<< "$(service openvswitch-switch status)" >/dev/null
    if [[ $? -eq 0 ]]; then
        PREVIOUS_OVS=1
        log_message "[$DEPLOY][$(date)] : Info init! service **openvswitch-switch** is running" "${FUNCNAME[0]}" "$LINENO"
    else
        PREVIOUS_OVS=0
        log_message "[$DEPLOY][$(date)] : Info init! service **openvswitch-switch** is not running" "${FUNCNAME[0]}" "$LINENO"
    fi
}

function magma_status_run() {
    local DEPLOY=${1:-no-name-set-for-deploy}

    for service in "${SERVICES[@]}"; do
        CURRENT_STATUS[$service]=$(check_service_status "$service")

        if [[ "${CURRENT_STATUS[$service]}" -ne "${PREVIOUS_STATUS[$service]}" ]]; then
            PREVIOUS_STATUS[$service]="${CURRENT_STATUS[$service]}"

            if [[ "${CURRENT_STATUS[$service]}" -eq 0 ]]; then
                send_notification "[$DEPLOY][$(date)] : Error! service **$service** is not running"
                log_message "[$DEPLOY][$(date)] : Error! service **$service** is not running" "${FUNCNAME[0]}" "$LINENO"
            else
                send_notification "[$DEPLOY][$(date)] : Info! service **$service** is running"
                log_message "[$DEPLOY][$(date)] : Info! service **$service** is running" "${FUNCNAME[0]}" "$LINENO"
            fi
        fi
    done

    ovs=$(service openvswitch-switch status)
    grep "active (running)" <<< $ovs >/dev/null
    if [[ $? -ne 0 ]]; then
        CURRENT_OVS=0
    else
        CURRENT_OVS=1
    fi

    if [[ $CURRENT_OVS -ne $PREVIOUS_OVS ]]; then
        PREVIOUS_OVS=$CURRENT_OVS
        if [[ $CURRENT_OVS -eq 0 ]]; then
            send_notification "[$DEPLOY][$(date)] : Error! service **openvswitch-switch** is not running"
            log_message "[$DEPLOY][$(date)] : Error! service **openvswitch-switch** is not running" "${FUNCNAME[0]}" "$LINENO"
        else
            send_notification "[$DEPLOY][$(date)] : Info! service **openvswitch-switch** is running"
        log_message "[$DEPLOY][$(date)] : Info! service **openvswitch-switch** is running" "${FUNCNAME[0]}" "$LINENO"
        fi
    fi
}
