#!/usr/bin/env bash
#--------------------------------------------------------------------------#
#  Copyright (c) 2022-2024, Ciena Corporation                              #
#  All rights reserved.                                                    #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
#  PROPRIETARY NOTICE                                                      #
#  This Software consists of confidential information.                     #
#  Trade secret law and copyright law protect this Software.               #
#  The above notice of copyright on this Software does not indicate        #
#  any actual or intended publication of such Software.                    #
#                                                                          #
#--------------------------------------------------------------------------#

# Usage
usage () {
    cat <<HELP_USAGE

    $0

    Get Tibit NETCONF Server status and version information.

    Options:
      -h|--help       Display this help and usage text.
      -p|--port       TCP port number used to connect to the NETCONF Server (default: 830).
      -s|--server     Hostname or IP address used to connect to the NETCONF Server (default: localhost).
      -u|--username   Username with access to the NETCONF Server (default: $USER).
      -w|--password   Password used to access to the NETCONF Server.

    Example:
      $0

HELP_USAGE

exit 0
}

# Defaults
HOST=localhost
PORT=830

# Parse command line arguments
PARAMS=""
while (( "$#" )); do
    case "$1" in
        -s|--server)
            HOST=$2
            shift 2
            ;;
        -p|--port)
            PORT=$2
            shift 2
            ;;
        -u|--username)
            USER=$2
            shift 2
            ;;
        -w|--password)
            PASSWD="--password $2"
            shift 2
            ;;
        -h|--help)
            usage
            ;;
        --) # end argument parsing
            shift
            break
            ;;
        -*|--*=) # unsupported option
            echo "Error: Unsupported option $1" >&2
            usage
            ;;
        *) # preserve positional arguments
            PARAMS="$PARAMS $1"
            shift
            ;;
    esac
done
# set positional arguments in their proper place
eval set -- "$PARAMS"

# NETCONF <get> for /tibitnc:netconf-state
source /opt/tibit/confd/confdrc
${CONFD_DIR}/bin/netconf-console --host ${HOST} --port ${PORT} --user ${USER} ${PASSWD} --rpc - << XMLDATA
<get xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
  <filter type="subtree">
    <tibitnc:netconf-state xmlns:tibitnc="urn:com:tibitcom:ns:yang:netconf"/>
  </filter>
</get>
XMLDATA

if [ "$?" = "0" ]; then
    echo "Success."
else
    echo "Failed."
    exit 1
fi

exit 0
