#!/usr/bin/env bash
#--------------------------------------------------------------------------#
#  Copyright (c) 2022-2024, Ciena Corporation                              #
#  All rights reserved.                                                    #
#                                                                          #
#     _______ _____ __    __ ___                                           #
#    / _ __(_) ___//  |  / // _ |                                          #
#   / /   / / /__ / /|| / // / ||                                          #
#  / /___/ / /__ / / ||/ // /__||                                          #
# /_____/_/_____/_/  |__//_/   ||                                          #
#                                                                          #
#  PROPRIETARY NOTICE                                                      #
#  This Software consists of confidential information.                     #
#  Trade secret law and copyright law protect this Software.               #
#  The above notice of copyright on this Software does not indicate        #
#  any actual or intended publication of such Software.                    #
#                                                                          #
#--------------------------------------------------------------------------#

usage () {
    cat <<HELP_USAGE

    $0  <file>

    Configure the Netconf Network Configuration Access Control Model (RFC8341).

HELP_USAGE

exit 0
}

# Check root access
if [[ $EUID > 0 ]]; then
  echo "Root level access is required. Please use 'sudo' to run the $0 script."
  exit
fi

[ -z $1 ] && { usage; }

FILE=$1

echo "Configuring NACM for the NETCONF Server from ${FILE}."

# Apply configuration to the running datastore.
echo "Applying NACM configuration from ${FILE} to the running datastore..."
source /opt/tibit/confd/confdrc
${CONFD_DIR}/bin/confd_load -l -r ${FILE}
if [ "$?" = "0" ]; then
    echo "Success."
else
    echo "Failed."
    exit 1
fi

exit 0
